/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.importation.thesaurus;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.fichotheque.importation.ThesaurusImport;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.tools.importation.ImportationUtils;
import net.fichotheque.tools.importation.thesaurus.ThesaurusImportBuilder;

public class MergeThesaurusImportBuilder
extends ThesaurusImportBuilder {
    private final Map<Integer, InternalMergeMotcleImport> mergeMap = new LinkedHashMap<Integer, InternalMergeMotcleImport>();

    public MergeThesaurusImportBuilder(Thesaurus thesaurus, Thesaurus destinationThesaurus) {
        super(thesaurus, "merge", destinationThesaurus);
    }

    public MergeThesaurusImportBuilder add(Motcle motcle, Motcle destinationMotcle) {
        int motcleId = motcle.getId();
        if (!this.mergeMap.containsKey(motcleId)) {
            this.mergeMap.put(motcleId, new InternalMergeMotcleImport(motcleId, destinationMotcle));
        }
        return this;
    }

    @Override
    protected List<ThesaurusImport.MotcleImport> getMotcleImportList() {
        int p = 0;
        ThesaurusImport.MotcleImport[] array = new ThesaurusImport.MotcleImport[this.mergeMap.size()];
        for (ThesaurusImport.MergeMotcleImport mergeMotcleImport : this.mergeMap.values()) {
            array[p] = mergeMotcleImport;
            ++p;
        }
        return ImportationUtils.wrap(array);
    }

    public MergeThesaurusImportBuilder init(Thesaurus thesaurus, Thesaurus destinationThesaurus) {
        return new MergeThesaurusImportBuilder(thesaurus, destinationThesaurus);
    }

    private static class InternalMergeMotcleImport
    implements ThesaurusImport.MergeMotcleImport {
        private final int motcleId;
        private final Motcle destinationMotcle;

        private InternalMergeMotcleImport(int motcleId, Motcle destinationMotcle) {
            this.motcleId = motcleId;
            this.destinationMotcle = destinationMotcle;
        }

        @Override
        public int getMotcleId() {
            return this.motcleId;
        }

        @Override
        public Motcle getDestinationMotcle() {
            return this.destinationMotcle;
        }
    }
}

