/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.importation.dom;

import java.text.ParseException;
import java.util.function.Consumer;
import net.fichotheque.Fichotheque;
import net.fichotheque.Subset;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.include.IncludeKey;
import net.fichotheque.tools.importation.LabelImportBuilder;
import net.mapeadores.util.text.CleanedString;
import net.mapeadores.util.xml.DOMUtils;
import org.w3c.dom.Element;

public class LabelImportDOMReader {
    private final Fichotheque fichotheque;
    private final LabelImportBuilder labelImportBuilder;

    public LabelImportDOMReader(Fichotheque fichotheque, LabelImportBuilder labelImportBuilder) {
        this.fichotheque = fichotheque;
        this.labelImportBuilder = labelImportBuilder;
    }

    public LabelImportDOMReader read(Element element) {
        DOMUtils.readChildren(element, new RootConsumer());
        return this;
    }

    public static LabelImportDOMReader init(Fichotheque fichotheque, LabelImportBuilder labelImportBuilder) {
        return new LabelImportDOMReader(fichotheque, labelImportBuilder);
    }

    private class RootConsumer
    implements Consumer<Element> {
        private final MetadataConsumer metadataConsumer;
        private final CorpusConsumer corpusConsumer;

        private RootConsumer() {
            this.metadataConsumer = new MetadataConsumer();
            this.corpusConsumer = new CorpusConsumer();
        }

        @Override
        public void accept(Element element) {
            String tagName;
            switch (tagName = element.getTagName()) {
                case "fichotheque": {
                    this.metadataConsumer.setSubset(null);
                    DOMUtils.readChildren(element, this.metadataConsumer);
                    break;
                }
                case "corpus": {
                    Subset subset = this.getSubset(element, (short)1);
                    if (subset == null) break;
                    this.metadataConsumer.setSubset(subset);
                    DOMUtils.readChildren(element, this.metadataConsumer);
                    this.corpusConsumer.setCorpus((Corpus)subset);
                    DOMUtils.readChildren(element, this.corpusConsumer);
                    break;
                }
                case "thesaurus": {
                    Subset subset = this.getSubset(element, (short)2);
                    if (subset == null) break;
                    this.metadataConsumer.setSubset(subset);
                    DOMUtils.readChildren(element, this.metadataConsumer);
                    break;
                }
                case "sphere": {
                    Subset subset = this.getSubset(element, (short)3);
                    if (subset == null) break;
                    this.metadataConsumer.setSubset(subset);
                    DOMUtils.readChildren(element, this.metadataConsumer);
                    break;
                }
                case "album": {
                    Subset subset = this.getSubset(element, (short)5);
                    if (subset == null) break;
                    this.metadataConsumer.setSubset(subset);
                    DOMUtils.readChildren(element, this.metadataConsumer);
                    break;
                }
                case "addenda": {
                    Subset subset = this.getSubset(element, (short)4);
                    if (subset == null) break;
                    this.metadataConsumer.setSubset(subset);
                    DOMUtils.readChildren(element, this.metadataConsumer);
                    break;
                }
            }
        }

        private Subset getSubset(Element element, short category) {
            String name = element.getAttribute("name");
            try {
                SubsetKey subsetKey = SubsetKey.parse(category, name);
                return LabelImportDOMReader.this.fichotheque.getSubset(subsetKey);
            }
            catch (ParseException pe) {
                return null;
            }
        }
    }

    private class CorpusConsumer
    implements Consumer<Element> {
        private Corpus corpus;

        private CorpusConsumer() {
        }

        private void setCorpus(Corpus corpus) {
            this.corpus = corpus;
        }

        @Override
        public void accept(Element element) {
            String tagName = element.getTagName();
            String valueString = DOMUtils.readSimpleElement(element);
            CleanedString value = CleanedString.newInstance(valueString);
            if (tagName.equals("field")) {
                try {
                    FieldKey fieldKey = FieldKey.parse(element.getAttribute("field-key"));
                    LabelImportDOMReader.this.labelImportBuilder.addFieldKeyImport(this.corpus, fieldKey, value);
                }
                catch (ParseException fieldKey) {}
            } else if (tagName.equals("include")) {
                try {
                    IncludeKey includeKey = IncludeKey.parse(element.getAttribute("include-key"));
                    LabelImportDOMReader.this.labelImportBuilder.addIncludeKeyImport(this.corpus, includeKey, value);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        }
    }

    private class MetadataConsumer
    implements Consumer<Element> {
        private Subset subset;

        private MetadataConsumer() {
        }

        private void setSubset(Subset subset) {
            this.subset = subset;
        }

        @Override
        public void accept(Element element) {
            String tagName = element.getTagName();
            if (tagName.equals("phrase")) {
                String name = element.getAttribute("name");
                if (name.length() > 0) {
                    String valueString = DOMUtils.readSimpleElement(element);
                    CleanedString value = CleanedString.newInstance(valueString);
                    if (this.subset == null) {
                        LabelImportDOMReader.this.labelImportBuilder.addFichothequePhrase(name, value);
                    } else {
                        LabelImportDOMReader.this.labelImportBuilder.addSubsetPhrase(this.subset, name, value);
                    }
                }
            } else if (tagName.equals("title")) {
                String valueString = DOMUtils.readSimpleElement(element);
                CleanedString value = CleanedString.newInstance(valueString);
                if (this.subset == null) {
                    LabelImportDOMReader.this.labelImportBuilder.addFichothequePhrase(null, value);
                } else {
                    LabelImportDOMReader.this.labelImportBuilder.addSubsetPhrase(this.subset, null, value);
                }
            }
        }
    }
}

