/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.format.formatters;

import java.io.IOException;
import net.fichotheque.exportation.table.Cell;
import net.fichotheque.format.FormatSource;
import net.fichotheque.format.formatters.MotcleFormatter;
import net.fichotheque.json.MotcleJson;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.tools.format.formatters.FormatterParserUtils;
import net.fichotheque.tools.format.formatters.JsonParameters;
import net.fichotheque.tools.format.formatters.LangParameters;
import net.fichotheque.tools.format.patterndefs.DefaultPattern;
import net.fichotheque.utils.FormatterUtils;
import net.fichotheque.utils.ThesaurusUtils;
import net.mapeadores.util.exceptions.ShouldNotOccurException;
import net.mapeadores.util.instruction.Argument;
import net.mapeadores.util.instruction.Instruction;
import net.mapeadores.util.instruction.InstructionResolver;
import net.mapeadores.util.instruction.InstructionResolverProvider;
import net.mapeadores.util.json.JSONWriter;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.LangContext;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.logging.MessageHandler;
import net.mapeadores.util.text.Label;

public final class MotcleFormatterParser {
    private static final MotcleFormatter ID_PART = (motcle, weight, formatSource) -> String.valueOf(motcle.getId());
    private static final MotcleFormatter IDALPHA_PART = (motcle, weight, formatSource) -> {
        String idalpha = motcle.getIdalpha();
        if (idalpha == null) {
            idalpha = "";
        }
        return idalpha;
    };
    private static final MotcleFormatter IDALPHA_SIGNIFICANT_PART = (motcle, weight, formatSource) -> {
        String idalpha = motcle.getSignificantIdalpha();
        if (idalpha == null) {
            idalpha = "";
        }
        return idalpha;
    };
    private static final MotcleFormatter LANG_PART = (motcle, weight, formatSource) -> {
        if (!motcle.isBabelienType()) {
            return "";
        }
        Label label = motcle.getBabelienLabel();
        return label.getLang().toString();
    };
    private static final MotcleFormatter WEIGHT_PART = (motcle, weight, formatSource) -> String.valueOf(weight);
    private static final MotcleFormatter PARENT_ID_PART = (motcle, weight, formatSource) -> {
        Motcle parent = motcle.getParent();
        if (parent != null) {
            return String.valueOf(parent.getId());
        }
        return "";
    };
    private static final MotcleFormatter PARENT_IDALPHA_PART = (motcle, weight, formatSource) -> {
        String idalpha = null;
        Motcle parentMotcle = motcle.getParent();
        if (parentMotcle != null) {
            idalpha = parentMotcle.getIdalpha();
        }
        if (idalpha == null) {
            idalpha = "";
        }
        return idalpha;
    };
    private static final MotcleFormatter PARENT_IDALPHA_SIGNIFICANT_PART = (motcle, weight, formatSource) -> {
        String idalpha = null;
        Motcle parentMotcle = motcle.getParent();
        if (parentMotcle != null) {
            idalpha = parentMotcle.getSignificantIdalpha();
        }
        if (idalpha == null) {
            idalpha = "";
        }
        return idalpha;
    };
    private static final MotcleFormatter POSITION_PART = (motcle, weight, formatSource) -> String.valueOf(motcle.getChildIndex() + 1);
    private static final MotcleFormatter POSITION_GLOBAL_PART = (motcle, weight, formatSource) -> ThesaurusUtils.getGlobalPosition(motcle);
    private static final MotcleFormatter THESAURUS_PART = (motcle, weight, formatSource) -> motcle.getSubsetName();
    private static final MotcleFormatter WITHWEIGHTFILTER_FORMSYNTAX_FORMATTER = new FormSyntaxPart(true);
    private static final MotcleFormatter WITHOUTWEIGHTFILTER_FORMSYNTAX_FORMATTER = new FormSyntaxPart(false);
    private static final JsonParameters DEFAULT_JSONPARAMETERS = JsonParameters.parse("labels");

    private MotcleFormatterParser() {
    }

    public static MotcleFormatter parse(boolean isIdalpha, String pattern, InstructionResolverProvider provider, boolean withWeightFilter, MessageHandler messageHandler) {
        if (pattern == null) {
            pattern = DefaultPattern.motcle(isIdalpha);
        }
        try {
            return MotcleFormatterParser.parse(pattern, provider, withWeightFilter);
        }
        catch (ErrorMessageException fe) {
            messageHandler.addMessage("severe.format.pattern", fe.getErrorMessage());
            return null;
        }
    }

    public static MotcleFormatter parse(String pattern, InstructionResolverProvider provider, boolean withhWeightFilter) throws ErrorMessageException {
        Object[] partArray = FormatterUtils.parsePattern(new InternalInstructionResolver(provider, withhWeightFilter), pattern);
        return new InternalMotcleFormatter(partArray);
    }

    private static class InternalInstructionResolver
    implements InstructionResolver {
        private final InstructionResolverProvider provider;
        private final boolean withWeightFilter;

        private InternalInstructionResolver(InstructionResolverProvider provider, boolean withWeightFilter) {
            this.provider = provider;
            this.withWeightFilter = withWeightFilter;
        }

        @Override
        public Object resolve(Instruction instruction) throws ErrorMessageException {
            Object formatter;
            InstructionResolver resolver = this.provider.getInstructionResolver(MotcleFormatter.class);
            if (resolver != null && (formatter = resolver.resolve(instruction)) != null) {
                return formatter;
            }
            Argument arg1 = (Argument)instruction.get(0);
            String key = arg1.getKey();
            String value = arg1.getValue();
            if (value == null) {
                value = "";
            }
            switch (key) {
                case "formsyntax": {
                    if (this.withWeightFilter) {
                        return WITHWEIGHTFILTER_FORMSYNTAX_FORMATTER;
                    }
                    return WITHOUTWEIGHTFILTER_FORMSYNTAX_FORMATTER;
                }
                case "idalpha": {
                    switch (value) {
                        case "significant": {
                            return IDALPHA_SIGNIFICANT_PART;
                        }
                    }
                    return IDALPHA_PART;
                }
                case "idalpha_significant": {
                    return IDALPHA_SIGNIFICANT_PART;
                }
                case "id": 
                case "idths": {
                    return ID_PART;
                }
                case "json": {
                    JsonParameters jsonParameters = JsonParameters.fromInstruction(instruction);
                    if (jsonParameters == null) {
                        jsonParameters = DEFAULT_JSONPARAMETERS;
                    }
                    LangParameters langParameters = LangParameters.fromInstruction(instruction, "langs");
                    return new JsonPart(jsonParameters, langParameters.getCustomLangContext());
                }
                case "label": 
                case "lib": {
                    return new LabelPart(LangParameters.fromInstruction(instruction, key));
                }
                case "lang": {
                    return LANG_PART;
                }
                case "weight": 
                case "poids": {
                    return WEIGHT_PART;
                }
                case "position": {
                    switch (value) {
                        case "global": {
                            return POSITION_GLOBAL_PART;
                        }
                    }
                    return POSITION_PART;
                }
                case "pos_loc": {
                    return POSITION_PART;
                }
                case "pos_glob": {
                    return POSITION_GLOBAL_PART;
                }
                case "parent_id": 
                case "parent_idths": {
                    return PARENT_ID_PART;
                }
                case "parent_idalpha": {
                    switch (value) {
                        case "significant": {
                            return PARENT_IDALPHA_SIGNIFICANT_PART;
                        }
                    }
                    return PARENT_IDALPHA_PART;
                }
                case "parent_idalpha_significant": {
                    return PARENT_IDALPHA_SIGNIFICANT_PART;
                }
                case "thesaurus": {
                    return THESAURUS_PART;
                }
            }
            return null;
        }
    }

    private static class InternalMotcleFormatter
    implements MotcleFormatter {
        private final Object[] partArray;

        private InternalMotcleFormatter(Object[] partArray) {
            this.partArray = partArray;
        }

        @Override
        public String formatMotcle(Motcle motcle, int weight, FormatSource formatSource) {
            StringBuilder buf = new StringBuilder();
            for (Object obj : this.partArray) {
                if (obj instanceof String) {
                    buf.append((String)obj);
                    continue;
                }
                MotcleFormatter formatter = (MotcleFormatter)obj;
                buf.append(formatter.formatMotcle(motcle, weight, formatSource));
            }
            return buf.toString();
        }
    }

    private static class FormSyntaxPart
    implements MotcleFormatter {
        private final boolean withWeightFilter;

        private FormSyntaxPart(boolean withWeightFilter) {
            this.withWeightFilter = withWeightFilter;
        }

        @Override
        public String formatMotcle(Motcle motcle, int weight, FormatSource formatSource) {
            if (this.withWeightFilter || weight == 1) {
                String idalpha = motcle.getIdalpha();
                if (idalpha != null) {
                    return idalpha;
                }
                return String.valueOf(motcle.getId());
            }
            StringBuilder buf = new StringBuilder();
            String idalpha = motcle.getIdalpha();
            if (idalpha != null) {
                buf.append(idalpha);
            } else {
                buf.append(String.valueOf(motcle.getId()));
            }
            buf.append(" <");
            buf.append(weight);
            buf.append(">");
            return buf.toString();
        }
    }

    private static class JsonPart
    implements MotcleFormatter {
        private final JsonParameters jsonParameters;
        private final LangContext customLangContext;

        private JsonPart(JsonParameters jsonParameters, LangContext customLangContext) {
            this.jsonParameters = jsonParameters;
            this.customLangContext = customLangContext;
        }

        @Override
        public String formatMotcle(Motcle motcle, int weight, FormatSource formatSource) {
            Cell[] cellArray = FormatterParserUtils.resolve(motcle, this.jsonParameters, formatSource);
            LangContext langContext = this.customLangContext != null ? this.customLangContext : formatSource.getLangContext();
            StringBuilder buf = new StringBuilder();
            JSONWriter jsonWriter = new JSONWriter(buf);
            try {
                jsonWriter.object();
                MotcleJson.properties(jsonWriter, motcle, langContext, this.jsonParameters, cellArray);
                jsonWriter.endObject();
            }
            catch (IOException ioe) {
                throw new ShouldNotOccurException(ioe);
            }
            return buf.toString();
        }
    }

    private static class LabelPart
    implements MotcleFormatter {
        private final LangParameters langParameters;

        private LabelPart(LangParameters langParameters) {
            this.langParameters = langParameters;
        }

        @Override
        public String formatMotcle(Motcle motcle, int weight, FormatSource formatSource) {
            Lang[] array;
            StringBuilder buf = new StringBuilder();
            for (Lang lang : array = LangParameters.checkLangArray(this.langParameters, formatSource)) {
                Label label = motcle.getLabels().getLangPartCheckedLabel(lang);
                if (label == null) continue;
                if (buf.length() > 0) {
                    buf.append(this.langParameters.getSeparator());
                }
                buf.append(label.getLabelString());
            }
            return buf.toString();
        }
    }
}

