/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.exportation.table.columnsum;

import net.fichotheque.exportation.table.ColDef;
import net.fichotheque.exportation.table.SumResult;
import net.fichotheque.tools.exportation.table.columnsum.ColumnSumBuilder;
import net.fichotheque.tools.exportation.table.columnsum.DecimalColumnSumBuilder;
import net.fichotheque.tools.exportation.table.columnsum.IntegerColumnSumBuilder;
import net.fichotheque.tools.exportation.table.columnsum.MoneyColumnSumBuilder;
import net.fichotheque.tools.exportation.table.columnsum.PercentageColumnSumBuilder;
import net.mapeadores.util.money.Amount;
import net.mapeadores.util.primitives.Decimal;

public class ColumnSumEngine {
    private final boolean withColumnSum;
    private final ColumnSumBuilder[] builderArray;

    public ColumnSumEngine(ColDef[] colDefArray) {
        int count = colDefArray.length;
        boolean with = false;
        this.builderArray = new ColumnSumBuilder[count];
        for (int i = 0; i < count; ++i) {
            ColumnSumBuilder builder;
            ColDef colDef = colDefArray[i];
            if (!colDef.isWithColumnSum()) continue;
            this.builderArray[i] = builder = this.initBuilder(colDef.getCastType());
            if (builder == null) continue;
            with = true;
        }
        this.withColumnSum = with;
    }

    private ColumnSumBuilder initBuilder(String castType) {
        switch (castType) {
            case "integer": {
                return new IntegerColumnSumBuilder();
            }
            case "decimal": {
                return new DecimalColumnSumBuilder();
            }
            case "percentage": {
                return new PercentageColumnSumBuilder();
            }
            case "money": {
                return new MoneyColumnSumBuilder();
            }
        }
        return null;
    }

    public boolean hasColumnSum() {
        return this.withColumnSum;
    }

    public SumResult.ColumnSum[] getResult() {
        if (this.withColumnSum) {
            int count = this.builderArray.length;
            SumResult.ColumnSum[] result = new SumResult.ColumnSum[count];
            for (int i = 0; i < count; ++i) {
                ColumnSumBuilder builder = this.builderArray[i];
                result[i] = builder != null ? builder.toColumnSum() : null;
            }
            return result;
        }
        return null;
    }

    public void sumInteger(int colIndex, long lg) {
        ColumnSumBuilder builder = this.builderArray[colIndex];
        if (builder != null) {
            ((IntegerColumnSumBuilder)builder).sum(lg);
        }
    }

    public void sumDecimal(int colIndex, Decimal decimal) {
        ColumnSumBuilder builder = this.builderArray[colIndex];
        if (builder != null) {
            ((DecimalColumnSumBuilder)builder).sum(decimal);
        }
    }

    public void sumPercentage(int colIndex, Decimal decimal) {
        ColumnSumBuilder builder = this.builderArray[colIndex];
        if (builder != null) {
            ((PercentageColumnSumBuilder)builder).sum(decimal);
        }
    }

    public void sumMoney(int colIndex, Amount amount) {
        ColumnSumBuilder builder = this.builderArray[colIndex];
        if (builder != null) {
            ((MoneyColumnSumBuilder)builder).sum(amount);
        }
    }
}

