/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.exportation.table;

import java.util.ArrayList;
import java.util.List;
import net.fichotheque.exportation.table.JunctionTable;
import net.fichotheque.exportation.table.SubsetTable;
import net.fichotheque.exportation.table.TableExport;
import net.fichotheque.exportation.table.TableExportDef;
import net.fichotheque.utils.TableExportUtils;

public class TableExportBuilder {
    private final List<SubsetTable> subsetTableList = new ArrayList<SubsetTable>();
    private final List<JunctionTable> junctionTableList = new ArrayList<JunctionTable>();
    private TableExportDef tableExportDef;

    public TableExportBuilder setTableExportDef(TableExportDef tableExportDef) {
        this.tableExportDef = tableExportDef;
        return this;
    }

    public TableExportBuilder addSubsetTable(SubsetTable subsetTable) {
        if (subsetTable == null) {
            throw new IllegalArgumentException("subsetTable is null");
        }
        this.subsetTableList.add(subsetTable);
        return this;
    }

    public TableExportBuilder addJunctionTable(JunctionTable junctionTable) {
        if (junctionTable == null) {
            throw new IllegalArgumentException("subsetTable is null");
        }
        this.junctionTableList.add(junctionTable);
        return this;
    }

    public TableExport toTableExport() {
        List<SubsetTable> finalSubsetTableList = TableExportUtils.wrap(this.subsetTableList.toArray(new SubsetTable[this.subsetTableList.size()]));
        List<JunctionTable> finalJunctionTableList = TableExportUtils.wrap(this.junctionTableList.toArray(new JunctionTable[this.junctionTableList.size()]));
        return new InternalTableExport(this.tableExportDef, finalSubsetTableList, finalJunctionTableList);
    }

    public static TableExportBuilder init() {
        return new TableExportBuilder();
    }

    private static class InternalTableExport
    implements TableExport {
        private final TableExportDef tableExportDef;
        private final List<SubsetTable> subsetTableList;
        private final List<JunctionTable> junctionTableList;

        private InternalTableExport(TableExportDef tableExportDef, List<SubsetTable> subsetTableList, List<JunctionTable> junctionTableList) {
            this.tableExportDef = tableExportDef;
            this.subsetTableList = subsetTableList;
            this.junctionTableList = junctionTableList;
        }

        @Override
        public TableExportDef getTableExportDef() {
            return this.tableExportDef;
        }

        @Override
        public List<SubsetTable> getSubsetTableList() {
            return this.subsetTableList;
        }

        @Override
        public List<JunctionTable> getJunctionTableList() {
            return this.junctionTableList;
        }
    }
}

