/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.thesaurus;

import java.util.List;
import net.fichotheque.SubsetItem;
import net.fichotheque.SubsetKey;
import net.fichotheque.thesaurus.MotcleIcon;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.utils.JunctionUtils;
import net.mapeadores.util.exceptions.ImplementationException;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.text.Idalpha;
import net.mapeadores.util.text.Label;
import net.mapeadores.util.text.Labels;

public interface Motcle
extends SubsetItem {
    public Motcle getParent();

    public MotcleIcon getMotcleIcon();

    public List<Motcle> getChildList();

    public int getChildIndex();

    public String getIdalpha();

    public int getLevel();

    public String getStatus();

    public Labels getLabels();

    default public Thesaurus getThesaurus() {
        return (Thesaurus)this.getSubset();
    }

    default public boolean isBabelienType() {
        return ((Thesaurus)this.getSubset()).isBabelienType();
    }

    default public Label getBabelienLabel() {
        if (!this.isBabelienType()) {
            throw new UnsupportedOperationException("motcle.getThesaurus is not babelien");
        }
        Labels labels = this.getLabels();
        if (labels.isEmpty()) {
            throw new ImplementationException("motcle.getLabelCount() == 0 in a bab\u00e9lien thesaurus");
        }
        return (Label)labels.get(0);
    }

    default public String getLabelString(Lang lang) {
        return this.getLabelString(lang, "?");
    }

    default public String getLabelString(Lang lang, String defaultString) {
        if (this.isBabelienType()) {
            return this.getBabelienLabel().getLabelString();
        }
        return this.getLabels().seekLabelString(lang, defaultString);
    }

    default public String getSignificantIdalpha() {
        String idalpha = this.getIdalpha();
        if (Idalpha.isSignificant(idalpha)) {
            return idalpha;
        }
        return null;
    }

    default public boolean shouldNotJunction(SubsetKey subsetKey) {
        switch (this.getStatus()) {
            case "group": 
            case "obsolete": {
                return true;
            }
        }
        return JunctionUtils.isShouldNotJunction(this, subsetKey);
    }

    default public boolean isDescendantOf(Motcle ancestor) {
        for (Motcle parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!parent.equals(ancestor)) continue;
            return true;
        }
        return false;
    }

    default public Motcle getNextSibling() {
        List<Motcle> siblingList;
        int childIndex = this.getChildIndex();
        Motcle parent = this.getParent();
        List<Motcle> list = siblingList = parent != null ? parent.getChildList() : this.getThesaurus().getFirstLevelList();
        if (childIndex < siblingList.size() - 1) {
            return siblingList.get(childIndex + 1);
        }
        return null;
    }

    default public Motcle getPreviousSibling() {
        int childIndex = this.getChildIndex();
        if (childIndex == 0) {
            return null;
        }
        Motcle parent = this.getParent();
        List<Motcle> siblingList = parent != null ? parent.getChildList() : this.getThesaurus().getFirstLevelList();
        return siblingList.get(childIndex - 1);
    }

    default public Motcle getNext() {
        List<Motcle> childList = this.getChildList();
        if (childList.size() > 0) {
            return childList.get(0);
        }
        Motcle sibling = this.getNextSibling();
        if (sibling != null) {
            return sibling;
        }
        for (Motcle parent = this.getParent(); parent != null; parent = parent.getParent()) {
            sibling = parent.getNextSibling();
            if (sibling == null) continue;
            return sibling;
        }
        return null;
    }

    default public Motcle getPrevious() {
        Motcle previous = this.getPreviousSibling();
        if (previous == null) {
            return this.getParent();
        }
        List<Motcle> childList = previous.getChildList();
        while (!childList.isEmpty()) {
            previous = childList.get(childList.size() - 1);
            childList = previous.getChildList();
        }
        return previous;
    }
}

