/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.corpus.metadata;

import java.io.Serializable;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import net.mapeadores.util.text.StringUtils;

public final class FieldKey
implements Serializable {
    private static final Map<String, FieldKey> internMap = new HashMap<String, FieldKey>();
    public static final String SPECIAL_ID = "id";
    public static final String SPECIAL_TITLE = "title";
    public static final String SPECIAL_SUBTITLE = "subtitle";
    public static final String SPECIAL_LANG = "lang";
    public static final String SPECIAL_OWNERS = "owners";
    public static final short SPECIAL_CATEGORY = 0;
    public static final short PROP_CATEGORY = 1;
    public static final short INFO_CATEGORY = 2;
    public static final short SECTION_CATEGORY = 3;
    public static final String SPECIAL_CATEGORY_STRING = "special";
    public static final String PROP_CATEGORY_STRING = "prop";
    public static final String INFO_CATEGORY_STRING = "info";
    public static final String SECTION_CATEGORY_STRING = "section";
    private final String fieldKeyString;
    private final short category;
    private final String fieldName;
    public static final FieldKey ID = new FieldKey("id");
    public static final FieldKey TITLE = new FieldKey("title");
    public static final FieldKey SUBTITLE = new FieldKey("subtitle");
    public static final FieldKey LANG = new FieldKey("lang");
    public static final FieldKey OWNERS = new FieldKey("owners");

    private FieldKey(String fieldKeyString) {
        this.fieldKeyString = fieldKeyString;
        this.category = 0;
        this.fieldName = "";
        FieldKey.intern(this);
    }

    private FieldKey(String fieldKeyString, String fieldName, short category) {
        this.fieldKeyString = fieldKeyString;
        this.fieldName = fieldName;
        this.category = category;
        FieldKey.intern(this);
    }

    private static synchronized void intern(FieldKey fieldKey) {
        internMap.put(fieldKey.fieldKeyString, fieldKey);
    }

    public static FieldKey parse(String s) throws ParseException {
        switch (s) {
            case "texte": {
                s = "section_texte";
                break;
            }
            case "idcorpus": {
                s = SPECIAL_ID;
                break;
            }
            case "titre": {
                s = SPECIAL_TITLE;
                break;
            }
            case "users": 
            case "redacteurs": {
                s = SPECIAL_OWNERS;
                break;
            }
            case "soustitre": {
                s = SPECIAL_SUBTITLE;
            }
        }
        FieldKey current = internMap.get(s);
        if (current != null) {
            return current;
        }
        int idx = s.indexOf(95);
        if (idx > 0) {
            String category = s.substring(0, idx);
            String fieldName = s.substring(idx + 1);
            StringUtils.checkTechnicalName(fieldName, false);
            switch (category) {
                case "prop": 
                case "propriete": 
                case "property": {
                    return new FieldKey("prop_" + fieldName, fieldName, 1);
                }
                case "info": 
                case "information": {
                    return new FieldKey("info_" + fieldName, fieldName, 2);
                }
                case "annexe": 
                case "section": {
                    return new FieldKey("section_" + fieldName, fieldName, 3);
                }
            }
        }
        throw new ParseException("unkown fieldkey", 0);
    }

    public static FieldKey parse(short category, String fieldName) throws ParseException {
        StringUtils.checkTechnicalName(fieldName, false);
        return new FieldKey(FieldKey.categoryToString(category) + "_" + fieldName, fieldName, category);
    }

    public static FieldKey build(String s) {
        try {
            return FieldKey.parse(s);
        }
        catch (ParseException pe) {
            throw new IllegalArgumentException(pe.getMessage());
        }
    }

    public static FieldKey build(short category, String fieldName) {
        try {
            return FieldKey.parse(category, fieldName);
        }
        catch (ParseException pe) {
            throw new IllegalArgumentException(pe.getMessage());
        }
    }

    public String getKeyString() {
        return this.fieldKeyString;
    }

    public String toString() {
        return this.fieldKeyString;
    }

    public boolean isSpecial() {
        return this.category == 0;
    }

    public boolean isProp() {
        return this.category == 1;
    }

    public boolean isInfo() {
        return this.category == 2;
    }

    public boolean isSection() {
        return this.category == 3;
    }

    public short getCategory() {
        return this.category;
    }

    public boolean isMandatoryField() {
        if (this.category != 0) {
            return false;
        }
        return !this.fieldKeyString.equals(SPECIAL_SUBTITLE);
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public int hashCode() {
        return this.fieldKeyString.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FieldKey)) {
            return false;
        }
        FieldKey fk = (FieldKey)obj;
        return fk.fieldKeyString.equals(this.fieldKeyString);
    }

    public static String categoryToString(short category) {
        switch (category) {
            case 0: {
                return SPECIAL_CATEGORY_STRING;
            }
            case 1: {
                return PROP_CATEGORY_STRING;
            }
            case 2: {
                return INFO_CATEGORY_STRING;
            }
            case 3: {
                return SECTION_CATEGORY_STRING;
            }
        }
        throw new IllegalArgumentException("wrong Field category value");
    }

    public static short categoryToShort(String s) {
        switch (s) {
            case "prop": 
            case "propriete": 
            case "property": {
                return 1;
            }
            case "info": 
            case "information": {
                return 2;
            }
            case "annexe": 
            case "section": {
                return 3;
            }
            case "special": {
                return 0;
            }
        }
        throw new IllegalArgumentException("Wrong category string");
    }
}

