/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.corpus.fiche;

import java.io.Serializable;
import net.fichotheque.corpus.fiche.FicheItem;
import net.mapeadores.util.money.ExtendedCurrency;
import net.mapeadores.util.money.MoneyLong;
import net.mapeadores.util.primitives.Decimal;

public final class AmountItem
implements FicheItem,
Serializable {
    private static final long serialVersionUID = 5L;
    private Decimal decimal;
    private ExtendedCurrency currency;

    public AmountItem(Decimal decimal, ExtendedCurrency currency) {
        if (decimal == null) {
            throw new IllegalArgumentException("decimal argument is null");
        }
        this.decimal = decimal;
        this.currency = currency;
    }

    public ExtendedCurrency getCurrency() {
        return this.currency;
    }

    public int hashCode() {
        return this.decimal.hashCode();
    }

    public String toString() {
        return this.decimal.toString() + " " + this.currency.getCurrencyCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AmountItem)) {
            return false;
        }
        AmountItem other = (AmountItem)obj;
        if (!other.currency.equals(this.currency)) {
            return false;
        }
        return other.decimal.equals(this.decimal);
    }

    public Decimal getDecimal() {
        return this.decimal;
    }

    public long toMoneyLong() {
        return MoneyLong.toMoneyLong(this.decimal, this.currency.getDefaultFractionDigits());
    }
}

