/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.xml.dyn;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.libscol.LibsColKey;
import fr.exemole.bdfserver.api.ui.CommentUi;
import fr.exemole.bdfserver.api.ui.IncludeUi;
import fr.exemole.bdfserver.api.ui.UiComponent;
import fr.exemole.bdfserver.api.ui.UiComponents;
import fr.exemole.bdfserver.tools.L10nUtils;
import fr.exemole.bdfserver.tools.ui.UiUtils;
import fr.exemole.bdfserver.xml.dyn.LibsXMLPart;
import java.io.IOException;
import java.util.List;
import net.fichotheque.Fichotheque;
import net.fichotheque.Subset;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.Corpus;
import net.mapeadores.util.exceptions.SwitchException;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.xml.AppendableXMLWriter;
import net.mapeadores.util.xml.XMLPart;
import net.mapeadores.util.xml.XMLUtils;
import net.mapeadores.util.xml.XMLWriter;

public class LibsColXMLPart
extends XMLPart {
    private final LibsXMLPart libsXMLWriter;
    private final Lang lang;
    private final BdfServer bdfServer;
    private final Fichotheque fichotheque;

    public LibsColXMLPart(XMLWriter xmlWriter, BdfServer bdfServer, Lang lang) {
        super(xmlWriter);
        this.lang = lang;
        this.libsXMLWriter = new LibsXMLPart(xmlWriter, lang);
        this.bdfServer = bdfServer;
        this.fichotheque = bdfServer.getFichotheque();
    }

    public void appendLibsCol(LibsColKey libsColKey) throws IOException {
        this.openTag("libscol");
        if (libsColKey.isFromSubset()) {
            SubsetKey subsetKey = libsColKey.getSubsetKey();
            Subset subset = this.bdfServer.getFichotheque().getSubset(subsetKey);
            if (subset instanceof Corpus) {
                this.appendCorpus((Corpus)subset);
            }
        } else if (libsColKey.equals(LibsColKey.ALLCORPUS)) {
            this.appendAllCorpus();
        } else {
            throw new SwitchException("Unknown libsColKey = " + libsColKey.toString());
        }
        this.closeTag("libscol");
    }

    private void appendAllCorpus() throws IOException {
        for (Corpus corpus : this.fichotheque.getCorpusList()) {
            this.appendCorpus(corpus);
        }
    }

    private void appendCorpus(Corpus corpus) throws IOException {
        this.libsXMLWriter.appendCorpusLibs(corpus.getCorpusMetadata());
        UiComponents uiComponents = this.bdfServer.getUiManager().getMainUiComponents(corpus);
        this.appendUiComponents(corpus.getSubsetName(), uiComponents);
    }

    private void appendUiComponents(String corpusName, UiComponents uiComponents) throws IOException {
        this.startOpenTag("libs");
        this.addAttribute("category", "corpusui");
        this.addAttribute("corpus", corpusName);
        this.endOpenTag();
        for (UiComponent uiComponent : uiComponents.getUiComponentList()) {
            if (!(uiComponent instanceof IncludeUi)) continue;
            IncludeUi includeUi = (IncludeUi)uiComponent;
            String labelString = L10nUtils.getIncludeTitle(this.bdfServer, includeUi, this.lang);
            if (labelString == null) {
                labelString = includeUi.getName();
            }
            this.appendIncludeUiLib(includeUi.getName(), labelString);
            if (!includeUi.getName().equals("parentage")) continue;
            this.appendIncludeUiLib("rattachement", labelString);
        }
        this.appendSpecialIncludeUiLib("date_creation");
        this.appendSpecialIncludeUiLib("date_modification");
        List<CommentUi> commentList = UiUtils.getCommentUiList(uiComponents);
        for (CommentUi commentUi : commentList) {
            this.appendCommentUiLib(commentUi.getCommentName(), commentUi.getHtmlByLang(this.lang));
        }
        this.closeTag("libs");
    }

    private void appendSpecialIncludeUiLib(String includeKeyString) throws IOException {
        String labelString = L10nUtils.getSpecialIncludeTitle(this.bdfServer, includeKeyString, this.lang);
        if (labelString == null) {
            labelString = includeKeyString;
        }
        this.appendIncludeUiLib(includeKeyString, labelString);
    }

    private void appendIncludeUiLib(String includeKeyString, String labelString) throws IOException {
        this.startOpenTag("lib");
        this.addAttribute("include-key", includeKeyString);
        this.endOpenTag();
        this.addText(labelString);
        this.closeTag("lib", false);
    }

    private void appendCommentUiLib(String commentName, CharSequence labelString) throws IOException {
        this.startOpenTag("lib");
        this.addAttribute("comment-name", commentName);
        this.endOpenTag();
        this.addText(labelString);
        this.closeTag("lib", false);
    }

    public static String getLibsColXML(Lang lang, BdfServer bdfServer, LibsColKey libsColKey, boolean withTabs) {
        StringBuilder buf = new StringBuilder(1024);
        AppendableXMLWriter xmlWriter = XMLUtils.toXMLWriter(buf, withTabs ? 0 : -999);
        try {
            xmlWriter.appendXMLDeclaration();
            LibsColXMLPart libsColXMLPart = new LibsColXMLPart(xmlWriter, bdfServer, lang);
            libsColXMLPart.appendLibsCol(libsColKey);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return buf.toString();
    }
}

