/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.ui.dom;

import fr.exemole.bdfserver.api.ui.UiComponent;
import fr.exemole.bdfserver.tools.ui.UiComponentFilterBuilder;
import fr.exemole.bdfserver.tools.ui.components.UiDOMUtils;
import net.mapeadores.util.html.HtmlCleaner;
import net.mapeadores.util.logging.MessageHandler;
import net.mapeadores.util.xml.DomMessages;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class UiComponentFilterDOMReader {
    private final UiComponentFilterBuilder builder;
    private final HtmlCleaner htmlCleaner;
    private final MessageHandler messageHandler;

    public UiComponentFilterDOMReader(UiComponentFilterBuilder builder, HtmlCleaner htmlCleaner, MessageHandler messageHandler) {
        this.builder = builder;
        this.messageHandler = messageHandler;
        this.htmlCleaner = htmlCleaner;
    }

    public void readComponentUiFilter(Element element_xml) {
        NodeList liste = element_xml.getChildNodes();
        for (int i = 0; i < liste.getLength(); ++i) {
            Node nd = liste.item(i);
            if (nd.getNodeType() != 1) continue;
            Element element = (Element)liste.item(i);
            String tagName = element.getTagName();
            if (tagName.equals("exclude")) {
                this.readExclude(element);
                continue;
            }
            if (tagName.equals("replace")) {
                this.readReplace(element);
                continue;
            }
            DomMessages.unknownTagWarning(this.messageHandler, tagName);
        }
    }

    private void readReplace(Element element_xml) {
        NodeList liste = element_xml.getChildNodes();
        for (int i = 0; i < liste.getLength(); ++i) {
            Element element;
            UiComponent componentUi;
            Node nd = liste.item(i);
            if (nd.getNodeType() != 1 || (componentUi = this.readUiComponent(element = (Element)liste.item(i))) == null) continue;
            this.builder.replaceUiComponent(componentUi);
        }
    }

    private void readExclude(Element element_xml) {
        NodeList liste = element_xml.getChildNodes();
        for (int i = 0; i < liste.getLength(); ++i) {
            Element element;
            UiComponent componentUi;
            Node nd = liste.item(i);
            if (nd.getNodeType() != 1 || (componentUi = this.readUiComponent(element = (Element)liste.item(i))) == null) continue;
            this.builder.excludeUiComponent(componentUi);
        }
    }

    private UiComponent readUiComponent(Element element) {
        String tagName;
        switch (tagName = element.getTagName()) {
            case "field-ui": {
                return UiDOMUtils.readFieldUi(element, this.messageHandler, "field-ui");
            }
            case "subset-ui": {
                return UiDOMUtils.readSubsetIncludeUi(element, this.messageHandler, "subset-ui");
            }
            case "special-ui": {
                return UiDOMUtils.readSpecialIncludeUi(element, this.messageHandler, "special-ui");
            }
            case "comment-def": {
                return UiDOMUtils.readCommentUi(element, this.htmlCleaner, this.messageHandler, "comment-def");
            }
            case "data-ui": {
                return UiDOMUtils.readDataUi(element, this.messageHandler, "data-ui");
            }
        }
        DomMessages.unknownTagWarning(this.messageHandler, tagName);
        return null;
    }
}

