/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.ui.components;

import fr.exemole.bdfserver.api.ui.CommentUi;
import java.text.ParseException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.mapeadores.util.annotation.Nullable;
import net.mapeadores.util.attr.AttributeChangeBuilder;
import net.mapeadores.util.attr.Attributes;
import net.mapeadores.util.html.HtmlCleaner;
import net.mapeadores.util.html.TrustedHtml;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.Langs;
import net.mapeadores.util.localisation.LangsUtils;

public class CommentUiBuilder {
    private final HtmlCleaner htmlCleaner;
    private final Map<Lang, TrustedHtml> htmlMap = new LinkedHashMap<Lang, TrustedHtml>();
    private final AttributeChangeBuilder attributeChangeBuilder = new AttributeChangeBuilder();
    private final Attributes previousAttributes;
    private final String name;
    private int location = 3;

    public CommentUiBuilder(HtmlCleaner htmlCleaner, String name) {
        this(htmlCleaner, name, null);
    }

    public CommentUiBuilder(HtmlCleaner htmlCleaner, String name, @Nullable Attributes previousAttributes) {
        try {
            CommentUi.checkCommentName(name);
        }
        catch (ParseException pe) {
            throw new IllegalArgumentException("Wrong name: " + name);
        }
        this.htmlCleaner = htmlCleaner;
        this.name = name;
        this.previousAttributes = previousAttributes;
    }

    public CommentUiBuilder(HtmlCleaner htmlCleaner, CommentUi commentUi) {
        this.htmlCleaner = htmlCleaner;
        this.name = commentUi.getCommentName();
        this.previousAttributes = commentUi.getAttributes();
        this.location = commentUi.getLocation();
        for (Lang lang : commentUi.getLangs()) {
            this.htmlMap.put(lang, commentUi.getHtmlByLang(lang));
        }
    }

    public CommentUiBuilder setLocation(int location) {
        if (location < 1 || location > 3) {
            location = 3;
        }
        this.location = location;
        return this;
    }

    public CommentUiBuilder putHtml(Lang lang, String htmlString) {
        if (htmlString == null || htmlString.length() == 0) {
            this.htmlMap.remove(lang);
        } else {
            this.putHtml(lang, this.htmlCleaner.cleanHtml(htmlString));
        }
        return this;
    }

    public CommentUiBuilder putHtml(Lang lang, TrustedHtml html) {
        if (html == null || html.length() == 0) {
            this.htmlMap.remove(lang);
        } else {
            this.htmlMap.put(lang, html);
        }
        return this;
    }

    public AttributeChangeBuilder getAttributeChangeBuilder() {
        return this.attributeChangeBuilder;
    }

    public CommentUi toCommentUi() {
        if (this.name == null) {
            throw new IllegalStateException("name is null");
        }
        int size = this.htmlMap.size();
        Lang[] langArray = new Lang[size];
        HashMap<Lang, TrustedHtml> finalMap = new HashMap<Lang, TrustedHtml>();
        int p = 0;
        for (Map.Entry<Lang, TrustedHtml> entry : this.htmlMap.entrySet()) {
            langArray[p] = entry.getKey();
            finalMap.put(entry.getKey(), entry.getValue());
            ++p;
        }
        return new InternalCommentUi(this.name, LangsUtils.wrap(langArray), finalMap, this.location, this.attributeChangeBuilder.toAttributes(this.previousAttributes));
    }

    public static CommentUiBuilder init(HtmlCleaner htmlCleaner, String name) {
        return new CommentUiBuilder(htmlCleaner, name, null);
    }

    public static CommentUiBuilder init(HtmlCleaner htmlCleaner, String name, Attributes attributes) {
        return new CommentUiBuilder(htmlCleaner, name, attributes);
    }

    public static CommentUiBuilder init(HtmlCleaner htmlCleaner, CommentUi commentUi) {
        return new CommentUiBuilder(htmlCleaner, commentUi);
    }

    private static class InternalCommentUi
    implements CommentUi {
        private final Map<Lang, TrustedHtml> htmlMap;
        private final Langs langs;
        private final String name;
        private final int location;
        private final Attributes attributes;

        public InternalCommentUi(String name, Langs langs, Map<Lang, TrustedHtml> htmlMap, int location, Attributes attributes) {
            this.name = name;
            this.langs = langs;
            this.htmlMap = htmlMap;
            this.location = location;
            this.attributes = attributes;
        }

        @Override
        public int getLocation() {
            return this.location;
        }

        @Override
        public String getCommentName() {
            return this.name;
        }

        @Override
        public String getName() {
            return CommentUi.toComponentName(this.name);
        }

        @Override
        public Langs getLangs() {
            return this.langs;
        }

        @Override
        public TrustedHtml getHtmlByLang(Lang lang) {
            return this.htmlMap.get(lang);
        }

        @Override
        public Attributes getAttributes() {
            return this.attributes;
        }
    }
}

