/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.jslib;

import fr.exemole.bdfserver.tools.storage.StorageUtils;
import java.util.Map;
import java.util.SortedMap;
import net.mapeadores.util.io.ResourceStorages;
import net.mapeadores.util.jslib.JsLib;
import net.mapeadores.util.jslib.JsLibBuilder;
import net.mapeadores.util.jslib.TemplateFamily;
import net.mapeadores.util.jslib.TemplateFamilyBuilder;
import net.mapeadores.util.jslib.ThirdLib;
import net.mapeadores.util.jslib.ThirdLibBuilder;
import net.mapeadores.util.text.RelativePath;

public class BdfJsLibBuilder
extends JsLibBuilder {
    private static final TemplateFamily BDF_TEMPLATEFAMILY = TemplateFamilyBuilder.init("bdf").toTemplateFamily();
    private String currentExtensionName = null;
    private boolean templateAdded = false;

    public BdfJsLibBuilder setCurrentExtensionName(String currentExtensionName) {
        this.currentExtensionName = currentExtensionName;
        return this;
    }

    @Override
    public BdfJsLibBuilder addCssPath(RelativePath cssPath) {
        super.addCssPath(cssPath);
        return this;
    }

    @Override
    public BdfJsLibBuilder addDependency(JsLib dependency) {
        super.addDependency(dependency);
        return this;
    }

    @Override
    public BdfJsLibBuilder addJsScript(RelativePath relativePath) {
        super.addJsScript(relativePath);
        return this;
    }

    @Override
    public BdfJsLibBuilder addThirdLib(ThirdLib thirdLib) {
        super.addThirdLib(thirdLib);
        return this;
    }

    @Override
    public BdfJsLibBuilder addTemplateFamily(TemplateFamily templateFamily) {
        this.testTemplateAdd();
        super.addTemplateFamily(templateFamily);
        return this;
    }

    public BdfJsLibBuilder addThemeCss(String ... cssThemeFile) {
        for (String value : cssThemeFile) {
            this.addCssPath(RelativePath.build("theme/css/" + value));
        }
        return this;
    }

    public BdfJsLibBuilder addExtensionThemeCss(String extensionName, String ... cssThemeFile) {
        for (String value : cssThemeFile) {
            this.addCssPath(StorageUtils.buildExtensionResourcePath(extensionName, "theme/css/" + value));
        }
        return this;
    }

    public BdfJsLibBuilder addThirdLib(String name, String ... extensionNames) {
        ThirdLibBuilder builder = new ThirdLibBuilder(name);
        if (extensionNames != null) {
            for (String extensionName : extensionNames) {
                builder.addExtension(extensionName);
            }
        }
        this.addThirdLib(builder.toThirdLib());
        return this;
    }

    public BdfJsLibBuilder addJs(String jsPath) {
        RelativePath relativePath = RelativePath.build("js/" + jsPath);
        this.addJsScript(relativePath);
        return this;
    }

    public BdfJsLibBuilder addExtensionJs(String jsPath) {
        if (this.currentExtensionName == null) {
            throw new IllegalStateException("currentExtensionName is null");
        }
        RelativePath relativePath = StorageUtils.buildExtensionResourcePath(this.currentExtensionName, "js/" + jsPath);
        this.addJsScript(relativePath);
        return this;
    }

    public BdfJsLibBuilder addTemplateFamily(String familyName) {
        this.addTemplateFamily(TemplateFamilyBuilder.init(familyName).toTemplateFamily());
        return this;
    }

    public BdfJsLibBuilder scanJavascriptFolder(ResourceStorages resourceStorages, RelativePath jsFolder) {
        SortedMap<String, RelativePath> resourcesMap = resourceStorages.listResources(jsFolder, false);
        for (Map.Entry<String, RelativePath> entry : resourcesMap.entrySet()) {
            String name = entry.getKey();
            if (!name.endsWith(".js")) continue;
            this.addJsScript(entry.getValue());
        }
        SortedMap<String, RelativePath> subfolderMap = resourceStorages.listSubFolders(jsFolder);
        for (Map.Entry<String, RelativePath> entry : subfolderMap.entrySet()) {
            this.scanJavascriptFolder(resourceStorages, entry.getValue());
        }
        return this;
    }

    public BdfJsLibBuilder scanCssFolder(ResourceStorages resourceStorages, RelativePath cssFolder) {
        SortedMap<String, RelativePath> resourcesMap = resourceStorages.listResources(cssFolder, false);
        for (Map.Entry<String, RelativePath> entry : resourcesMap.entrySet()) {
            String name = entry.getKey();
            if (!name.endsWith(".css")) continue;
            this.addJsScript(entry.getValue());
        }
        SortedMap<String, RelativePath> subfolderMap = resourceStorages.listSubFolders(cssFolder);
        for (Map.Entry<String, RelativePath> entry : subfolderMap.entrySet()) {
            this.scanCssFolder(resourceStorages, entry.getValue());
        }
        return this;
    }

    private void testTemplateAdd() {
        if (!this.templateAdded) {
            this.templateAdded = true;
            this.addTemplateFamily(BDF_TEMPLATEFAMILY);
        }
    }

    public static BdfJsLibBuilder init() {
        return new BdfJsLibBuilder();
    }
}

