/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.instruction;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.instruction.BdfCommandParameters;
import fr.exemole.bdfserver.api.interaction.Domain;
import net.mapeadores.util.request.RequestMap;

public class BdfCommandParametersBuilder {
    private BdfCommandParametersBuilder() {
    }

    public static BdfCommandParameters build(String commandName, Domain defaultDomain, BdfServer bdfServer, RequestMap requestMap) {
        Domain domain;
        int idx = commandName.indexOf(58);
        if (idx == -1) {
            idx = commandName.indexOf(47);
        }
        if (idx == -1) {
            domain = defaultDomain;
        } else {
            domain = Domain.parse(commandName.substring(0, idx));
            commandName = commandName.substring(idx + 1);
        }
        return new InternalBdfCommandParameters(domain, commandName, bdfServer, requestMap);
    }

    private static class InternalBdfCommandParameters
    implements BdfCommandParameters {
        private final Domain domain;
        private final String commandName;
        private final BdfServer bdfServer;
        private final RequestMap requestMap;

        private InternalBdfCommandParameters(Domain domain, String commandName, BdfServer bdfServer, RequestMap requestMap) {
            this.domain = domain;
            this.commandName = commandName;
            this.bdfServer = bdfServer;
            this.requestMap = requestMap;
        }

        @Override
        public Domain getDomain() {
            return this.domain;
        }

        @Override
        public String getCommandName() {
            return this.commandName;
        }

        @Override
        public BdfServer getBdfServer() {
            return this.bdfServer;
        }

        @Override
        public RequestMap getRequestMap() {
            return this.requestMap;
        }
    }
}

