/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.balayage;

import fr.exemole.bdfserver.api.BdfServer;
import java.io.StringReader;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.exportation.balayage.BalayageDef;
import net.fichotheque.exportation.balayage.BalayageDescription;
import net.fichotheque.exportation.balayage.BalayageUnit;
import net.fichotheque.extraction.FilterParameters;
import net.fichotheque.extraction.def.AddendaExtractDef;
import net.fichotheque.extraction.def.AlbumExtractDef;
import net.fichotheque.extraction.def.CorpusExtractDef;
import net.fichotheque.extraction.def.ExtractionDef;
import net.fichotheque.extraction.def.FicheFilter;
import net.fichotheque.extraction.def.ThesaurusExtractDef;
import net.fichotheque.tools.extraction.builders.AddendaExtractDefBuilder;
import net.fichotheque.tools.extraction.builders.AlbumExtractDefBuilder;
import net.fichotheque.tools.extraction.builders.CorpusExtractDefBuilder;
import net.fichotheque.tools.extraction.builders.ExtractionDefBuilder;
import net.fichotheque.tools.extraction.builders.FicheFilterBuilder;
import net.fichotheque.tools.extraction.builders.MotcleFilterBuilder;
import net.fichotheque.tools.extraction.builders.ThesaurusExtractDefBuilder;
import net.fichotheque.tools.extraction.builders.TitleClauseBuilder;
import net.fichotheque.tools.extraction.dom.ExtractionDOMReader;
import net.fichotheque.utils.ExtractionUtils;
import net.fichotheque.utils.FilterUnits;
import net.fichotheque.xml.extraction.ExtractionXMLUtils;
import net.mapeadores.util.exceptions.SwitchException;
import net.mapeadores.util.xml.DOMUtils;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public final class BdfBalayageUtils {
    private static final Predicate<String> ACCEPT_ALL_PREDICATE = new AcceptAllExtensionPredicate();
    private static final ExtractionDef CORPUS_DEFAULT_EXTRACTIONDEF = ExtractionDefBuilder.init().setDynamicCorpusExtractDef(CorpusExtractDefBuilder.init(ExtractionXMLUtils.TITLE_FICHEFILTER).toCorpusExtractDef()).toExtractionDef();
    private static final ExtractionDef FICHE_DEFAULT_EXTRACTIONDEF = ExtractionDefBuilder.init().setDynamicCorpusExtractDef(CorpusExtractDefBuilder.init(BdfBalayageUtils.newFicheInstance()).setClause("title", TitleClauseBuilder.DEFAULT).toCorpusExtractDef()).toExtractionDef();
    private static final ExtractionDef MOTCLE_DEFAULT_EXTRACTIONDEF = ExtractionDefBuilder.init().setDynamicThesaurusExtractDef(ThesaurusExtractDefBuilder.init(MotcleFilterBuilder.init((short)1).setWithIcon(true).setWithLabels(true).addDefaultCorpusExtractDef().toMotcleFilter()).toThesaurusExtractDef()).toExtractionDef();
    private static final ExtractionDef THESAURUS_DEFAULT_EXTRACTIONDEF = ExtractionDefBuilder.init().setDynamicThesaurusExtractDef(ThesaurusExtractDefBuilder.init(MotcleFilterBuilder.init((short)1).setWithIcon(true).setWithLabels(true).addDefaultCorpusExtractDef().setChildrenRecursive().toMotcleFilter()).setBoolean("withthesaurustitle", true).toThesaurusExtractDef()).toExtractionDef();
    private static final ExtractionDef UNIQUE_DEFAULT_EXTRACTIONDEF = ExtractionDefBuilder.init().toExtractionDef();

    private BdfBalayageUtils() {
    }

    public static Predicate<String> getExtensionPredicate(BalayageUnit balayageUnit) {
        List<String> extensionList = balayageUnit.getExtensionList();
        if (extensionList.isEmpty()) {
            return ACCEPT_ALL_PREDICATE;
        }
        return new SetExtensionPredicate(new HashSet<String>(extensionList));
    }

    public static ExtractionDef getDefaultExtractionDef(String balayageUnitType) {
        switch (balayageUnitType) {
            case "corpus": {
                return CORPUS_DEFAULT_EXTRACTIONDEF;
            }
            case "fiche": {
                return FICHE_DEFAULT_EXTRACTIONDEF;
            }
            case "motcle": {
                return MOTCLE_DEFAULT_EXTRACTIONDEF;
            }
            case "thesaurus": {
                return THESAURUS_DEFAULT_EXTRACTIONDEF;
            }
            case "unique": {
                return UNIQUE_DEFAULT_EXTRACTIONDEF;
            }
        }
        throw new SwitchException("wrong balayageUnitType = " + balayageUnitType);
    }

    public static FicheFilter newFicheInstance() {
        CorpusExtractDef corpusExtractDef = CorpusExtractDefBuilder.init(ExtractionXMLUtils.TITLE_FICHEFILTER).setClause("title", TitleClauseBuilder.DEFAULT).toCorpusExtractDef();
        ThesaurusExtractDef thesaurusExtractDef = ThesaurusExtractDefBuilder.init(ExtractionXMLUtils.LABELS_MOTCLEFILTER).toThesaurusExtractDef();
        AlbumExtractDef albumExtractDef = AlbumExtractDefBuilder.init(ExtractionXMLUtils.DEFAULT_ILLUSTRATIONFILTER).toAlbumExtractDef();
        AddendaExtractDef addendaExtractDef = AddendaExtractDefBuilder.init(ExtractionXMLUtils.DEFAULT_DOCUMENTFILTER).toAddendaExtractDef();
        FilterParameters filterParameters = ExtractionUtils.EMPTY_FILTERPARAMETERS;
        return FicheFilterBuilder.init().add(FilterUnits.HEAD_FILTERUNIT).add(FilterUnits.BODY_FILTERUNIT).add(FilterUnits.addendaExtract(addendaExtractDef, filterParameters)).add(FilterUnits.thesaurusExtract(thesaurusExtractDef, filterParameters)).add(FilterUnits.corpusExtract(corpusExtractDef, filterParameters)).add(FilterUnits.albumExtract(albumExtractDef, filterParameters)).add(FilterUnits.CHRONO_FILTERUNIT).add(FilterUnits.fieldKey(FieldKey.LANG, filterParameters)).add(FilterUnits.FICHEPHRASE_FILTERUNIT).toFicheFilter();
    }

    public static ExtractionDef getExtractionDef(BdfServer bdfServer, BalayageDescription balayageDescription, String extractionPath) throws SAXException {
        String content = bdfServer.getBalayageManager().getBalayageContent(balayageDescription.getName(), "extraction/" + extractionPath);
        if (content == null) {
            return null;
        }
        Document document = DOMUtils.parseDocument(content);
        ExtractionDOMReader extractionDomReader = new ExtractionDOMReader(bdfServer.getFichotheque());
        ExtractionDef extractionDef = extractionDomReader.readExtraction(document.getDocumentElement(), balayageDescription.getIncludeCatalog());
        return extractionDef;
    }

    public static Source getTransformerSource(BdfServer bdfServer, BalayageDef balayageDef, String xsltPath) {
        String content = bdfServer.getBalayageManager().getBalayageContent(balayageDef.getName(), "xslt/" + xsltPath);
        if (content == null) {
            return null;
        }
        return new StreamSource(new StringReader(content), "bdf://this/balayage/" + balayageDef.getName() + "/xslt/" + xsltPath);
    }

    private static class SetExtensionPredicate
    implements Predicate<String> {
        private final Set<String> set;

        private SetExtensionPredicate(Set<String> set) {
            this.set = set;
        }

        @Override
        public boolean test(String extension) {
            return this.set.contains(extension);
        }
    }

    private static class AcceptAllExtensionPredicate
    implements Predicate<String> {
        private AcceptAllExtensionPredicate() {
        }

        @Override
        public boolean test(String extension) {
            return true;
        }
    }
}

