/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.servlets;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.instruction.BdfInstruction;
import fr.exemole.bdfserver.api.interaction.Domain;
import fr.exemole.bdfserver.api.session.AuthenticationException;
import fr.exemole.bdfserver.api.users.BdfUser;
import fr.exemole.bdfserver.get.GetInstructionFactory;
import fr.exemole.bdfserver.multi.MultiInstructions;
import fr.exemole.bdfserver.multi.api.Multi;
import fr.exemole.bdfserver.multi.api.central.CentralUser;
import fr.exemole.bdfserver.multi.subscribe.SubscribeParameters;
import fr.exemole.bdfserver.servlets.AuthenticationResponseHandlerFactory;
import fr.exemole.bdfserver.servlets.BDFUtils;
import fr.exemole.bdfserver.servlets.BDFWebapp;
import fr.exemole.bdfserver.servlets.instructions.AppInstruction;
import fr.exemole.bdfserver.servlets.instructions.DomainInstruction;
import fr.exemole.bdfserver.servlets.instructions.RunInstruction;
import fr.exemole.bdfserver.servlets.instructions.SessionInstruction;
import fr.exemole.bdfserver.tools.apps.AppConf;
import fr.exemole.bdfserver.tools.apps.AppConfUtils;
import fr.exemole.bdfserver.tools.instruction.BdfInstructionUtils;
import java.io.IOException;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.fichotheque.SubsetKey;
import net.mapeadores.util.logging.CommandMessage;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.logging.LogUtils;
import net.mapeadores.util.request.OutputInfo;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.servlets.HttpAccessException;
import net.mapeadores.util.servlets.HttpServletRequestMap;
import net.mapeadores.util.servlets.ResponseHandler;
import net.mapeadores.util.servlets.exceptions.InternalErrorException;
import net.mapeadores.util.servlets.exceptions.NotFoundException;

public final class BDFRoutes {
    private BDFRoutes() {
    }

    public static void resolveMulti(BDFWebapp bdfWebapp, String pathInfo, HttpServletRequestMap requestMap, HttpServletResponse response) throws IOException, ServletException {
        Multi multi = bdfWebapp.getMulti();
        int idx = pathInfo.indexOf(47);
        if (idx == -1) {
            BDFRoutes.resolveMultiRoute(bdfWebapp, BDFRoutes.checkAlias(pathInfo), requestMap, response);
        } else {
            String pathRoot = pathInfo.substring(0, idx);
            String relativePath = pathInfo.substring(idx + 1);
            switch (pathRoot) {
                case "multi-rsc": 
                case "_rsc": {
                    ResponseHandler responseHandler = MultiInstructions.getResource(multi, relativePath);
                    if (responseHandler != null) {
                        responseHandler.handleResponse(response);
                        break;
                    }
                    throw new NotFoundException();
                }
                default: {
                    BdfServer bdfServer;
                    try {
                        bdfServer = multi.getBdfServer(pathRoot);
                    }
                    catch (ErrorMessageException eme) {
                        CommandMessage errorMessage = eme.getErrorMessage();
                        switch (errorMessage.getMessageKey()) {
                            case "_ error.unknown.fichotheque": {
                                throw new NotFoundException(errorMessage);
                            }
                            case "_ error.unsupported.inactivefichotheque": {
                                throw new HttpAccessException(503, errorMessage);
                            }
                        }
                        throw new InternalErrorException(errorMessage);
                    }
                    if (relativePath.isEmpty()) {
                        response.sendRedirect("session");
                        break;
                    }
                    BDFRoutes.resolveBdfServer(bdfWebapp, bdfServer, relativePath, requestMap, response);
                }
            }
        }
    }

    public static void resolveBdfServer(BDFWebapp bdfWebapp, BdfServer bdfServer, String pathInfo, HttpServletRequestMap requestMap, HttpServletResponse response) throws IOException, ServletException {
        BdfUser bdfUser;
        BdfInstruction bdfInstruction;
        HttpServletRequest request;
        block15: {
            request = requestMap.getRequest();
            bdfInstruction = BDFRoutes.getBdfServerInstruction(bdfServer, requestMap, pathInfo);
            if (bdfInstruction == null) {
                throw new NotFoundException();
            }
            bdfUser = null;
            short needBdfUser = bdfInstruction.getBdfUserNeed();
            try {
                if (needBdfUser == 4) {
                    bdfWebapp.invalidateBdfUser(requestMap, bdfServer.getName());
                    throw new AuthenticationException(AuthenticationException.EXIT_ERROR);
                }
                if (needBdfUser != 1) {
                    bdfUser = bdfWebapp.getOrCreateBdfUser(requestMap, bdfServer);
                }
            }
            catch (AuthenticationException le) {
                if (needBdfUser == 2) break block15;
                ResponseHandler responseHandler = AuthenticationResponseHandlerFactory.getResponseHandler(bdfServer, requestMap, pathInfo, bdfInstruction, le);
                responseHandler.handleResponse(response);
                return;
            }
        }
        try {
            ResponseHandler responseHandler = bdfInstruction.runInstruction(bdfUser);
            if (responseHandler == null) {
                throw new NotFoundException();
            }
            long lastModified = responseHandler.getLastModified();
            if (lastModified == -1L) {
                response.setHeader("Cache-Control", "no-store");
            } else if (lastModified > 0L) {
                response.setDateHeader("Last-Modified", lastModified);
                try {
                    long since = request.getDateHeader("If-Modified-Since");
                    if (since >= lastModified) {
                        response.setStatus(304);
                        return;
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            responseHandler.handleResponse(response);
        }
        catch (HttpAccessException hae) {
            if (hae.isUnresolvedMessage()) {
                hae.resolveMessage(BdfInstructionUtils.getMessageLocalisation(requestMap, bdfServer, bdfUser));
            }
            throw hae;
        }
    }

    private static BdfInstruction getBdfServerInstruction(BdfServer bdfServer, RequestMap requestMap, String pathInfo) {
        int idx = pathInfo.indexOf(47);
        if (idx == -1) {
            Domain domain = BDFUtils.parsePathInfo(pathInfo);
            switch (domain.getFirstPart()) {
                case "session": {
                    return new SessionInstruction(bdfServer, requestMap);
                }
                case "run": {
                    return new RunInstruction(bdfServer, requestMap);
                }
                case "app": {
                    return AppInstruction.build(bdfServer, requestMap, domain.getSecondPart());
                }
                case "administration": 
                case "album": 
                case "configuration": 
                case "corpus": 
                case "mailing": 
                case "exportation": 
                case "edition": 
                case "selection": 
                case "sphere": 
                case "thesaurus": 
                case "main": 
                case "misc": 
                case "addenda": 
                case "importation": 
                case "pioche": 
                case "ext": {
                    return new DomainInstruction(bdfServer, requestMap, domain);
                }
            }
            return null;
        }
        String first = pathInfo.substring(0, idx);
        String next = pathInfo.substring(idx + 1);
        return GetInstructionFactory.getBdfInstruction(bdfServer, requestMap, first, next);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void resolveMultiRoute(BDFWebapp bdfWebapp, String route, HttpServletRequestMap requestMap, HttpServletResponse response) throws IOException, ServletException {
        Multi multi = bdfWebapp.getMulti();
        int idx2 = route.indexOf(45);
        if (idx2 == -1) {
            if (!multi.containsFichotheque(route)) throw new NotFoundException();
            response.sendRedirect(route + "/" + "session");
            return;
        } else {
            ResponseHandler responseHandler;
            String firstPart = route.substring(0, idx2);
            String secondPart = route.substring(idx2 + 1);
            switch (firstPart) {
                case "multi": {
                    responseHandler = BDFRoutes.resolveMultiAction(bdfWebapp, requestMap, secondPart);
                    break;
                }
                case "app": {
                    AppConf appConf = AppConfUtils.getAppConf(multi.getWebappsResourceStorages(), secondPart);
                    if (appConf == null || !appConf.getBoolean("multi_active")) throw new NotFoundException();
                    responseHandler = BDFRoutes.resolveMultiApp(bdfWebapp, appConf, requestMap);
                    break;
                }
                case "index": {
                    SubsetKey sphereKey = BDFUtils.getValidCentralSphere(multi, secondPart);
                    if (sphereKey == null) throw new NotFoundException();
                    responseHandler = BDFRoutes.resolveSphereIndex(bdfWebapp, sphereKey, requestMap);
                    break;
                }
                default: {
                    throw new NotFoundException();
                }
            }
            responseHandler.handleResponse(response);
        }
    }

    private static ResponseHandler resolveMultiAction(BDFWebapp bdfWebapp, HttpServletRequestMap requestMap, String action) throws IOException, ServletException {
        ResponseHandler errorResponseHandler;
        OutputInfo outputInfo = null;
        switch (action) {
            case "run": {
                break;
            }
            case "subscribe": 
            case "admin": 
            case "sphere": {
                outputInfo = OutputInfo.buildFromRequest(requestMap, action);
                break;
            }
            default: {
                throw new NotFoundException();
            }
        }
        Multi multi = bdfWebapp.getMulti();
        if (action.equals("admin") && outputInfo.getType() == 3) {
            multi.getMultiConf().update();
            if (requestMap.isTrue("reload")) {
                multi.getWebappsJsAnalyser().clearCache();
            }
        }
        if ((errorResponseHandler = MultiInstructions.checkInitError(multi, outputInfo, requestMap)) != null) {
            return errorResponseHandler;
        }
        switch (action) {
            case "run": {
                return MultiInstructions.doRun(multi, requestMap);
            }
            case "subscribe": {
                String multiRootUrl = BDFUtils.getRootUrl(requestMap.getRequest(), "");
                SubscribeParameters subscribeParameters = new SubscribeParameters(bdfWebapp.getSubscribeManager(), multi, requestMap, multiRootUrl);
                return MultiInstructions.doSubscribe(subscribeParameters, outputInfo);
            }
        }
        short authentificationCheck = bdfWebapp.checkMultiAdmin(requestMap);
        return MultiInstructions.doAuthentificationCheckedAction(multi, action, authentificationCheck, requestMap, outputInfo);
    }

    private static ResponseHandler resolveMultiApp(BDFWebapp bdfWebapp, AppConf appConf, HttpServletRequestMap requestMap) throws IOException, ServletException {
        Multi multi = bdfWebapp.getMulti();
        boolean noAuthenfication = appConf.getBoolean("multi_noauthentication");
        if (noAuthenfication) {
            return MultiInstructions.getNoAuthentificationApp(multi, appConf);
        }
        Set<String> nameSet = multi.getCentralSphereNameSet();
        if (nameSet.isEmpty()) {
            throw new NotFoundException();
        }
        String[] sphereNameArray = nameSet.toArray(new String[nameSet.size()]);
        String defaultSphere = appConf.getString("login_defaultsphere", sphereNameArray[0]);
        try {
            CentralUser centralUser = bdfWebapp.getOrCreateCentralUser(requestMap);
            return MultiInstructions.getApp(multi, appConf, centralUser);
        }
        catch (AuthenticationException e) {
            OutputInfo outputInfo = OutputInfo.buildFromRequest(requestMap);
            return MultiInstructions.getCentralLogin(multi, defaultSphere, outputInfo, requestMap, LogUtils.error(e.getErrorMessageKey(), new Object[0]));
        }
    }

    private static ResponseHandler resolveSphereIndex(BDFWebapp bdfWebapp, SubsetKey sphereKey, HttpServletRequestMap requestMap) throws IOException, ServletException {
        OutputInfo outputInfo = OutputInfo.buildFromRequest(requestMap, sphereKey.getSubsetName());
        Multi multi = bdfWebapp.getMulti();
        ResponseHandler errorResponseHandler = MultiInstructions.checkInitError(multi, outputInfo, requestMap);
        if (errorResponseHandler != null) {
            return errorResponseHandler;
        }
        String cmd = requestMap.getParameter("cmd");
        if (cmd != null && cmd.equals("exit")) {
            bdfWebapp.invalidateCentralUser(requestMap);
            return MultiInstructions.getCentralLogin(multi, sphereKey.getSubsetName(), outputInfo, requestMap, null);
        }
        try {
            CentralUser centralUser = bdfWebapp.getOrCreateCentralUser(requestMap);
            return MultiInstructions.getSphereIndex(multi, centralUser, outputInfo, requestMap);
        }
        catch (AuthenticationException e) {
            return MultiInstructions.getCentralLogin(multi, sphereKey.getSubsetName(), outputInfo, requestMap, LogUtils.error(e.getErrorMessageKey(), new Object[0]));
        }
    }

    private static String checkAlias(String route) {
        switch (route) {
            case "_admin": 
            case "admin-multi": {
                return "multi-admin";
            }
        }
        return route;
    }
}

