/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.multi.subscribe;

import fr.exemole.bdfserver.multi.api.Multi;
import fr.exemole.bdfserver.multi.subscribe.AskForTokenCommand;
import fr.exemole.bdfserver.multi.subscribe.AskFormHtmlProducer;
import fr.exemole.bdfserver.multi.subscribe.FichothequeFormHtmlProducer;
import fr.exemole.bdfserver.multi.subscribe.FichothequeSubscribeCommand;
import fr.exemole.bdfserver.multi.subscribe.SubscribeCommand;
import fr.exemole.bdfserver.multi.subscribe.SubscribeMessageHtmlProducer;
import fr.exemole.bdfserver.multi.subscribe.SubscribeParameters;
import fr.exemole.bdfserver.multi.subscribe.SubscribeResult;
import fr.exemole.bdfserver.multi.subscribe.SubscribeToken;
import net.mapeadores.util.html.HtmlProducer;
import net.mapeadores.util.localisation.MessageLocalisation;
import net.mapeadores.util.logging.CommandMessage;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.logging.LogUtils;
import net.mapeadores.util.request.OutputInfo;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.request.RequestUtils;
import net.mapeadores.util.servlets.ResponseHandler;
import net.mapeadores.util.servlets.handlers.HtmlResponseHandler;
import net.mapeadores.util.servlets.handlers.ResponseHandlerFactory;

public class SubscribeEngine {
    private static final CommandMessage TEST_DONE_MESSAGE = LogUtils.done("_ done.global.test", new Object[0]);
    private final SubscribeParameters subscribeParameters;
    private final Multi multi;
    private final RequestMap requestMap;
    private final OutputInfo outputInfo;

    private SubscribeEngine(SubscribeParameters subscribeParameters, OutputInfo outputInfo) {
        this.subscribeParameters = subscribeParameters;
        this.outputInfo = outputInfo;
        this.multi = subscribeParameters.multi();
        this.requestMap = subscribeParameters.requestMap();
    }

    private ResponseHandler run() throws ErrorMessageException {
        SubscribeCommand subscribeCommand = this.getCommand();
        if (subscribeCommand != null) {
            if (this.requestMap.isTrue("test")) {
                return this.testCommand(subscribeCommand);
            }
            SubscribeResult subscribeResult = subscribeCommand.doSubscribeCommand();
            return HtmlResponseHandler.init(new SubscribeMessageHtmlProducer(this.multi, subscribeResult));
        }
        switch (this.outputInfo.getType()) {
            default: 
        }
        HtmlProducer htmlProducer = this.getNoCommandHtmlProducer();
        return HtmlResponseHandler.init(htmlProducer);
    }

    private HtmlProducer getNoCommandHtmlProducer() throws ErrorMessageException {
        String token = this.requestMap.getParameter("token");
        if (token != null) {
            SubscribeToken subscribeToken = SubscribeCommand.getValidToken(this.subscribeParameters, token);
            return new FichothequeFormHtmlProducer(this.multi, subscribeToken);
        }
        return new AskFormHtmlProducer(this.multi);
    }

    private ResponseHandler testCommand(SubscribeCommand subscribeCommand) {
        CommandMessage commandMessage;
        try {
            subscribeCommand.testCommand();
            commandMessage = TEST_DONE_MESSAGE;
        }
        catch (ErrorMessageException eme) {
            commandMessage = eme.getErrorMessage();
        }
        if (RequestUtils.isJsonDefined(this.requestMap)) {
            MessageLocalisation messageLocalisation = this.multi.getAdminMessageLocalisation();
            return ResponseHandlerFactory.getJsonInstance(messageLocalisation, this.requestMap, commandMessage);
        }
        return HtmlResponseHandler.init(new SubscribeMessageHtmlProducer(this.subscribeParameters.multi(), commandMessage));
    }

    public static ResponseHandler run(SubscribeParameters subscribeParameters, OutputInfo outputInfo) {
        SubscribeEngine subscribeEngine = new SubscribeEngine(subscribeParameters, outputInfo);
        try {
            return subscribeEngine.run();
        }
        catch (ErrorMessageException eme) {
            return HtmlResponseHandler.init(new SubscribeMessageHtmlProducer(subscribeParameters.multi(), eme.getErrorMessage()));
        }
    }

    private SubscribeCommand getCommand() throws ErrorMessageException {
        String cmd = this.subscribeParameters.requestMap().getParameter("cmd");
        if (cmd == null) {
            return null;
        }
        SubscribeCommand command = this.getCommand(cmd);
        if (command == null) {
            throw new ErrorMessageException("_ error.unknown.parametervalue", "cmd", cmd);
        }
        return command;
    }

    private SubscribeCommand getCommand(String commandName) throws ErrorMessageException {
        switch (commandName) {
            case "AskForToken": {
                return new AskForTokenCommand(this.subscribeParameters);
            }
            case "FichothequeSubscribe": {
                String token = this.requestMap.getParameter("token");
                return new FichothequeSubscribeCommand(this.subscribeParameters);
            }
        }
        return null;
    }

    private SubscribeToken getValidToken(String token) throws ErrorMessageException {
        SubscribeToken subscribeToken = this.subscribeParameters.subscribeManager().getSubcribeToken(token);
        if (subscribeToken == null) {
            throw new ErrorMessageException("_ error.unknown.subscribe.token", token);
        }
        if (subscribeToken.isExpired()) {
            throw new ErrorMessageException("_ error.unsupported.subscribe.token", token);
        }
        if (subscribeToken.isUsed()) {
            throw new ErrorMessageException("_ error.existing.subscribe.token", token);
        }
        return subscribeToken;
    }
}

