/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.multi.subscribe;

import fr.exemole.bdfserver.multi.subscribe.SubscribeCommand;
import fr.exemole.bdfserver.multi.subscribe.SubscribeParameters;
import fr.exemole.bdfserver.multi.subscribe.SubscribeResult;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import java.text.ParseException;
import net.mapeadores.util.logging.CommandMessage;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.models.EmailCore;
import net.mapeadores.util.models.EmailCoreUtils;
import net.mapeadores.util.models.PersonCore;
import net.mapeadores.util.models.PersonCoreUtils;

public class AskForTokenCommand
extends SubscribeCommand {
    public static final String COMMAND_NAME = "AskForToken";
    public static final String SURNAME_PARAMNAME = "surname";
    public static final String FORENAME_PARAMNAME = "forename";
    public static final String EMAIL_PARAMNAME = "email";
    public static final String SURNAMEFIRST_PARAMNAME = "surnamefirst";
    private PersonCore person;
    private EmailCore email;

    public AskForTokenCommand(SubscribeParameters subscribeParameters) {
        super(subscribeParameters);
    }

    @Override
    public SubscribeResult doSubscribeCommand() throws ErrorMessageException {
        this.testCommand();
        CommandMessage commandMessage = this.subscribeManager.sendToken(this.person, this.email, this.multi.getAdminMessageLocalisation(), this.subscribeParameters.rootUrl());
        return SubscribeResult.init(this.subscribeParameters).commandMessage(commandMessage);
    }

    @Override
    public void testCommand() throws ErrorMessageException {
        this.person = this.initPerson();
        this.email = this.initEmail(this.person.toStandardStyle());
    }

    private PersonCore initPerson() throws ErrorMessageException {
        String surname = this.getMandatory(SURNAME_PARAMNAME);
        String forename = this.getMandatory(FORENAME_PARAMNAME);
        boolean surnameFirst = this.requestMap.isTrue(SURNAMEFIRST_PARAMNAME);
        return PersonCoreUtils.toPersonCore(surname, forename, "", surnameFirst);
    }

    private EmailCore initEmail(String realName) throws ErrorMessageException {
        String emailString = this.getMandatory(EMAIL_PARAMNAME);
        try {
            return EmailCoreUtils.parse(emailString, realName);
        }
        catch (ParseException pe) {
            throw BdfErrors.error("_ error.wrong.email", emailString);
        }
    }
}

