/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.multi.commands.personmanager;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.api.managers.PermissionManager;
import fr.exemole.bdfserver.multi.api.Multi;
import fr.exemole.bdfserver.multi.commands.personmanager.AbstractPersonMultiCommand;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.fichotheque.sphere.Redacteur;
import net.fichotheque.sphere.Sphere;
import net.fichotheque.sphere.SphereEditor;
import net.mapeadores.util.logging.CommandMessage;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.logging.LogUtils;
import net.mapeadores.util.models.EmailCore;
import net.mapeadores.util.models.EmailCoreUtils;
import net.mapeadores.util.models.PersonCore;
import net.mapeadores.util.models.PersonCoreUtils;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.text.StringUtils;

public class PersonChangeCommand
extends AbstractPersonMultiCommand {
    public static final String COMMAND_NAME = "PersonChange";
    public static final String TYPE_PARAMNAME = "type";
    public static final String NAME_TYPE_PARAMVALUE = "name";
    public static final String EMAIL_TYPE_PARAMVALUE = "email";
    public static final String STATUS_TYPE_PARAMVALUE = "status";
    public static final String NEWPASSWORD_TYPE_PARAMVALUE = "newpassword";
    public static final String COPY_PASSWORD_TYPE_PARAMVALUE = "copy_password";
    public static final String COPY_ALL_TYPE_PARAMVALUE = "copy_all";
    public static final String TARGET_PARAMNAME = "target";
    public static final String EMAIL_PARAMNAME = "email";
    public static final String SURNAME_PARAMNAME = "surname";
    public static final String FICHOTHEQUES_PARAMNAME = "fichotheques";
    public static final String FORENAME_PARAMNAME = "forename";
    public static final String NONLATIN_PARAMNAME = "nonlatin";
    public static final String PASSWORD1_PARAMNAME = "password1";
    public static final String PASSWORD2_PARAMNAME = "password2";
    public static final String STATUS_PARAMNAME = "status";
    public static final String SURNAMEFIRST_PARAMNAME = "surnamefirst";
    public static final String ALL_PARAMVALUE = "all";
    public static final String SELECTION_PARAMVALUE = "selection";
    public static final String ADMIN_STATUS_PARAMVALUE = "admin";
    public static final String USER_STATUS_PARAMVALUE = "user";
    public static final String READONLY_STATUS_PARAMVALUE = "readonly";
    public static final String INACTIVE_STATUS_PARAMVALUE = "inactive";

    public PersonChangeCommand(Multi multi, RequestMap requestMap) {
        super(multi, requestMap);
    }

    @Override
    public CommandMessage doCommand() throws ErrorMessageException {
        String type;
        this.initPersonParameters();
        switch (type = this.getMandatory(TYPE_PARAMNAME)) {
            case "name": {
                return this.runNameChange();
            }
            case "email": {
                return this.runEmailChange();
            }
            case "status": {
                return this.runStatusChange();
            }
            case "newpassword": {
                return this.runNewPasswordChange();
            }
            case "copy_password": {
                return this.runCopyPasswordChange();
            }
            case "copy_all": {
                return this.runCopyAllChange();
            }
        }
        throw new ErrorMessageException("_ error.unknown.parametervalue", TYPE_PARAMNAME, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CommandMessage runNameChange() throws ErrorMessageException {
        String nonlatin;
        String forename;
        String surname = StringUtils.cleanString(this.requestMap.getParameter(SURNAME_PARAMNAME));
        if (surname == null) {
            surname = "";
        }
        if ((forename = StringUtils.cleanString(this.requestMap.getParameter(FORENAME_PARAMNAME))) == null) {
            forename = "";
        }
        if ((nonlatin = StringUtils.cleanString(this.requestMap.getParameter(NONLATIN_PARAMNAME))) == null) {
            nonlatin = "";
        }
        boolean surnameFirst = false;
        String surnameFirstValue = this.requestMap.getParameter(SURNAMEFIRST_PARAMNAME);
        if (surnameFirstValue != null) {
            switch (surnameFirstValue.toLowerCase()) {
                case "1": 
                case "true": {
                    surnameFirst = true;
                }
            }
        }
        PersonCore personCore = PersonCoreUtils.toPersonCore(surname, forename, nonlatin, surnameFirst);
        for (Info info : this.getInfoList()) {
            BdfServer bdfServer;
            BdfServer bdfServer2 = bdfServer = info.getBdfServer();
            synchronized (bdfServer2) {
                try (EditSession editSession = this.initEditSession(bdfServer);){
                    SphereEditor sphereEditor = editSession.getFichothequeEditor().getSphereEditor(this.sphereKey);
                    sphereEditor.setPerson(info.getRedacteur(), personCore);
                }
            }
        }
        return this.done("_ done.multi.personchange");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CommandMessage runEmailChange() throws ErrorMessageException {
        String email = StringUtils.cleanString(this.getMandatory("email", true));
        try {
            EmailCore emailCore = email.isEmpty() ? null : EmailCoreUtils.parse(email);
            for (Info info : this.getInfoList()) {
                BdfServer bdfServer;
                BdfServer bdfServer2 = bdfServer = info.getBdfServer();
                synchronized (bdfServer2) {
                    try (EditSession editSession = this.initEditSession(bdfServer);){
                        SphereEditor sphereEditor = editSession.getFichothequeEditor().getSphereEditor(this.sphereKey);
                        sphereEditor.setEmail(info.getRedacteur(), emailCore);
                    }
                }
            }
            return this.done("_ done.multi.personchange");
        }
        catch (ParseException pe) {
            throw new ErrorMessageException("_ error.wrong.parametervalue", "email", email);
        }
    }

    private CommandMessage runNewPasswordChange() throws ErrorMessageException {
        String mdp2;
        String mdp1 = this.getMandatory(PASSWORD1_PARAMNAME, true);
        if (!mdp1.equals(mdp2 = this.getMandatory(PASSWORD2_PARAMNAME, true))) {
            throw new ErrorMessageException("_ error.wrong.password_different");
        }
        if (mdp1.isEmpty()) {
            throw new ErrorMessageException("_ error.empty.password");
        }
        if (mdp1.length() < 4) {
            throw new ErrorMessageException("_ error.wrong.password_tooshort");
        }
        for (Info info : this.getInfoList()) {
            info.getBdfServer().getPasswordManager().setPassword(info.getRedacteur().getGlobalId(), mdp1);
        }
        return LogUtils.done("_ done.multi.personchange", new Object[0]);
    }

    private CommandMessage runCopyPasswordChange() throws ErrorMessageException {
        AbstractPersonMultiCommand.CopyOrigin copyOrigin = this.getCopyOrigin();
        List<Info> infoList = this.getInfoList();
        this.copyPassword(copyOrigin, infoList, true);
        return this.done("_ done.multi.personchange");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CommandMessage runCopyAllChange() throws ErrorMessageException {
        AbstractPersonMultiCommand.CopyOrigin copyOrigin = this.getCopyOrigin();
        Redacteur originRedacteur = copyOrigin.getRedacteur();
        List<Info> infoList = this.getInfoList();
        this.copyPassword(copyOrigin, infoList, false);
        for (Info info : this.getInfoList()) {
            BdfServer bdfServer;
            BdfServer bdfServer2 = bdfServer = info.getBdfServer();
            synchronized (bdfServer2) {
                try (EditSession editSession = this.initEditSession(bdfServer);){
                    SphereEditor sphereEditor = editSession.getFichothequeEditor().getSphereEditor(this.sphereKey);
                    sphereEditor.setPerson(info.getRedacteur(), originRedacteur.getPersonCore());
                    sphereEditor.setEmail(info.getRedacteur(), originRedacteur.getEmailCore());
                }
            }
        }
        return this.done("_ done.multi.personchange");
    }

    private void copyPassword(AbstractPersonMultiCommand.CopyOrigin copyOrigin, List<Info> infoList, boolean errorIfEmpty) throws ErrorMessageException {
        String encryptedPassword = copyOrigin.getEncryptedPassword();
        if (encryptedPassword == null && errorIfEmpty) {
            throw new ErrorMessageException("_ error.empty.password");
        }
        for (Info info : infoList) {
            BdfServer bdfServer = info.getBdfServer();
            if (bdfServer.getName().equals(copyOrigin.getOriginName())) continue;
            bdfServer.getPasswordManager().setEncryptedPassword(info.getRedacteur().getGlobalId(), encryptedPassword);
        }
    }

    private CommandMessage runStatusChange() throws ErrorMessageException {
        String status = this.getMandatory("status");
        List<Info> infoList = this.getInfoList();
        if (!status.equals(ADMIN_STATUS_PARAMVALUE)) {
            this.checkUniqueAdmin(infoList);
        }
        switch (status) {
            case "admin": {
                this.runAdminChange(infoList, true);
                break;
            }
            case "user": {
                this.runAdminChange(infoList, false);
                break;
            }
            case "readonly": {
                this.runStatusChange(infoList, READONLY_STATUS_PARAMVALUE);
                break;
            }
            case "inactive": {
                this.runStatusChange(infoList, INACTIVE_STATUS_PARAMVALUE);
            }
        }
        return this.done("_ done.multi.personchange");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runAdminChange(List<Info> infoList, boolean isAdmin) {
        for (Info info : infoList) {
            BdfServer bdfServer = info.getBdfServer();
            Redacteur redacteur = info.getRedacteur();
            boolean isCurrentAdmin = bdfServer.getPermissionManager().isAdmin(redacteur);
            BdfServer bdfServer2 = bdfServer;
            synchronized (bdfServer2) {
                try (EditSession editSession = this.initEditSession(bdfServer);){
                    if (!redacteur.getStatus().equals("active")) {
                        SphereEditor sphereEditor = editSession.getFichothequeEditor().getSphereEditor(this.sphereKey);
                        sphereEditor.setStatus(redacteur, "active");
                    }
                    if (isCurrentAdmin != isAdmin) {
                        editSession.getBdfServerEditor().setAdmin(redacteur.getGlobalId(), isAdmin);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runStatusChange(List<Info> infoList, String status) {
        for (Info info : infoList) {
            BdfServer bdfServer = info.getBdfServer();
            Redacteur redacteur = info.getRedacteur();
            String currentStatus = redacteur.getStatus();
            if (status.equals(currentStatus)) continue;
            BdfServer bdfServer2 = bdfServer;
            synchronized (bdfServer2) {
                try (EditSession editSession = this.initEditSession(bdfServer);){
                    if (bdfServer.getPermissionManager().isAdmin(redacteur)) {
                        editSession.getBdfServerEditor().setAdmin(redacteur.getGlobalId(), false);
                    }
                    SphereEditor sphereEditor = editSession.getFichothequeEditor().getSphereEditor(this.sphereKey);
                    sphereEditor.setStatus(redacteur, status);
                }
            }
        }
    }

    private EditSession initEditSession(BdfServer bdfServer) {
        return bdfServer.initEditSession("_admin", COMMAND_NAME);
    }

    private void checkUniqueAdmin(List<Info> infoList) throws ErrorMessageException {
        for (Info info : infoList) {
            PermissionManager permissionManager = info.getBdfServer().getPermissionManager();
            if (!permissionManager.isAdmin(info.getRedacteur()) || permissionManager.getAdminRedacteurList().size() >= 2) continue;
            throw new ErrorMessageException("_ error.unsupported.lastadmin_fichotheque", info.getBdfServer().getName());
        }
    }

    private List<Info> getInfoList() {
        HashSet<String> nameSet;
        ArrayList<Info> result = new ArrayList<Info>();
        String targetValue = this.requestMap.getParameter(TARGET_PARAMNAME);
        if (targetValue != null && targetValue.equals(SELECTION_PARAMVALUE)) {
            String[] fichotheques = this.requestMap.getParameterValues(FICHOTHEQUES_PARAMNAME);
            nameSet = new HashSet<String>();
            if (fichotheques != null) {
                for (String fichothequeName : fichotheques) {
                    nameSet.add(fichothequeName);
                }
            }
        } else {
            nameSet = null;
        }
        for (String name : this.multi.getExistingNameSet()) {
            if (!this.multi.isInit(name) || nameSet != null && !nameSet.contains(name)) continue;
            try {
                Redacteur redacteur;
                BdfServer bdfServer = this.multi.getBdfServer(name);
                Sphere sphere = (Sphere)bdfServer.getFichotheque().getSubset(this.sphereKey);
                if (sphere == null || (redacteur = sphere.getRedacteurByLogin(this.login)) == null) continue;
                result.add(new Info(bdfServer, redacteur));
            }
            catch (ErrorMessageException eme) {
                return null;
            }
        }
        return result;
    }

    private static class Info {
        private final BdfServer bdfServer;
        private final Redacteur redacteur;

        private Info(BdfServer bdfServer, Redacteur redacteur) {
            this.bdfServer = bdfServer;
            this.redacteur = redacteur;
        }

        private BdfServer getBdfServer() {
            return this.bdfServer;
        }

        private Redacteur getRedacteur() {
            return this.redacteur;
        }
    }
}

