/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.multi.commands.fichotheque;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.fichotheque.Fichotheque;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.eligibility.SubsetEligibility;
import net.fichotheque.junction.Junctions;
import net.fichotheque.utils.EligibilityUtils;

public class CreationSubsetEligibility
implements SubsetEligibility {
    public static final String ITEMS_NONE = "none";
    public static final String ITEMS_ALL = "all";
    public static final String ITEMS_SELECTION = "selection";
    private final Map<SubsetKey, SubsetInfo> subsetMap = new HashMap<SubsetKey, SubsetInfo>();
    private final List<Corpus> corpusList = new ArrayList<Corpus>();
    private final Fichotheque fichotheque;

    public CreationSubsetEligibility(Fichotheque fichotheque) {
        this.fichotheque = fichotheque;
    }

    public void add(SubsetKey subsetKey, String itemsPolicy) {
        Corpus corpus;
        this.subsetMap.put(subsetKey, new SubsetInfo(itemsPolicy));
        if (subsetKey.isCorpusSubset() && (corpus = (Corpus)this.fichotheque.getSubset(subsetKey)) != null) {
            this.corpusList.add(corpus);
        }
    }

    @Override
    public boolean accept(Subset subset) {
        Subset masterSubset;
        if (subset instanceof Corpus && (masterSubset = ((Corpus)subset).getMasterSubset()) != null && !this.accept(masterSubset)) {
            return false;
        }
        return this.subsetMap.containsKey(subset.getSubsetKey());
    }

    @Override
    public boolean accept(SubsetKey subsetKey) {
        if (subsetKey.isCorpusSubset()) {
            Corpus corpus = (Corpus)this.fichotheque.getSubset(subsetKey);
            if (corpus != null) {
                return this.accept(corpus);
            }
            return false;
        }
        return this.subsetMap.containsKey(subsetKey);
    }

    @Override
    public Predicate<SubsetItem> getPredicate(Subset subset) {
        Subset masterSubset;
        if (subset instanceof Corpus && (masterSubset = ((Corpus)subset).getMasterSubset()) != null && this.getPolicy(masterSubset).equals(ITEMS_NONE)) {
            return EligibilityUtils.NONE_SUBSETITEM_PREDICATE;
        }
        String policy = this.getPolicy(subset);
        if (policy.equals(ITEMS_NONE)) {
            return EligibilityUtils.NONE_SUBSETITEM_PREDICATE;
        }
        if (policy.equals(ITEMS_SELECTION)) {
            if (this.corpusList.isEmpty()) {
                return EligibilityUtils.NONE_SUBSETITEM_PREDICATE;
            }
            SubsetInfo subsetInfo = this.subsetMap.get(subset.getSubsetKey());
            InternalPredicate internalPredicate = subsetInfo.getInternalPredicate();
            if (internalPredicate == null) {
                internalPredicate = this.initPredicate(subset);
                subsetInfo.setInternalPredicate(internalPredicate);
            }
            return internalPredicate;
        }
        return EligibilityUtils.ALL_SUBSETITEM_PREDICATE;
    }

    private String getPolicy(Subset subset) {
        SubsetInfo subsetInfo = this.subsetMap.get(subset.getSubsetKey());
        if (subsetInfo == null) {
            return ITEMS_NONE;
        }
        return subsetInfo.getPolicy();
    }

    private InternalPredicate initPredicate(Subset subset) {
        InternalPredicate predicate = new InternalPredicate();
        block0: for (SubsetItem subsetItem : subset.getSubsetItemList()) {
            for (Corpus corpus : this.corpusList) {
                Junctions junctions = this.fichotheque.getJunctions(subsetItem, corpus);
                if (junctions.isEmpty()) continue;
                predicate.add(subsetItem.getId());
                continue block0;
            }
        }
        return predicate;
    }

    private static class SubsetInfo {
        private final String itemsPolicy;
        private InternalPredicate predicate;

        private SubsetInfo(String itemsPolicy) {
            this.itemsPolicy = itemsPolicy;
        }

        public String getPolicy() {
            return this.itemsPolicy;
        }

        public InternalPredicate getInternalPredicate() {
            return this.predicate;
        }

        private void setInternalPredicate(InternalPredicate predicate) {
            this.predicate = predicate;
        }
    }

    private static class InternalPredicate
    implements Predicate<SubsetItem> {
        private final Set<Integer> idSet = new HashSet<Integer>();

        private InternalPredicate() {
        }

        @Override
        public boolean test(SubsetItem subsetItem) {
            return this.idSet.contains(subsetItem.getId());
        }

        private void add(int id) {
            this.idSet.add(id);
        }
    }
}

