/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.jsonproducers.thesaurus;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.instruction.OutputParameters;
import fr.exemole.bdfserver.jsonproducers.thesaurus.MotcleJsonProperty;
import fr.exemole.bdfserver.jsonproducers.thesaurus.ThesaurusJsonProperty;
import fr.exemole.bdfserver.jsonproducers.thesaurus.ThesaurusMetadataJsonProperty;
import fr.exemole.bdfserver.tools.instruction.BdfInstructionUtils;
import fr.exemole.bdfserver.tools.instruction.OutputRequestHandler;
import fr.exemole.bdfserver.tools.instruction.ResultJsonProducer;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.utils.ThesaurusUtils;
import net.mapeadores.util.json.JsonProducer;
import net.mapeadores.util.json.JsonProperty;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.logging.ErrorMessageException;

public final class ThesaurusJsonProducerFactory {
    private ThesaurusJsonProducerFactory() {
    }

    public static JsonProducer getJsonProducer(OutputParameters parameters) throws ErrorMessageException {
        OutputRequestHandler requestHandler = OutputRequestHandler.init(parameters);
        String json = parameters.getOutput();
        ResultJsonProducer jsonProducer = new ResultJsonProducer(parameters);
        JsonProperty jsonProperty = ThesaurusJsonProducerFactory.getJsonProperty(requestHandler, json);
        if (jsonProperty == null) {
            return null;
        }
        jsonProducer.add(jsonProperty);
        return jsonProducer;
    }

    public static JsonProperty getJsonProperty(OutputRequestHandler requestHandler, String name) throws ErrorMessageException {
        BdfServer bdfServer = requestHandler.getBdfServer();
        Lang lang = requestHandler.getWorkingLang();
        switch (name) {
            case "motcle": {
                Motcle motcle = requestHandler.getMotcle();
                lang = ThesaurusUtils.checkDisponibility(bdfServer.getThesaurusLangChecker(), motcle.getThesaurus(), lang);
                return new MotcleJsonProperty(motcle, lang, BdfInstructionUtils.getCellConverter(requestHandler));
            }
            case "thesaurus": {
                Thesaurus thesaurus = requestHandler.getThesaurus();
                lang = ThesaurusUtils.checkDisponibility(bdfServer.getThesaurusLangChecker(), thesaurus, lang);
                return new ThesaurusJsonProperty(thesaurus, lang, BdfInstructionUtils.getCellConverter(requestHandler));
            }
            case "thesaurus-metadata": {
                Thesaurus thesaurus = requestHandler.getThesaurus();
                return new ThesaurusMetadataJsonProperty(thesaurus.getThesaurusMetadata());
            }
        }
        return null;
    }
}

