/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.jsonproducers.selection;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.instruction.OutputParameters;
import fr.exemole.bdfserver.jsonproducers.selection.FqlJsonProperty;
import fr.exemole.bdfserver.jsonproducers.selection.SelectionDefArrayJsonProperty;
import fr.exemole.bdfserver.jsonproducers.selection.SelectionDefJsonProperty;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import fr.exemole.bdfserver.tools.instruction.OutputRequestHandler;
import fr.exemole.bdfserver.tools.instruction.ResultJsonProducer;
import net.fichotheque.selection.FichothequeQueries;
import net.mapeadores.util.json.JsonProducer;
import net.mapeadores.util.json.JsonProperty;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.logging.ErrorMessageException;

public final class SelectionJsonProducerFactory {
    private SelectionJsonProducerFactory() {
    }

    public static JsonProducer getJsonProducer(OutputParameters parameters) throws ErrorMessageException {
        OutputRequestHandler requestHandler = OutputRequestHandler.init(parameters);
        String json = parameters.getOutput();
        ResultJsonProducer jsonProducer = new ResultJsonProducer(parameters);
        JsonProperty jsonProperty = SelectionJsonProducerFactory.getJsonProperty(requestHandler, json);
        if (jsonProperty == null) {
            return null;
        }
        jsonProducer.add(jsonProperty);
        return jsonProducer;
    }

    public static JsonProperty getJsonProperty(OutputRequestHandler requestHandler, String name) throws ErrorMessageException {
        BdfServer bdfServer = requestHandler.getBdfServer();
        Lang lang = requestHandler.getWorkingLang();
        switch (name) {
            case "fql": {
                FichothequeQueries fichothequeQueries = (FichothequeQueries)requestHandler.getResultObject("obj.fichothequequeries");
                if (fichothequeQueries != null) {
                    return new FqlJsonProperty(requestHandler.getFichotheque(), fichothequeQueries);
                }
                throw BdfErrors.missingCommandResultJson("fql");
            }
            case "selectiondef": {
                return new SelectionDefJsonProperty(requestHandler.getSelectionDef(), lang);
            }
            case "selectiondef-array": {
                return new SelectionDefArrayJsonProperty(bdfServer, lang);
            }
        }
        return null;
    }
}

