/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.jsonproducers.exportation;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.managers.TableExportManager;
import fr.exemole.bdfserver.json.TableExportJson;
import java.io.IOException;
import net.fichotheque.exportation.table.TableExportDescription;
import net.mapeadores.util.json.CommonJson;
import net.mapeadores.util.json.JSONWriter;
import net.mapeadores.util.json.JsonProperty;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.MessageLocalisation;

public class TableExportArrayJsonProperty
implements JsonProperty {
    private final TableExportManager manager;
    private final Lang lang;
    private final MessageLocalisation messageLocalisation;

    public TableExportArrayJsonProperty(BdfServer bdfServer, Lang lang, MessageLocalisation messageLocalisation) {
        this.manager = bdfServer.getTableExportManager();
        this.lang = lang;
        this.messageLocalisation = messageLocalisation;
    }

    @Override
    public String getName() {
        return "tableExportArray";
    }

    @Override
    public void writeValue(JSONWriter jw) throws IOException {
        jw.array();
        for (TableExportDescription tableExportDescription : this.manager.getTableExportDescriptionList()) {
            jw.object();
            TableExportJson.properties(jw, tableExportDescription, this.messageLocalisation);
            CommonJson.title(jw, tableExportDescription.getTableExportDef().getTitleLabels(), this.lang);
            jw.endObject();
        }
        jw.endArray();
    }
}

