/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.impl;

import fr.exemole.bdfserver.api.BdfServerEditor;
import fr.exemole.bdfserver.api.managers.PolicyManager;
import fr.exemole.bdfserver.api.policies.UserAllow;
import fr.exemole.bdfserver.api.storage.PolicyStorage;
import fr.exemole.bdfserver.api.storage.StorageCheck;
import fr.exemole.bdfserver.impl.UserAllowImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.fichotheque.Fichotheque;
import net.fichotheque.SubsetKey;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.thesaurus.policies.DynamicEditPolicy;
import net.fichotheque.thesaurus.policies.PolicyProvider;
import net.fichotheque.tools.thesaurus.DynamicEditPolicyBuilder;
import net.fichotheque.utils.ThesaurusUtils;

class PolicyManagerImpl
implements PolicyManager {
    private final UserAllowImpl userAllowImpl;
    private final Fichotheque fichotheque;
    private final PolicyStorage policyStorage;
    private final InternalPolicyProvider policyProvider = new InternalPolicyProvider();

    private PolicyManagerImpl(Fichotheque fichotheque, PolicyStorage policyStorage) {
        this.fichotheque = fichotheque;
        this.userAllowImpl = new UserAllowImpl(policyStorage);
        this.policyStorage = policyStorage;
    }

    static PolicyManagerImpl build(Fichotheque fichotheque, PolicyStorage policyStorage, StorageCheck storageCheck) {
        PolicyManagerImpl policyManagerImpl = new PolicyManagerImpl(fichotheque, policyStorage);
        policyManagerImpl.userAllowImpl.update(storageCheck.getUserAllow());
        Map<SubsetKey, Object> map = storageCheck.getSubsetPolicyMap();
        for (Map.Entry<SubsetKey, Object> entry : map.entrySet()) {
            policyManagerImpl.setSubsetPolicy(entry.getKey(), entry.getValue());
        }
        return policyManagerImpl;
    }

    @Override
    public UserAllow getUserAllow() {
        return this.userAllowImpl;
    }

    @Override
    public PolicyProvider getPolicyProvider() {
        return this.policyProvider;
    }

    void setSubsetPolicy(SubsetKey subsetKey, Object policyObject) {
        if (!subsetKey.isThesaurusSubset()) {
            return;
        }
        if (policyObject == null) {
            this.policyProvider.remove(subsetKey);
        } else {
            if (!(policyObject instanceof DynamicEditPolicy)) {
                throw new IllegalArgumentException("policyObject is not instance of DynamicEditPolicy");
            }
            Thesaurus thesaurus = (Thesaurus)this.fichotheque.getSubset(subsetKey);
            if (thesaurus != null) {
                this.policyProvider.put(thesaurus, (DynamicEditPolicy)policyObject);
            }
        }
    }

    void saveSubsetPolicy(SubsetKey subsetKey) {
        if (!subsetKey.isThesaurusSubset()) {
            this.policyStorage.removeSubsetPolicy(subsetKey);
            return;
        }
        DynamicEditPolicy policy = this.policyProvider.getDynamicEditPolicy(subsetKey);
        if (policy == null) {
            this.policyStorage.removeSubsetPolicy(subsetKey);
        } else {
            this.policyStorage.saveSubsetPolicy(subsetKey, policy);
        }
    }

    static void subsetRemoved(BdfServerEditor bdfServerEditor, SubsetKey subsetKey) {
        bdfServerEditor.setSubsetPolicy(subsetKey, null);
        PolicyManagerImpl impl = (PolicyManagerImpl)bdfServerEditor.getBdfServer().getPolicyManager();
        HashMap policyMap = new HashMap(impl.policyProvider.policyMap);
        for (Map.Entry entry : policyMap.entrySet()) {
            SubsetKey current = (SubsetKey)entry.getKey();
            DynamicEditPolicy policy = (DynamicEditPolicy)entry.getValue();
            switch (policy.getType()) {
                case "transfer": {
                    DynamicEditPolicy.Transfer transferPolicy = (DynamicEditPolicy.Transfer)policy;
                    if (!transferPolicy.getTransferThesaurusKey().equals(subsetKey)) break;
                    bdfServerEditor.setSubsetPolicy(current, ThesaurusUtils.NONE_POLICY);
                    break;
                }
                case "check": {
                    DynamicEditPolicy.Check checkPolicy = (DynamicEditPolicy.Check)policy;
                    ArrayList<SubsetKey> list = new ArrayList<SubsetKey>();
                    for (SubsetKey currentSubsetKey : checkPolicy.getCheckSubseKeyList()) {
                        if (currentSubsetKey.equals(subsetKey)) continue;
                        list.add(currentSubsetKey);
                    }
                    int size = list.size();
                    if (size == checkPolicy.getCheckSubseKeyList().size()) break;
                    if (size == 0) {
                        bdfServerEditor.setSubsetPolicy(current, ThesaurusUtils.ALLOW_POLICY);
                        break;
                    }
                    bdfServerEditor.setSubsetPolicy(current, DynamicEditPolicyBuilder.buildCheck(list));
                }
            }
        }
    }

    private class InternalPolicyProvider
    implements PolicyProvider {
        private final Map<SubsetKey, DynamicEditPolicy> policyMap = new HashMap<SubsetKey, DynamicEditPolicy>();

        private InternalPolicyProvider() {
        }

        private DynamicEditPolicy getDynamicEditPolicy(SubsetKey subsetKey) {
            DynamicEditPolicy policy = this.policyMap.get(subsetKey);
            if (policy != null) {
                return policy;
            }
            return ThesaurusUtils.NONE_POLICY;
        }

        @Override
        public DynamicEditPolicy getDynamicEditPolicy(Thesaurus thesaurus) {
            return this.getDynamicEditPolicy(thesaurus.getSubsetKey());
        }

        private boolean remove(SubsetKey subsetKey) {
            DynamicEditPolicy current = this.policyMap.remove(subsetKey);
            return current != null;
        }

        private void put(Thesaurus thesaurus, DynamicEditPolicy policy) {
            if (!policy.isValid(thesaurus)) {
                return;
            }
            this.policyMap.put(thesaurus.getSubsetKey(), policy);
        }
    }
}

