/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.impl;

import fr.exemole.bdfserver.api.BdfExtensionInitializer;
import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.BdfServerEditor;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.api.EditSessionListener;
import fr.exemole.bdfserver.api.configuration.LangConfiguration;
import fr.exemole.bdfserver.api.managers.AccessManager;
import fr.exemole.bdfserver.api.managers.BalayageManager;
import fr.exemole.bdfserver.api.managers.ExtensionManager;
import fr.exemole.bdfserver.api.managers.ExternalScriptManager;
import fr.exemole.bdfserver.api.managers.GroupManager;
import fr.exemole.bdfserver.api.managers.JsLibManager;
import fr.exemole.bdfserver.api.managers.L10nManager;
import fr.exemole.bdfserver.api.managers.PasswordManager;
import fr.exemole.bdfserver.api.managers.PermissionManager;
import fr.exemole.bdfserver.api.managers.PolicyManager;
import fr.exemole.bdfserver.api.managers.ScrutariExportManager;
import fr.exemole.bdfserver.api.managers.SelectionManager;
import fr.exemole.bdfserver.api.managers.SqlExportManager;
import fr.exemole.bdfserver.api.managers.TableExportManager;
import fr.exemole.bdfserver.api.managers.TransformationManager;
import fr.exemole.bdfserver.api.managers.TreeManager;
import fr.exemole.bdfserver.api.managers.UiManager;
import fr.exemole.bdfserver.api.storage.BdfUserStorage;
import fr.exemole.bdfserver.api.storage.MigrationEngine;
import fr.exemole.bdfserver.api.storage.StorageCheck;
import fr.exemole.bdfserver.api.storage.StorageRoot;
import fr.exemole.bdfserver.api.users.BdfUser;
import fr.exemole.bdfserver.conf.BdfServerDirs;
import fr.exemole.bdfserver.impl.AccessManagerImpl;
import fr.exemole.bdfserver.impl.BalayageManagerImpl;
import fr.exemole.bdfserver.impl.BdfServerEditorImpl;
import fr.exemole.bdfserver.impl.BdfServerFichothequeListener;
import fr.exemole.bdfserver.impl.BdfUserImpl;
import fr.exemole.bdfserver.impl.ExtensionManagerImpl;
import fr.exemole.bdfserver.impl.ExternalScriptManagerImpl;
import fr.exemole.bdfserver.impl.FormatContextImpl;
import fr.exemole.bdfserver.impl.GroupManagerImpl;
import fr.exemole.bdfserver.impl.JsLibManagerImpl;
import fr.exemole.bdfserver.impl.L10nManagerImpl;
import fr.exemole.bdfserver.impl.LangConfigurationImpl;
import fr.exemole.bdfserver.impl.PasswordManagerImpl;
import fr.exemole.bdfserver.impl.PermissionManagerImpl;
import fr.exemole.bdfserver.impl.PolicyManagerImpl;
import fr.exemole.bdfserver.impl.ScrutariExportManagerImpl;
import fr.exemole.bdfserver.impl.SelectionManagerImpl;
import fr.exemole.bdfserver.impl.SqlExportManagerImpl;
import fr.exemole.bdfserver.impl.TableExportContextImpl;
import fr.exemole.bdfserver.impl.TableExportManagerImpl;
import fr.exemole.bdfserver.impl.ThesaurusLangCheckerImpl;
import fr.exemole.bdfserver.impl.TransformationManagerImpl;
import fr.exemole.bdfserver.impl.TreeManagerImpl;
import fr.exemole.bdfserver.impl.UiManagerImpl;
import fr.exemole.bdfserver.tools.BdfServerUtils;
import fr.exemole.bdfserver.tools.externalsource.CoreExternalSourceProvider;
import fr.exemole.bdfserver.tools.storage.ResourceJsAnalyser;
import fr.exemole.bdfserver.tools.storage.Storages;
import java.util.List;
import java.util.Map;
import net.fichotheque.EditOrigin;
import net.fichotheque.Fichotheque;
import net.fichotheque.FichothequeEditor;
import net.fichotheque.FichothequeEditorProvider;
import net.fichotheque.FichothequeQuestioner;
import net.fichotheque.exportation.table.TableExportContext;
import net.fichotheque.externalsource.ExternalSourceProvider;
import net.fichotheque.importation.ImportationContext;
import net.fichotheque.sphere.Redacteur;
import net.fichotheque.thesaurus.metadata.ThesaurusLangChecker;
import net.fichotheque.tools.DefaultFichothequeQuestioner;
import net.fichotheque.tools.importation.ImportationUtils;
import net.mapeadores.util.buildinfo.BuildInfo;
import net.mapeadores.util.css.SacParserInit;
import net.mapeadores.util.html.HtmlCleaner;
import net.mapeadores.util.io.ResourceStorages;
import net.mapeadores.util.jslib.JsAnalyser;
import net.mapeadores.util.logging.SourceLogs;
import net.mapeadores.util.misc.ArrayUtils;

public class BdfServerImpl
implements BdfServer {
    private final String name;
    private final Map<String, Object> contextObjectMap;
    private final BdfServerDirs bdfServerDirs;
    private final Fichotheque fichotheque;
    private final FichothequeEditorProvider fichothequeEditorProvider;
    private final FichothequeQuestioner fichothequeQuestioner;
    private final PermissionManagerImpl permissionManager;
    private final GroupManagerImpl groupManager;
    private final TreeManagerImpl treeManager;
    private final PasswordManagerImpl passwordManager;
    private final UiManagerImpl uiManager;
    private final PolicyManagerImpl policyManager;
    private final BdfServerFichothequeListener fichothequeListener;
    private final BalayageManagerImpl balayageManager;
    private final ScrutariExportManagerImpl scrutariExportManager;
    private final SqlExportManagerImpl sqlExportManager;
    private final SelectionManagerImpl selectionManager;
    private final LangConfigurationImpl langConfiguration;
    private final L10nManagerImpl l10nManager;
    private final ExtensionManagerImpl extensionManager;
    private final TransformationManagerImpl transformationManager;
    private final FormatContextImpl formatContext;
    private final TableExportContextImpl tableExportContext;
    private final TableExportManagerImpl tableExportManager;
    private final ExternalScriptManagerImpl externalScriptManager;
    private final ThesaurusLangCheckerImpl thesaurusLangChecker;
    private final AccessManagerImpl accessManager;
    private final JsLibManagerImpl jsLibManager;
    private final JsAnalyser jsAnalyser;
    private final SourceLogs initLogs;
    private final BuildInfo buildInfo;
    private final ResourceStorages resourceStorages;
    private final StorageRoot outputStorage;
    private final StorageRoot cacheStorage;
    private final BdfUserStorage bdfUserStorage;
    private final ExternalSourceProvider externalSourceProvider;
    private final ImportationContext importationContext;
    private EditSessionListener[] editSessionListenerArray = new EditSessionListener[0];

    public BdfServerImpl(String name, Storages storages, BuildInfo buildInfo, List<BdfExtensionInitializer> extensionInitializerList, Map<String, Object> contextObjectMap) {
        this.name = name;
        this.contextObjectMap = contextObjectMap;
        this.bdfServerDirs = storages.getBdfServerDirs();
        this.buildInfo = buildInfo;
        this.initLogs = storages.getInitLogs();
        StorageCheck storageCheck = storages.getStorageCheck();
        this.bdfUserStorage = storages.getBdfUserStorage();
        this.resourceStorages = storages.getResourceStorages();
        this.outputStorage = storages.getOutputStorage();
        this.cacheStorage = storages.getCacheStorage();
        this.fichothequeEditorProvider = storages.getFichothequeEditorProvider();
        this.fichotheque = this.fichothequeEditorProvider.getFichotheque();
        this.fichothequeQuestioner = new DefaultFichothequeQuestioner(this.fichotheque);
        this.langConfiguration = new LangConfigurationImpl(storages.getConfigurationStorage());
        this.langConfiguration.update(storageCheck.getLangConfiguration());
        this.permissionManager = PermissionManagerImpl.build(this.fichothequeQuestioner, storages.getRoleStorage(), storages.getRedacteurList(), storageCheck);
        this.groupManager = GroupManagerImpl.build(storages.getGroupStorage(), storageCheck.getGroupDefList());
        this.treeManager = TreeManagerImpl.build(this.fichotheque, storages.getTreeStorage(), storageCheck.getSubsetTreeMap());
        this.passwordManager = new PasswordManagerImpl(this.fichothequeQuestioner, storages.getPasswordStorage());
        this.policyManager = PolicyManagerImpl.build(this.fichotheque, storages.getPolicyStorage(), storageCheck);
        this.selectionManager = new SelectionManagerImpl(this, storages.getSelectionStorage());
        this.selectionManager.check(storageCheck.getSelectionDefList());
        this.scrutariExportManager = new ScrutariExportManagerImpl(storages.getScrutariExportStorage());
        this.scrutariExportManager.check(storageCheck.getScrutariExportDefList());
        this.sqlExportManager = new SqlExportManagerImpl(storages.getSqlExportStorage());
        this.sqlExportManager.check(storageCheck.getSqlExportDefList());
        this.l10nManager = new L10nManagerImpl(this.resourceStorages);
        this.jsAnalyser = new ResourceJsAnalyser(this.resourceStorages);
        this.jsLibManager = new JsLibManagerImpl(this.resourceStorages);
        this.externalScriptManager = new ExternalScriptManagerImpl(this);
        this.extensionManager = new ExtensionManagerImpl(this, this.fichotheque, storages.getBdfExtensionStorage(), extensionInitializerList, storages.getConfigurationStorage());
        this.extensionManager.update(storageCheck.getActiveExtensionList());
        this.thesaurusLangChecker = new ThesaurusLangCheckerImpl();
        this.balayageManager = new BalayageManagerImpl(storages.getBalayageStorage());
        this.uiManager = UiManagerImpl.build(this, storages.getUiStorage(), storageCheck.getUiCheckMap());
        this.transformationManager = new TransformationManagerImpl(this, storages.getTemplateStorage());
        this.formatContext = new FormatContextImpl(this, this.extensionManager.getInstructionResolverProvider(), this.transformationManager, this.l10nManager, this.uiManager);
        this.tableExportContext = new TableExportContextImpl(this.fichotheque, this.extensionManager, this.formatContext, this.langConfiguration, this.l10nManager, this.uiManager);
        this.tableExportManager = new TableExportManagerImpl(this.fichotheque, storages.getTableExportStorage(), this.tableExportContext);
        this.accessManager = new AccessManagerImpl(this, storages.getAccessStorage());
        this.accessManager.check(storageCheck.getAccessDefList());
        this.externalSourceProvider = new CoreExternalSourceProvider(this);
        this.importationContext = ImportationUtils.toImportationContext(this.fichothequeEditorProvider.getHtmlCleaner(), this.fichothequeQuestioner, BdfServerUtils.DEFAULT_HTMLCONVERTER);
        this.fichothequeListener = new BdfServerFichothequeListener(this);
        this.fichotheque.addFichothequeListener(this.fichothequeListener);
        this.fichotheque.addFichothequeListener(this.treeManager);
        this.fichotheque.addFichothequeListener(this.uiManager);
        this.extensionManager.endInit();
        MigrationEngine migrationEngine = storages.getMigrationEngine();
        if (migrationEngine != null) {
            migrationEngine.afterInitRun(this);
        }
        this.transformationManager.update();
        this.tableExportManager.update();
        this.balayageManager.update();
        this.jsLibManager.update();
    }

    @Override
    public SourceLogs getInitLogs() {
        return this.initLogs;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Object getContextObject(String objectName) {
        if (objectName.equals("bdfServer")) {
            return this;
        }
        return this.contextObjectMap.get(objectName);
    }

    @Override
    public BdfServerDirs getBdfServerDirs() {
        return this.bdfServerDirs;
    }

    @Override
    public Fichotheque getFichotheque() {
        return this.fichotheque;
    }

    @Override
    public PermissionManager getPermissionManager() {
        return this.permissionManager;
    }

    @Override
    public PasswordManager getPasswordManager() {
        return this.passwordManager;
    }

    @Override
    public TransformationManager getTransformationManager() {
        return this.transformationManager;
    }

    @Override
    public UiManager getUiManager() {
        return this.uiManager;
    }

    @Override
    public PolicyManager getPolicyManager() {
        return this.policyManager;
    }

    @Override
    public TableExportManager getTableExportManager() {
        return this.tableExportManager;
    }

    @Override
    public SelectionManager getSelectionManager() {
        return this.selectionManager;
    }

    @Override
    public ScrutariExportManager getScrutariExportManager() {
        return this.scrutariExportManager;
    }

    @Override
    public SqlExportManager getSqlExportManager() {
        return this.sqlExportManager;
    }

    @Override
    public ExtensionManager getExtensionManager() {
        return this.extensionManager;
    }

    @Override
    public BalayageManager getBalayageManager() {
        return this.balayageManager;
    }

    @Override
    public ExternalScriptManager getExternalScriptManager() {
        return this.externalScriptManager;
    }

    @Override
    public AccessManager getAccessManager() {
        return this.accessManager;
    }

    @Override
    public BdfUserStorage getBdfUserStorage() {
        return this.bdfUserStorage;
    }

    @Override
    public GroupManager getGroupManager() {
        return this.groupManager;
    }

    @Override
    public TreeManager getTreeManager() {
        return this.treeManager;
    }

    @Override
    public L10nManager getL10nManager() {
        return this.l10nManager;
    }

    @Override
    public JsLibManager getJsLibManager() {
        return this.jsLibManager;
    }

    @Override
    public BdfUser createBdfUser(Redacteur redacteur) {
        return BdfUserImpl.build(this, redacteur);
    }

    @Override
    public LangConfiguration getLangConfiguration() {
        return this.langConfiguration;
    }

    @Override
    public void addEditionSessionListener(EditSessionListener editSessionListener) {
        int length = this.editSessionListenerArray.length;
        this.editSessionListenerArray = (EditSessionListener[])ArrayUtils.addUnique(this.editSessionListenerArray, editSessionListener, new EditSessionListener[length + 1]);
    }

    @Override
    public void removeEditionSessionListener(EditSessionListener editSessionListener) {
        int length = this.editSessionListenerArray.length;
        if (length > 0) {
            this.editSessionListenerArray = (EditSessionListener[])ArrayUtils.removeUnique(this.editSessionListenerArray, editSessionListener, new EditSessionListener[length - 1]);
        }
    }

    @Override
    public EditSession initEditSession(EditOrigin editOrigin) {
        return new InternalEditSession(this, editOrigin);
    }

    @Override
    public BuildInfo getBuildInfo() {
        return this.buildInfo;
    }

    @Override
    public ResourceStorages getResourceStorages() {
        return this.resourceStorages;
    }

    @Override
    public StorageRoot getOutputStorage() {
        return this.outputStorage;
    }

    @Override
    public StorageRoot getCacheStorage() {
        return this.cacheStorage;
    }

    @Override
    public JsAnalyser getJsAnalyser() {
        return this.jsAnalyser;
    }

    @Override
    public ExternalSourceProvider getExternalSourceProvider() {
        return this.externalSourceProvider;
    }

    @Override
    public HtmlCleaner getHtmlCleaner() {
        return this.fichothequeEditorProvider.getHtmlCleaner();
    }

    @Override
    public ThesaurusLangChecker getThesaurusLangChecker() {
        return this.thesaurusLangChecker;
    }

    @Override
    public TableExportContext getTableExportContext() {
        return this.tableExportContext;
    }

    @Override
    public ImportationContext getImportationContext() {
        return this.importationContext;
    }

    @Override
    public FichothequeQuestioner getFichothequeQuestioner() {
        return this.fichothequeQuestioner;
    }

    private void fireUseOfFichothequeEditor() {
        EditSessionListener[] array = this.editSessionListenerArray;
        int length = array.length;
        for (int i = 0; i < length; ++i) {
            array[i].useOfFichothequeEditor();
        }
    }

    static {
        SacParserInit.init();
    }

    private static class InternalEditSession
    implements EditSession {
        private final BdfServerImpl bdfServer;
        private final EditOrigin editOrigin;
        private FichothequeEditor fichothequeEditor;
        private BdfServerEditorImpl bdfServerEditor;

        private InternalEditSession(BdfServerImpl bdfServer, EditOrigin editOrigin) {
            this.bdfServer = bdfServer;
            this.editOrigin = editOrigin;
            bdfServer.fichothequeListener.buffer();
        }

        @Override
        public BdfServer getBdfServer() {
            return this.bdfServer;
        }

        @Override
        public FichothequeEditor getFichothequeEditor() {
            if (this.fichothequeEditor == null) {
                this.fichothequeEditor = this.bdfServer.fichothequeEditorProvider.newFichothequeEditor(this.editOrigin);
                this.bdfServer.fireUseOfFichothequeEditor();
            }
            return this.fichothequeEditor;
        }

        @Override
        public BdfServerEditor getBdfServerEditor() {
            if (this.bdfServerEditor == null) {
                this.bdfServerEditor = new BdfServerEditorImpl(this.bdfServer);
            }
            return this.bdfServerEditor;
        }

        @Override
        public void close() {
            this.bdfServer.fichothequeListener.flush();
            if (this.fichothequeEditor != null) {
                this.fichothequeEditor.saveChanges();
            }
            if (this.bdfServerEditor != null) {
                this.bdfServerEditor.saveChanges();
            }
        }
    }
}

