/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.impl;

import fr.exemole.bdfserver.api.balayage.BalayageSession;
import fr.exemole.bdfserver.api.balayage.LockedBalayageException;
import fr.exemole.bdfserver.api.managers.BalayageManager;
import fr.exemole.bdfserver.api.storage.BalayageStorage;
import fr.exemole.bdfserver.api.storage.BdfStorageException;
import fr.exemole.bdfserver.api.storage.StorageContent;
import fr.exemole.bdfserver.tools.balayage.BalayageCompiler;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import net.fichotheque.EditOrigin;
import net.fichotheque.exportation.balayage.BalayageDef;
import net.fichotheque.exportation.balayage.BalayageDescription;
import net.fichotheque.utils.BalayageUtils;
import net.mapeadores.util.io.IOUtils;

class BalayageManagerImpl
implements BalayageManager {
    private static final long ENDED_INTERVAL = 30000L;
    private static final long FREE_INTERVAL = 3600000L;
    private final BalayageStorage balayageStorage;
    private final SortedMap<String, BalayageDescription> balayageDescriptionMap = new TreeMap<String, BalayageDescription>();
    private final Map<String, BalayageLock> lockMap = new HashMap<String, BalayageLock>();
    private List<BalayageDescription> balayageDescriptionList = Collections.emptyList();

    BalayageManagerImpl(BalayageStorage balayageStorage) {
        this.balayageStorage = balayageStorage;
    }

    @Override
    public synchronized void update() {
        BalayageStorage.Unit[] array;
        this.balayageDescriptionMap.clear();
        for (BalayageStorage.Unit storageUnit : array = this.balayageStorage.checkStorage()) {
            BalayageDescription balayageDescription = BalayageCompiler.compile(storageUnit);
            this.balayageDescriptionMap.put(balayageDescription.getName(), balayageDescription);
        }
        this.updateList();
    }

    @Override
    public synchronized List<BalayageDescription> getBalayageDescriptionList() {
        return this.balayageDescriptionList;
    }

    @Override
    public synchronized BalayageDescription getBalayage(String name) {
        return (BalayageDescription)this.balayageDescriptionMap.get(name);
    }

    @Override
    public synchronized String getBalayageContent(String balayageName, String contentPath) {
        StorageContent storageContent = this.balayageStorage.getStorageContent(balayageName, contentPath);
        if (storageContent != null) {
            String string;
            block9: {
                InputStream is = storageContent.getInputStream();
                try {
                    string = IOUtils.toString(is, "UTF-8");
                    if (is == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException ioe) {
                        throw new BdfStorageException(ioe);
                    }
                }
                is.close();
            }
            return string;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BalayageSession openBalayageSession(String name) throws LockedBalayageException {
        Map<String, BalayageLock> map = this.lockMap;
        synchronized (map) {
            BalayageLock balayageLock = this.lockMap.get(name);
            if (balayageLock != null && !balayageLock.canFree()) {
                throw new LockedBalayageException(name);
            }
            balayageLock = new BalayageLock();
            this.lockMap.put(name, balayageLock);
            return new InternalBalayageSession(balayageLock);
        }
    }

    @Override
    public synchronized BalayageDescription putBalayageDef(BalayageDef balayageDef, EditOrigin editOrigin) {
        String balayageName = balayageDef.getName();
        this.balayageStorage.saveBalayageDef(balayageDef, editOrigin);
        return this.reinitBalayage(balayageName);
    }

    @Override
    public synchronized BalayageDescription putBalayageContent(String balayageName, String contentPath, InputStream inputStream, EditOrigin editOrigin) throws IOException {
        this.balayageStorage.saveStorageContent(balayageName, contentPath, inputStream, editOrigin);
        return this.reinitBalayage(balayageName);
    }

    @Override
    public synchronized BalayageDescription removeBalayageContent(String balayageName, String contentPath, EditOrigin editOrigin) {
        boolean done = this.balayageStorage.removeStorageContent(balayageName, contentPath, editOrigin);
        if (done) {
            return this.reinitBalayage(balayageName);
        }
        return null;
    }

    @Override
    public synchronized void removeBalayage(String balayageName, EditOrigin editOrigin) {
        boolean done = this.balayageStorage.removeBalayage(balayageName, editOrigin);
        if (done) {
            this.update();
        }
    }

    private BalayageDescription reinitBalayage(String balayageName) {
        BalayageStorage.Unit storageUnit = this.balayageStorage.getBalayageStorageUnit(balayageName);
        BalayageDescription balayageDescription = BalayageCompiler.compile(storageUnit);
        this.balayageDescriptionMap.put(balayageName, balayageDescription);
        this.updateList();
        return balayageDescription;
    }

    private void updateList() {
        this.balayageDescriptionList = BalayageUtils.wrap(this.balayageDescriptionMap.values().toArray(new BalayageDescription[this.balayageDescriptionMap.size()]));
    }

    private static class BalayageLock {
        private boolean ended = false;
        private long time = System.currentTimeMillis();

        private BalayageLock() {
        }

        private void end() {
            if (!this.ended) {
                this.ended = true;
                this.time = System.currentTimeMillis();
            }
        }

        private boolean canFree() {
            long delay = System.currentTimeMillis() - this.time;
            if (this.ended) {
                return delay > 30000L;
            }
            return delay > 3600000L;
        }
    }

    private class InternalBalayageSession
    implements BalayageSession {
        private final BalayageLock balayageLock;

        private InternalBalayageSession(BalayageLock balayageLock) {
            this.balayageLock = balayageLock;
        }

        @Override
        public void close() {
            this.balayageLock.end();
        }
    }
}

