/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.htmlproducers.thesaurus;

import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.api.roles.SatelliteOpportunities;
import fr.exemole.bdfserver.html.BdfHtmlUtils;
import fr.exemole.bdfserver.html.BdfServerHtmlProducer;
import fr.exemole.bdfserver.html.consumers.Button;
import fr.exemole.bdfserver.html.consumers.Grid;
import fr.exemole.bdfserver.html.consumers.PageUnit;
import fr.exemole.bdfserver.html.consumers.SatelliteTree;
import fr.exemole.bdfserver.html.consumers.SelectOption;
import fr.exemole.bdfserver.html.consumers.Tree;
import fr.exemole.bdfserver.html.consumers.attributes.Appelant;
import fr.exemole.bdfserver.html.consumers.attributes.Deploy;
import fr.exemole.bdfserver.html.jslib.BdfJsLibs;
import fr.exemole.bdfserver.htmlproducers.main.MainHtmlUtils;
import fr.exemole.bdfserver.htmlproducers.thesaurus.ThesaurusParameters;
import fr.exemole.bdfserver.tools.BH;
import fr.exemole.bdfserver.tools.BdfServerUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.fichotheque.SubsetItem;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.permission.PermissionSummary;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.thesaurus.metadata.ThesaurusMetadata;
import net.fichotheque.tools.eligibility.LabelPredicate;
import net.fichotheque.tools.eligibility.MultiPredicateBuilder;
import net.fichotheque.tools.eligibility.SatellitePredicate;
import net.fichotheque.utils.FichothequeUtils;
import net.mapeadores.util.html.HA;
import net.mapeadores.util.html.HtmlAttributes;
import net.mapeadores.util.html.HtmlPrinter;
import net.mapeadores.util.html.HtmlWrapper;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.Langs;
import net.mapeadores.util.text.Idalpha;
import net.mapeadores.util.text.Label;

public class ThesaurusHtmlProducer
extends BdfServerHtmlProducer {
    private static final HtmlWrapper CHILD_TREE = Tree.tree("thesaurus-ChildTree");
    private static final HtmlWrapper CHILD_LEAF = Tree.leaf("thesaurus-ChildLeaf");
    private static final Button GO_BUTTON = Button.submit().action("action-Go").tooltipMessage("_ link.global.go");
    private static final Button FILTER_BUTTON = Button.submit("_ submit.global.apply");
    private static final SelectOption EMPTY_OPTION = SelectOption.init("").text("---");
    private static final SelectOption[] LABELFILTER_OPTIONS = new SelectOption[]{EMPTY_OPTION, SelectOption.init("with").textL10nObject("_ label.thesaurus.labelfilter_with"), SelectOption.init("withoutlabel").textL10nObject("_ label.thesaurus.labelfilter_without")};
    private static final SelectOption[] SATELLITEFILTER_OPTIONS = new SelectOption[]{EMPTY_OPTION, SelectOption.init("with").textL10nObject("_ label.thesaurus.satellitefilter_with"), SelectOption.init("withoutlabel").textL10nObject("_ label.thesaurus.satellitefilter_without")};
    private final PermissionSummary permissionSummary;
    private final Thesaurus thesaurus;
    private final ThesaurusParameters thesaurusParameters;
    private final Lang thesaurusLang;
    private final Predicate<SubsetItem> motclePredicate;
    private final boolean isSubsetAdmin;
    private final MessageFormat idFormat;
    private final MotcleBlock motcleBlock = new MotcleBlock();
    private final Button linkButton = Button.link();
    private final Consumer<HtmlPrinter> listTitle = new ListTitle();
    private final Corpus[] satelliteCorpusArray;
    private final Corpus[] filterSatelliteCorpusArray;
    private final SatelliteTree satelliteTree;
    private final boolean withFontAwesome;

    public ThesaurusHtmlProducer(BdfParameters bdfParameters, Thesaurus thesaurus, ThesaurusParameters thesaurusParameters) {
        super(bdfParameters);
        this.addJsLib(BdfJsLibs.DEPLOY);
        this.addJsLib(BdfJsLibs.SUBSETCHANGE);
        this.addJsLib(BdfJsLibs.APPELANT);
        this.addThemeCss("thesaurus.css");
        this.setBodyCssClass("global-body-ListFrame");
        this.permissionSummary = bdfParameters.getPermissionSummary();
        this.thesaurus = thesaurus;
        this.thesaurusParameters = thesaurusParameters;
        this.satelliteCorpusArray = this.initSatelliteArray();
        this.thesaurusLang = this.initThesaurusLang(thesaurusParameters);
        this.filterSatelliteCorpusArray = this.initFilterSatelliteArray(thesaurusParameters);
        this.motclePredicate = this.initMotclePredicate(thesaurusParameters);
        this.isSubsetAdmin = this.permissionSummary.isSubsetAdmin(thesaurus.getSubsetKey());
        this.setMainStorageKey("thesaurus", "thesaurus", thesaurus.getSubsetName());
        this.idFormat = new MessageFormat(this.getLocalization("_ info.main.motclenumber"), this.getFormatLocale());
        this.satelliteTree = this.satelliteCorpusArray.length > 0 ? new SatelliteTree(this.workingLang, this.formatLocale) : null;
        ThesaurusMetadata thesaurusMetadata = thesaurus.getThesaurusMetadata();
        this.motcleBlock.longStyle(thesaurusMetadata.isLongIdalphaStyle()).bracketsStyle(thesaurusMetadata.isBracketsIdalphaStyle());
        this.withFontAwesome = this.checkFontAwesome();
    }

    @Override
    public void printHtml() {
        this.start();
        this.__(BdfHtmlUtils.startSubsetUnit(this, this.bdfParameters, this.thesaurus, "thesaurus")).__(this.printCommands()).__(this.printMisc()).__(PageUnit.END).__(this.printMotcleList());
        this.end();
    }

    private Lang initThesaurusLang(ThesaurusParameters thesaurusParameters) {
        Lang labelLang = thesaurusParameters.getLabelLang();
        if (labelLang != null) {
            return labelLang;
        }
        return BdfServerUtils.checkLangDisponibility(this.bdfServer, this.thesaurus, this.workingLang);
    }

    private Corpus[] initSatelliteArray() {
        List<Corpus> satelliteCorpusList = this.thesaurus.getSatelliteCorpusList();
        ArrayList<Corpus> result = new ArrayList<Corpus>();
        for (Corpus corpus : satelliteCorpusList) {
            if (!this.permissionSummary.hasAccess(corpus)) continue;
            result.add(corpus);
        }
        return result.toArray(new Corpus[result.size()]);
    }

    private Corpus[] initFilterSatelliteArray(ThesaurusParameters thesaurusParameters) {
        if (this.satelliteCorpusArray.length == 0) {
            return null;
        }
        SubsetKey satelliteCorpusKey = thesaurusParameters.getSatelliteCorpusKey();
        if (satelliteCorpusKey == null) {
            return null;
        }
        for (Corpus corpus : this.satelliteCorpusArray) {
            if (!corpus.getSubsetKey().equals(satelliteCorpusKey)) continue;
            Corpus[] array = new Corpus[]{corpus};
            return array;
        }
        return null;
    }

    private Predicate<SubsetItem> initMotclePredicate(ThesaurusParameters thesaurusParameters) {
        String satelliteFilter;
        MultiPredicateBuilder builder = new MultiPredicateBuilder();
        String labelFilter = thesaurusParameters.getLabelFilter();
        if (labelFilter != null) {
            switch (labelFilter) {
                case "with": {
                    builder.add(new LabelPredicate(this.thesaurusLang, true));
                    break;
                }
                case "withoutlabel": {
                    builder.add(new LabelPredicate(this.thesaurusLang, false));
                }
            }
        }
        if ((satelliteFilter = thesaurusParameters.getSatelliteFilter()) != null && this.satelliteCorpusArray.length > 0) {
            Corpus[] array = this.filterSatelliteCorpusArray != null ? this.filterSatelliteCorpusArray : this.satelliteCorpusArray;
            switch (satelliteFilter) {
                case "with": {
                    builder.add(new SatellitePredicate(this.thesaurus, array, true));
                    break;
                }
                case "withoutlabel": {
                    builder.add(new SatellitePredicate(this.thesaurus, array, false));
                }
            }
        }
        if (builder.isEmpty()) {
            return null;
        }
        return builder.toPredicate();
    }

    private boolean printCommands() {
        if (!this.isSubsetAdmin) {
            return false;
        }
        this.DETAILS(HA.id("details_commands").open(true).classes("tools-Details").populate(Deploy.DETAILS)).SUMMARY().__localize("_ title.global.commands")._SUMMARY().DIV("tools-List").__(this.link("action-New", "motcle-creationform", "_ link.thesaurus.motclecreationform")).__(this.link("action-Metadata", "thesaurus-metadataform", "_ link.thesaurus.thesaurusmetadataform")).__(this.link("action-Advanced", "thesaurus-advancedcommands", "_ link.thesaurus.thesaurusadvancedcommands")).__(this.link("action-Refresh", "thesaurus", "_ link.global.reload"))._DIV()._DETAILS();
        return true;
    }

    private boolean printMisc() {
        if (this.isSubsetAdmin) {
            this.DETAILS(HA.id("details_misc").classes("tools-Details").populate(Deploy.DETAILS)).SUMMARY().__localize("_ title.thesaurus.misc")._SUMMARY().DIV("tools-List").__(MainHtmlUtils.printTableDisplayDetails(this, this.bdfServer, this.bdfUser, this.thesaurus, false, HA.id("details_tabledisplay").classes("tools-Details").populate(Deploy.DETAILS))).__(this.printStatsLinks()).__(this.printGoForm())._DIV()._DETAILS();
        } else {
            this.__(MainHtmlUtils.printTableDisplayDetails(this, this.bdfServer, this.bdfUser, this.thesaurus, false, HA.id("details_tabledisplay").classes("tools-Details").populate(Deploy.DETAILS))).__(this.printStatsLinks());
        }
        return true;
    }

    private Button link(String action, String pageName, String messageKey) {
        String href = BH.domain("thesaurus").subset(this.thesaurus).page(pageName).toString();
        String target = pageName.equals("thesaurus") ? null : "Edition";
        return this.linkButton.href(href).action(action).textL10nObject(messageKey).target(target);
    }

    private boolean printStatsLinks() {
        String thesaurusName = this.thesaurus.getSubsetName();
        this.DETAILS(HA.id("details_stats").classes("tools-Details").populate(Deploy.DETAILS)).SUMMARY().__localize("_ link.global.stats")._SUMMARY().__(MainHtmlUtils.DISPLAYTABLE_TREE, () -> this.__(this.printStatLeaf(thesaurusName, "stats", "_ link.motcles.stats")).__(this.printStatLeaf(thesaurusName, "statssel", "_ link.motcles.statssel")).__(this.printStatLeaf(thesaurusName, "inverse", "_ link.motcles.inverse")))._DETAILS();
        return true;
    }

    private boolean printStatLeaf(String thesaurusName, String option, String messageKey) {
        String href = "motcles/" + thesaurusName + "-" + option;
        Button button = Button.link().style("transparent");
        this.__(MainHtmlUtils.DISPLAYTABLE_LEAF, () -> this.SPAN("displaytable-Title").__localize(messageKey).__colon()._SPAN().__(button.href(href + ".html").action("action-TableDisplay").tooltipMessage("_ link.global.version", "HTML").target("Edition")).__(button.href(href + ".ods").action("action-Ods").tooltipMessage("_ link.global.version", "ODS").target(null)));
        return true;
    }

    private boolean printGoForm() {
        if (!this.isSubsetAdmin) {
            return false;
        }
        this.DETAILS(HA.id("details_go").classes("tools-Details").populate(Deploy.DETAILS)).SUMMARY().__localize("_ label.menu.goto")._SUMMARY().FORM_get("thesaurus", "Edition").DIV("thesaurus-GoBlock").INPUT_hidden("page", "motcle-changeform").INPUT_hidden("thesaurus", this.thesaurus.getSubsetName()).INPUT_text(this.name("idmtcl").size("8").populate(Appelant.motcle().wanted_code_id().limit(1).subsets(this.thesaurus.getSubsetKey()))).__(GO_BUTTON)._DIV()._FORM()._DETAILS();
        return true;
    }

    private boolean printFilterDetails() {
        if (!ThesaurusHtmlProducer.withFilter(this.thesaurus)) {
            return false;
        }
        this.DETAILS("tools-Details thesaurus-FilterDetails").SUMMARY().__localize("_ label.thesarus.filtersandoptions")._SUMMARY().DIV("global-DetailPanel").FORM_get("thesaurus").INPUT_hidden("page", "thesaurus").INPUT_hidden("thesaurus", this.thesaurus.getSubsetName()).__(Grid.START).__(this.printLangSelect()).__(this.printLabelFilterSelect()).__(this.printSatelliteCorpus()).__(this.printSatelliteFilterSelect()).__(Grid.END).__(FILTER_BUTTON)._FORM()._DIV()._DETAILS();
        return true;
    }

    private boolean printLabelFilterSelect() {
        String currentFilter = this.thesaurusParameters.getLabelFilter();
        this.__(Grid.selectRow((Object)"_ label.thesaurus.labelfilter", this.name("labelfilter"), () -> {
            for (SelectOption option : LABELFILTER_OPTIONS) {
                this.__(option, currentFilter);
            }
        }));
        return true;
    }

    private boolean printSatelliteFilterSelect() {
        if (this.satelliteCorpusArray.length == 0) {
            return false;
        }
        String currentFilter = this.thesaurusParameters.getSatelliteFilter();
        this.__(Grid.selectRow((Object)"_ label.thesaurus.satellitefilter", this.name("satellitefilter"), () -> {
            for (SelectOption option : SATELLITEFILTER_OPTIONS) {
                this.__(option, currentFilter);
            }
        }));
        return true;
    }

    private boolean printLangSelect() {
        Langs langs = this.bdfServer.getThesaurusLangChecker().getAuthorizedLangs(this.thesaurus);
        if (langs.size() < 2) {
            return false;
        }
        Lang labelLang = this.thesaurusParameters.getLabelLang();
        String selected = labelLang != null ? labelLang.toString() : "";
        this.__(Grid.selectRow((Object)"_ label.thesaurus.labellang", this.name("labellang"), () -> {
            this.__(EMPTY_OPTION, selected.isEmpty());
            for (Lang lang : langs) {
                String langString = lang.toString();
                this.OPTION(langString, langString.equals(selected)).__escape(langString).__dash().__localize(langString)._OPTION();
            }
        }));
        return true;
    }

    private boolean printSatelliteCorpus() {
        if (this.satelliteCorpusArray.length == 0) {
            return false;
        }
        SubsetKey satelliteCorpusKey = this.thesaurusParameters.getSatelliteCorpusKey();
        this.__(Grid.selectRow((Object)"_ link.global.satellites", this.name("satellitecorpus"), () -> {
            this.__(EMPTY_OPTION, satelliteCorpusKey == null);
            for (Corpus corpus : this.satelliteCorpusArray) {
                SubsetKey currentCorpusKey = corpus.getSubsetKey();
                boolean selected = false;
                if (satelliteCorpusKey != null && currentCorpusKey.equals(satelliteCorpusKey)) {
                    selected = true;
                }
                this.OPTION(currentCorpusKey.getSubsetName(), selected).__escape(FichothequeUtils.getTitle(this.fichotheque, currentCorpusKey, this.workingLang, this.permissionSummary.isSubsetAdmin(currentCorpusKey)))._OPTION();
            }
        }));
        return true;
    }

    private boolean printMotcleList() {
        List<Motcle> firstLevel = this.thesaurus.getFirstLevelList();
        if (firstLevel.isEmpty()) {
            return false;
        }
        int eligibleCount = -1;
        if (this.motclePredicate != null) {
            eligibleCount = 0;
            for (Motcle motcle : this.thesaurus.getMotcleList()) {
                if (!this.motclePredicate.test(motcle)) continue;
                ++eligibleCount;
            }
        }
        if (eligibleCount == -1 && firstLevel.size() != this.thesaurus.size()) {
            this.printTree(firstLevel);
        } else {
            this.printList(firstLevel, eligibleCount);
        }
        return true;
    }

    private boolean printTree(List<Motcle> firstLevel) {
        this.motcleBlock.treeMode(true);
        this.__(PageUnit.start(this.listTitle).sectionCss("unit-Unit thesaurus-MotcleListUnit")).__(this.printFilterDetails()).UL("subsetitem-List");
        for (Motcle motcle : firstLevel) {
            this.LI().__(this.motcleBlock.current(motcle))._LI();
        }
        this._UL().__(PageUnit.END);
        return true;
    }

    private boolean printList(List<Motcle> motcleList, int eligibleCount) {
        this.__(PageUnit.start(this.listTitle).sectionCss("unit-Unit thesaurus-MotcleListUnit")).__(this.printFilterDetails());
        if (eligibleCount != -1) {
            this.P("thesaurus-FilterResult").__localize("_ label.thesaurus.filterresult").__colon().__escape(this.bdfUser.format(eligibleCount)).__escape(" / ").__escape(this.bdfUser.format(this.thesaurus.size()))._P();
        }
        if (eligibleCount != 0) {
            this.UL("subsetitem-List");
            for (Motcle motcle : motcleList) {
                this.__(this.printListMotcle(motcle));
            }
            this._UL();
        }
        this.__(PageUnit.END);
        return true;
    }

    private boolean printListMotcle(Motcle motcle) {
        List<Motcle> childList;
        boolean include = true;
        if (this.motclePredicate != null) {
            include = this.motclePredicate.test(motcle);
        }
        if (include) {
            this.LI().__(this.motcleBlock.current(motcle))._LI();
        }
        if (!(childList = motcle.getChildList()).isEmpty()) {
            for (Motcle child : childList) {
                this.printListMotcle(child);
            }
        }
        return true;
    }

    private boolean printChildList(List<Motcle> childList) {
        if (childList.isEmpty()) {
            return false;
        }
        this.__(CHILD_TREE, () -> {
            for (Motcle child : childList) {
                this.__(CHILD_LEAF, this.motcleBlock.current(child));
            }
        });
        return true;
    }

    private static boolean withFilter(Thesaurus thesaurus) {
        return !thesaurus.isBabelienType();
    }

    private class MotcleBlock
    implements Consumer<HtmlPrinter> {
        private final HtmlAttributes editButton = HA.href("").target("Edition").classes("button-Circle action-MotcleEdit");
        private final Button motcleLinkButton = Button.link().target("Edition");
        private Motcle motcle;
        private boolean treeMode = false;
        private boolean longStyle = false;
        private boolean bracketsStyle = false;

        private MotcleBlock() {
        }

        private MotcleBlock current(Motcle motcle) {
            this.motcle = motcle;
            return this;
        }

        private MotcleBlock treeMode(boolean treeMode) {
            this.treeMode = treeMode;
            return this;
        }

        private MotcleBlock longStyle(boolean longStyle) {
            this.longStyle = longStyle;
            return this;
        }

        private MotcleBlock bracketsStyle(boolean bracketsStyle) {
            this.bracketsStyle = bracketsStyle;
            return this;
        }

        @Override
        public void accept(HtmlPrinter hp) {
            Object[] objs = new Object[]{this.motcle.getId()};
            hp.DIV(HA.id("motcle_" + this.motcle.getId()).classes("subsetitem-Title")).P().__(BdfHtmlUtils.printMotcleIcon(hp, this.motcle, ThesaurusHtmlProducer.this.withFontAwesome)).__(this.printMotcleLabel(hp, ThesaurusHtmlProducer.this.thesaurusLang))._P().__(this.printMotcleEdit(hp, ThesaurusHtmlProducer.this.isSubsetAdmin))._DIV().DIV("subsetitem-Infos").__escape(ThesaurusHtmlProducer.this.idFormat.format(objs))._DIV().__(this.printCommandDetails(hp, ThesaurusHtmlProducer.this.isSubsetAdmin)).__(this.printSatelliteDetails(hp));
            if (this.treeMode) {
                ThesaurusHtmlProducer.this.printChildList(this.motcle.getChildList());
            }
        }

        private boolean printSatelliteDetails(HtmlPrinter hp) {
            Corpus[] array;
            if (ThesaurusHtmlProducer.this.satelliteCorpusArray.length == 0) {
                return false;
            }
            boolean open = false;
            if (ThesaurusHtmlProducer.this.filterSatelliteCorpusArray != null) {
                array = ThesaurusHtmlProducer.this.filterSatelliteCorpusArray;
                open = true;
            } else {
                array = ThesaurusHtmlProducer.this.satelliteCorpusArray;
            }
            SatelliteOpportunities satelliteOpportunities = BdfServerUtils.getSatelliteOpportunities(this.motcle, ThesaurusHtmlProducer.this.permissionSummary, array);
            List<SatelliteOpportunities.Entry> entryList = satelliteOpportunities.getEntryList();
            if (entryList.isEmpty()) {
                return false;
            }
            hp.DETAILS(HA.open(open).classes("tools-Details")).SUMMARY().__localize("_ link.global.satellites")._SUMMARY().__(ThesaurusHtmlProducer.this.satelliteTree.current(this.motcle, satelliteOpportunities))._DETAILS();
            return true;
        }

        private boolean printCommandDetails(HtmlPrinter hp, boolean editable) {
            if (!editable) {
                return false;
            }
            hp.DETAILS("tools-Details").SUMMARY().__localize("_ title.global.commands")._SUMMARY().DIV("tools-List").__(this.childLink()).__(this.motcleLink("action-Advanced", "motcle-advancedcommands", "_ link.thesaurus.motcleadvancedcommands")).__(this.motcleLink("action-MotcleIndexation", "motcle-indexationform", "_ link.thesaurus.motcleindexationform")).__(this.motcleLink("action-MotclePonderation", "motcle-ponderationform", "_ link.thesaurus.motcleponderationform")).__(this.motcleLink("action-MotcleSelectionIndexation", "motcle-selectionindexationform", "_ link.thesaurus.selectionindexationform"))._DIV()._DETAILS();
            return true;
        }

        private Button childLink() {
            if (this.motcle.getStatus().equals("obsolete")) {
                return null;
            }
            String childHref = BH.domain("thesaurus").page("motcle-creationform").subset(ThesaurusHtmlProducer.this.thesaurus).param("parent", String.valueOf(this.motcle.getId())).toString();
            return this.motcleLinkButton.href(childHref).action("action-New").textL10nObject("_ link.thesaurus.motclecreationform_child");
        }

        private Button motcleLink(String action, String page, String titleLocKey) {
            if (!action.equals("action-Advanced") && !this.motcle.getStatus().equals("active")) {
                return null;
            }
            String href = BH.domain("thesaurus").page(page).subsetItem(this.motcle).toString();
            return this.motcleLinkButton.href(href).action(action).textL10nObject(titleLocKey);
        }

        private boolean printMotcleLabel(HtmlPrinter hp, Lang lang) {
            Label label;
            String idalpha = this.motcle.getIdalpha();
            String labelString = this.motcle.isBabelienType() ? this.motcle.getBabelienLabel().getLabelString() : ((label = this.motcle.getLabels().getLangPartCheckedLabel(lang)) != null ? label.getLabelString() : "?");
            String statusClass = this.getStatusClass();
            if (!statusClass.isEmpty()) {
                hp.SPAN(statusClass);
            }
            if (idalpha != null) {
                boolean significant = Idalpha.isSignificant(idalpha);
                if (this.longStyle) {
                    if (!significant) {
                        hp.SPAN("thesaurus-LongIdalpha").SMALL().__escape("(").__escape(idalpha).__escape(")")._SMALL()._SPAN().__space();
                    } else if (this.bracketsStyle) {
                        hp.SPAN("thesaurus-LongIdalpha").__escape("[").__escape(idalpha).__escape("]")._SPAN().__space();
                    } else {
                        hp.SPAN("thesaurus-LongIdalpha").__escape(idalpha)._SPAN().__space();
                    }
                    hp.SPAN("thesaurus-LongLabel").__escape(labelString)._SPAN();
                } else {
                    if (!significant) {
                        hp.SMALL().__escape("(").__escape(idalpha).__escape(")")._SMALL().__space();
                    } else if (this.bracketsStyle) {
                        hp.__escape("[").__escape(idalpha).__escape("]").__space();
                    } else {
                        hp.__escape(idalpha).__dash();
                    }
                    hp.__escape(labelString);
                }
            } else {
                hp.__escape(labelString);
            }
            if (!statusClass.isEmpty()) {
                hp._SPAN();
            }
            return true;
        }

        private boolean printMotcleEdit(HtmlPrinter hp, boolean editable) {
            if (!editable) {
                return false;
            }
            hp.A(this.editButton.href(BH.domain("thesaurus").page("motcle-changeform").subsetItem(this.motcle))).__(Button.ICON)._A();
            return true;
        }

        private String getStatusClass() {
            switch (this.motcle.getStatus()) {
                case "group": {
                    return "thesaurus-Group";
                }
                case "obsolete": {
                    return "thesaurus-Obsolete";
                }
            }
            return "";
        }
    }

    private class ListTitle
    implements Consumer<HtmlPrinter> {
        private ListTitle() {
        }

        @Override
        public void accept(HtmlPrinter hp) {
            hp.SPAN("thesaurus-MotcleListTitle").__localize("_ title.thesaurus.motcles").__space().__(BdfHtmlUtils.printItemCount(hp, ThesaurusHtmlProducer.this.bdfUser, ThesaurusHtmlProducer.this.thesaurus.size()))._SPAN();
            if (ThesaurusHtmlProducer.this.isSubsetAdmin) {
                hp.__(Button.link().style("transparent").href(BH.domain("thesaurus").subset(ThesaurusHtmlProducer.this.thesaurus).page("motcle-creationform")).action("action-New").tooltipMessage("_ link.thesaurus.motclecreationform").target("Edition"));
            }
        }
    }
}

