/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.htmlproducers.importation;

import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.api.subsettree.SubsetTree;
import fr.exemole.bdfserver.html.BdfServerHtmlProducer;
import fr.exemole.bdfserver.html.consumers.Grid;
import fr.exemole.bdfserver.html.consumers.SubsetTreeOptions;
import fr.exemole.bdfserver.html.jslib.BdfJsLibs;
import fr.exemole.bdfserver.html.jslib.MiscJsLibs;
import fr.exemole.bdfserver.htmlproducers.importation.ImportationHtmlUtils;
import java.util.Map;
import net.fichotheque.tools.importation.parsers.thesaurus.ThesaurusRowParser;
import net.mapeadores.util.html.CommandBox;
import net.mapeadores.util.html.HtmlAttributes;

public class ThesaurusImportHtmlProducer
extends BdfServerHtmlProducer {
    public ThesaurusImportHtmlProducer(BdfParameters bdfParameters) {
        super(bdfParameters);
        this.addJsLib(BdfJsLibs.DEPLOY);
        this.addJsLib(MiscJsLibs.IMPORTATION);
        this.addThemeCss("importation.css");
    }

    @Override
    public void printHtml() {
        Map<String, String> storeMap = this.getStoredValues("form_import_thesaurus");
        String currentType = ThesaurusImportHtmlProducer.getCurrentType(storeMap);
        this.start();
        this.printCommandMessageUnit();
        SubsetTree thesaurusTree = this.bdfServer.getTreeManager().getSubsetTree((short)2);
        CommandBox commandBox = CommandBox.init().action("importation").family("THS").page("importation-confirm").target("_blank").name("ThesaurusImportParse").lockey("_ IMP-02").submitLocKey("_ submit.importation.parse");
        this.__start(commandBox).__(Grid.START).__(Grid.selectRow((Object)"_ label.importation.thesaurus", this.name("thesaurus").attr("data-subset", "selection"), SubsetTreeOptions.init(thesaurusTree, this.bdfServer, this.workingLang).onlyNames(true).selectedSubsetKey((short)2, storeMap).withKeys(true))).__(Grid.choiceSetRow((Object)"_ label.importation.thesaurusimporttype", () -> this.__(this.printTypeRadio("creation", "_ label.importation.thesaurusimporttype_creation", currentType)).__(this.printTypeRadio("change", "_ label.importation.thesaurusimporttype_change", currentType)).__(this.printTypeRadio("remove", "_ label.importation.thesaurusimporttype_remove", currentType)).__(this.printTypeRadio("merge", "_ label.importation.thesaurusimporttype_merge", currentType)).__(this.printMoveRadio(thesaurusTree, currentType)))).__(ImportationHtmlUtils.printImportParseRows(this, storeMap)).__(Grid.END).__end(commandBox);
        this.end();
    }

    private boolean printTypeRadio(String type, String messageKey, String current) {
        boolean checked = current.equals(type);
        HtmlAttributes radio = this.name("type").value(type).checked(checked);
        this.__(Grid.radioCell(messageKey, radio));
        return true;
    }

    private boolean printMoveRadio(SubsetTree thesaurusTree, String current) {
        boolean checked = current.equals("move");
        HtmlAttributes radio = this.name("type").value("move").checked(checked);
        this.__(Grid.radioCell((Object)"_ label.importation.thesaurusimporttype_move", radio, () -> this.__(Grid.START).__(Grid.selectRow((Object)"_ label.importation.destinationthesaurus", this.name("destinationthesaurus"), SubsetTreeOptions.init(thesaurusTree, this.bdfServer, this.workingLang).onlyNames(true).withKeys(true))).__(Grid.END)));
        return true;
    }

    private static String getCurrentType(Map<String, String> storeMap) {
        String defaultType = "creation";
        String current = storeMap.get("type");
        if (current == null) {
            return defaultType;
        }
        try {
            return ThesaurusRowParser.checkParseType(current);
        }
        catch (IllegalArgumentException iae) {
            return defaultType;
        }
    }
}

