/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.htmlproducers.configuration;

import fr.exemole.bdfserver.api.groups.GroupDef;
import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.api.managers.GroupManager;
import fr.exemole.bdfserver.html.BdfServerHtmlProducer;
import fr.exemole.bdfserver.html.consumers.PageUnit;
import fr.exemole.bdfserver.html.jslib.BdfJsLibs;
import fr.exemole.bdfserver.htmlproducers.configuration.ConfigurationCommandBoxUtils;
import java.util.List;
import net.mapeadores.util.html.CommandBox;
import net.mapeadores.util.localisation.Langs;

public class GroupFormHtmlProducer
extends BdfServerHtmlProducer {
    public GroupFormHtmlProducer(BdfParameters bdfParameters) {
        super(bdfParameters);
        this.addJsLib(BdfJsLibs.COMMANDTEST);
        this.addJsLib(BdfJsLibs.COMMANDVEIL);
        this.addJsLib(BdfJsLibs.DEPLOY);
        this.addJsLib(BdfJsLibs.CODEMIRRORMODE);
    }

    @Override
    public void printHtml() {
        GroupManager groupManager = this.bdfServer.getGroupManager();
        Langs workingLangs = this.bdfServer.getLangConfiguration().getWorkingLangs();
        CommandBox commandBox = CommandBox.init().action("configuration").family("CNF").veil(true).page("config-groups");
        this.start();
        this.printCommandMessageUnit();
        this.printGroupListUnit(groupManager.getGroupDefList(), commandBox.mode("subunit"), workingLangs);
        ConfigurationCommandBoxUtils.printGroupCreationBox(this, commandBox.mode(""), workingLangs);
        this.end();
    }

    private boolean printGroupListUnit(List<GroupDef> groupDefList, CommandBox commandBox, Langs langs) {
        if (groupDefList.isEmpty()) {
            return false;
        }
        this.__(PageUnit.start("action-Groups", "_ link.configuration.groupform")).DL("global-DL");
        for (GroupDef groupDef : groupDefList) {
            String title = groupDef.getTitleLabels().seekLabelString(this.workingLang, null);
            this.DT().SPAN("cm-component-group").__escape(groupDef.getName())._SPAN().__if(title != null, () -> this.__space().SPAN("cm-comment").__escape('(').__escape(title).__escape(')')._SPAN())._DT().DD().__(this.printGroupChangeDetails(groupDef, commandBox, langs)).__(this.printGroupRemoveDetails(groupDef, commandBox))._DD();
        }
        this._DL().__(PageUnit.END);
        return true;
    }

    private boolean printGroupChangeDetails(GroupDef groupDef, CommandBox commandBox, Langs langs) {
        this.DETAILS("command-Details").SUMMARY().__localize("_ link.global.change")._SUMMARY().__(ConfigurationCommandBoxUtils.printGroupChangeBox(this, commandBox, groupDef, langs))._DETAILS();
        return true;
    }

    private boolean printGroupRemoveDetails(GroupDef groupDef, CommandBox commandBox) {
        this.DETAILS("command-Details").SUMMARY().__localize("_ link.global.delete")._SUMMARY().__(ConfigurationCommandBoxUtils.printGroupRemoveBox(this, commandBox, groupDef))._DETAILS();
        return true;
    }
}

