/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.get.streamproducers.transformation;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.api.managers.TransformationManager;
import fr.exemole.bdfserver.get.streamproducers.ExtractionXmlProducer;
import fr.exemole.bdfserver.get.streamproducers.transformation.PropertiesStreamTemplateProducer;
import fr.exemole.bdfserver.get.streamproducers.transformation.SimpleTemplateProducer;
import fr.exemole.bdfserver.get.streamproducers.transformation.XsltStreamTemplateProducer;
import fr.exemole.bdfserver.tools.exportation.table.BdfTableExportUtils;
import fr.exemole.bdfserver.tools.exportation.transformation.BdfTransformationUtils;
import fr.exemole.bdfserver.tools.exportation.transformation.DefaultExtractionDefFactory;
import fr.exemole.bdfserver.tools.exportation.transformation.TransformerParameters;
import fr.exemole.bdfserver.tools.users.BdfUserUtils;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.Fiches;
import net.fichotheque.exportation.table.Cell;
import net.fichotheque.exportation.table.SubsetTable;
import net.fichotheque.exportation.table.SumCellConverter;
import net.fichotheque.exportation.transformation.NoDefaultTemplateException;
import net.fichotheque.exportation.transformation.SimpleTemplate;
import net.fichotheque.exportation.transformation.StreamTemplate;
import net.fichotheque.exportation.transformation.TemplateKey;
import net.fichotheque.exportation.transformation.TransformationKey;
import net.fichotheque.extraction.ExtractParameters;
import net.fichotheque.extraction.ExtractionContext;
import net.fichotheque.extraction.ExtractionSource;
import net.fichotheque.extraction.def.ExtractionDef;
import net.fichotheque.tools.extraction.ExtractionDefFilterEngine;
import net.fichotheque.tools.extraction.ExtractionEngine;
import net.fichotheque.tools.extraction.ExtractionEngineUtils;
import net.mapeadores.util.attr.Attributes;
import net.mapeadores.util.io.StreamProducer;
import net.mapeadores.util.servlets.exceptions.BadRequestException;
import net.mapeadores.util.text.ValidExtension;
import net.mapeadores.util.xml.XMLUtils;
import net.mapeadores.util.xml.XmlProducer;

public final class TransformationFactory {
    private final BdfParameters bdfParameters;
    private final BdfServer bdfServer;
    private final Map<String, String> outputProperties = new HashMap<String, String>();
    private ExtractionContext extractionContext;
    private TransformationKey transformationKey;
    private Fiches staticFiches = null;
    private String templateName = "";
    private Object dynamicObject = null;
    private String sourceString = null;
    private ValidExtension streamExtension = null;
    private String extraXml = null;
    private Predicate<FicheMeta> fichePredicate = null;

    public TransformationFactory(BdfParameters bdfParameters) {
        this.bdfParameters = bdfParameters;
        this.bdfServer = bdfParameters.getBdfServer();
    }

    public TransformationFactory extractionContext(ExtractionContext extractionContext) {
        this.extractionContext = extractionContext;
        return this;
    }

    public TransformationFactory transformationKey(TransformationKey transformationKey) {
        this.transformationKey = transformationKey;
        return this;
    }

    public TransformationFactory dynamicObject(Object dynamicObject) {
        this.dynamicObject = dynamicObject;
        return this;
    }

    public TransformationFactory templateName(String templateName) {
        if (templateName == null) {
            templateName = "";
        }
        this.templateName = templateName;
        return this;
    }

    public TransformationFactory sourceString(String sourceString) {
        this.sourceString = sourceString;
        return this;
    }

    public TransformationFactory streamExtension(ValidExtension streamExtension) {
        this.streamExtension = streamExtension;
        return this;
    }

    public TransformationFactory extraXml(String extraXml) {
        this.extraXml = extraXml;
        return this;
    }

    public TransformationFactory staticFiches(Fiches staticFiches) {
        this.staticFiches = staticFiches;
        return this;
    }

    public TransformationFactory fichePredicate(Predicate<FicheMeta> fichePredicate) {
        this.fichePredicate = fichePredicate;
        return this;
    }

    public TransformationFactory outputProperty(String name, String value) {
        this.outputProperties.put(name, value);
        return this;
    }

    public XmlProducer getSourceXmlProducer() {
        XmlProducer xmlProducer;
        if (this.sourceString != null) {
            xmlProducer = XMLUtils.toXmlProducer(this.sourceString);
        } else {
            XmlParams xmlParams = this.resolveXmlExtractionDef();
            ExtractionSource extractionSource = ExtractionEngineUtils.getExtractionSource(this.dynamicObject, xmlParams.extractParameters.getExtractionContext(), xmlParams.extractionDef, this.staticFiches);
            xmlProducer = new ExtractionXmlProducer(xmlParams.extractParameters, xmlParams.extractionDef, extractionSource, this.extraXml);
        }
        return xmlProducer;
    }

    public StreamProducer getStreamProducer() {
        StreamProducer streamProducer;
        if (this.streamExtension == null) {
            streamProducer = this.getSimpleTemplateProducer(this.getSimpleTemplate());
        } else {
            StreamTemplate streamTemplate = this.getStreamTemplate();
            if (streamTemplate instanceof StreamTemplate.Xslt) {
                streamProducer = this.getXsltStreamTemplateProducer((StreamTemplate.Xslt)streamTemplate);
            } else if (streamTemplate instanceof StreamTemplate.Properties) {
                streamProducer = this.getPropertiesStreamTemplateProducer((StreamTemplate.Properties)streamTemplate);
            } else {
                throw new BadRequestException("_ error.unsupported.unknownimplementation", streamTemplate.getClass().getCanonicalName());
            }
        }
        return streamProducer;
    }

    public static TransformationFactory init(BdfParameters bdfParameters) {
        return new TransformationFactory(bdfParameters);
    }

    private SimpleTemplate getSimpleTemplate() {
        TemplateKey templateKey;
        boolean useDefault;
        if (this.templateName.isEmpty()) {
            useDefault = true;
            templateKey = BdfUserUtils.getSimpleTemplateKey(this.bdfParameters, this.transformationKey);
        } else {
            useDefault = false;
            try {
                templateKey = TemplateKey.parse(this.transformationKey, this.templateName);
            }
            catch (ParseException pe) {
                throw new BadRequestException("_ error.wrong.templatename", this.templateName);
            }
        }
        SimpleTemplate simpleTemplate = this.bdfServer.getTransformationManager().getSimpleTemplate(templateKey, useDefault);
        if (simpleTemplate == null) {
            throw new BadRequestException("_ error.unknown.template", this.templateName);
        }
        return simpleTemplate;
    }

    private StreamTemplate getStreamTemplate() {
        StreamTemplate streamTemplate;
        TemplateKey templateKey;
        boolean useDefault;
        if (this.streamExtension == null) {
            throw new IllegalStateException("streamExtension is null");
        }
        if (this.templateName.isEmpty()) {
            useDefault = true;
            templateKey = BdfUserUtils.getStreamTemplateKey(this.bdfParameters, this.transformationKey, this.streamExtension);
        } else {
            useDefault = false;
            try {
                templateKey = TemplateKey.parse(this.transformationKey, this.streamExtension, this.templateName);
            }
            catch (ParseException pe) {
                throw new BadRequestException("_ error.wrong.templatename", this.templateName);
            }
        }
        TransformationManager transformationManager = this.bdfServer.getTransformationManager();
        try {
            streamTemplate = transformationManager.getStreamTemplate(templateKey, useDefault);
            if (streamTemplate == null) {
                throw new BadRequestException("_ error.unknown.template", this.templateName);
            }
        }
        catch (NoDefaultTemplateException ndte) {
            throw new BadRequestException("_ error.unsupported.defaulttemplate", this.streamExtension.toString(), this.transformationKey.getKeyString());
        }
        return streamTemplate;
    }

    private XmlParams resolveXmlExtractionDef() {
        ExtractionDef resolvedExtractionDef;
        Attributes templateAttributes;
        TemplateKey templateKey;
        boolean userTemplate;
        if (this.templateName.isEmpty()) {
            userTemplate = true;
            templateKey = BdfUserUtils.getSimpleTemplateKey(this.bdfParameters, this.transformationKey);
        } else {
            userTemplate = false;
            try {
                templateKey = TemplateKey.parse(this.transformationKey + "/" + this.templateName);
            }
            catch (ParseException pe) {
                throw new BadRequestException("_ error.wrong.templatename", this.templateName);
            }
        }
        TransformationManager transformationManager = this.bdfServer.getTransformationManager();
        if (templateKey.isSimpleTemplate()) {
            SimpleTemplate simpleTemplate = transformationManager.getSimpleTemplate(templateKey, userTemplate);
            if (simpleTemplate == null) {
                throw new BadRequestException("_ error.unknown.template", this.templateName);
            }
            templateAttributes = simpleTemplate.getAttributes();
            resolvedExtractionDef = simpleTemplate.getCustomExtractionDef();
        } else {
            StreamTemplate streamTemplate;
            try {
                streamTemplate = transformationManager.getStreamTemplate(templateKey, userTemplate);
                if (streamTemplate == null) {
                    throw new BadRequestException("_ error.unknown.template", this.templateName);
                }
            }
            catch (NoDefaultTemplateException ndte) {
                throw new BadRequestException("_ error.unsupported.defaulttemplate", templateKey.getExtension(), this.transformationKey.getKeyString());
            }
            if (!(streamTemplate instanceof StreamTemplate.Xslt)) {
                throw new BadRequestException("_ error.unsupported.noextractiontemplate", this.templateName);
            }
            templateAttributes = ((StreamTemplate.Xslt)streamTemplate).getAttributes();
            resolvedExtractionDef = ((StreamTemplate.Xslt)streamTemplate).getCustomExtractionDef();
        }
        if (resolvedExtractionDef == null && (resolvedExtractionDef = DefaultExtractionDefFactory.newInstance(this.bdfServer, this.transformationKey, templateAttributes)) == null) {
            throw new BadRequestException("_ error.unsupported.defaultextractiondef", this.transformationKey.getKeyString());
        }
        resolvedExtractionDef = ExtractionDefFilterEngine.run(resolvedExtractionDef, this.extractionContext);
        ExtractParameters extractParameters = BdfTransformationUtils.buildExtractParameters(this.extractionContext, templateAttributes, this.bdfParameters, this.fichePredicate);
        return new XmlParams(extractParameters, resolvedExtractionDef);
    }

    private String getExtractionString(Attributes attributes, ExtractionDef customExtractionDef) {
        if (customExtractionDef == null) {
            customExtractionDef = DefaultExtractionDefFactory.newInstance(this.bdfServer, this.transformationKey, attributes);
        }
        customExtractionDef = ExtractionDefFilterEngine.run(customExtractionDef, this.extractionContext);
        ExtractParameters extractParameters = BdfTransformationUtils.buildExtractParameters(this.extractionContext, attributes, this.bdfParameters, this.fichePredicate);
        ExtractionSource extractionSource = ExtractionEngineUtils.getExtractionSource(this.dynamicObject, this.extractionContext, customExtractionDef, this.staticFiches);
        return ExtractionEngine.init(extractParameters, customExtractionDef).extraXml(this.extraXml).run(extractionSource);
    }

    public StreamProducer getSimpleTemplateProducer(SimpleTemplate simpleTemplate) {
        String extractionString = this.sourceString != null ? this.sourceString : this.getExtractionString(simpleTemplate.getAttributes(), simpleTemplate.getCustomExtractionDef());
        TransformerParameters transformerParameters = TransformerParameters.build(this.bdfParameters).check(simpleTemplate.getAttributes()).put("BDF_FICHOTHEQUEPATH", "../").put("EXTERNALTARGET", "_blank");
        return new SimpleTemplateProducer(null, extractionString, simpleTemplate, transformerParameters);
    }

    private StreamProducer getXsltStreamTemplateProducer(StreamTemplate.Xslt xslStreamTemplate) {
        String extractionString = this.sourceString != null ? this.sourceString : this.getExtractionString(xslStreamTemplate.getAttributes(), xslStreamTemplate.getCustomExtractionDef());
        TransformerParameters transformerParameters = TransformerParameters.build(this.bdfParameters).check(xslStreamTemplate.getAttributes());
        return new XsltStreamTemplateProducer(null, extractionString, xslStreamTemplate, transformerParameters, this.outputProperties);
    }

    private StreamProducer getPropertiesStreamTemplateProducer(StreamTemplate.Properties streamTemplate) {
        SumCellConverter cellConverter;
        if (this.dynamicObject == null || !(this.dynamicObject instanceof FicheMeta)) {
            throw new BadRequestException("_ error.unsupported.ficheonlytemplate", new Object[0]);
        }
        String tableExportName = streamTemplate.getTableExportName();
        FicheMeta ficheMeta = (FicheMeta)this.dynamicObject;
        if (tableExportName.isEmpty()) {
            SubsetTable subsetTable = BdfTableExportUtils.toDefaultSubsetTable(this.bdfServer, ficheMeta.getCorpus(), BdfTableExportUtils.ALL_FICHETABLEPARAMETERS, this.bdfParameters.getPermissionSummary());
            cellConverter = BdfTableExportUtils.toCellConverter(this.bdfServer, this.extractionContext, subsetTable);
        } else {
            cellConverter = BdfTableExportUtils.getCellConverterFromName(this.bdfServer, this.extractionContext, tableExportName);
            if (cellConverter == null) {
                throw new BadRequestException("_ error.unknown.tablexport", tableExportName);
            }
        }
        Cell[] cellArray = cellConverter.toCellArray(ficheMeta);
        if (cellArray == null) {
            throw new BadRequestException("_ error.empty.subsettable", tableExportName, ficheMeta.getSubsetKey());
        }
        return new PropertiesStreamTemplateProducer(null, cellArray, streamTemplate);
    }

    private static class XmlParams {
        private final ExtractParameters extractParameters;
        private final ExtractionDef extractionDef;

        private XmlParams(ExtractParameters extractParameters, ExtractionDef extractionDef) {
            this.extractParameters = extractParameters;
            this.extractionDef = extractionDef;
        }
    }
}

