/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.thesaurus;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import net.fichotheque.thesaurus.Thesaurus;
import net.mapeadores.util.attr.AttributeChange;
import net.mapeadores.util.attr.AttributeParser;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class ThesaurusAttributeChangeCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "ThesaurusAttributeChange";
    public static final String COMMANDKEY = "_ THS-19";
    public static final String ATTRIBUTES_PARAMNAME = "attributes";
    private Thesaurus thesaurus;
    private AttributeChange attributeChange;

    public ThesaurusAttributeChangeCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        try (EditSession session = this.startEditSession("thesaurus", COMMANDNAME);){
            session.getFichothequeEditor().changeAttributes(this.thesaurus.getThesaurusMetadata(), this.attributeChange);
        }
        this.putResultObject("obj.thesaurus", this.thesaurus);
        this.setDone("_ done.global.attributechange", new Object[0]);
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.thesaurus = this.requestHandler.getMandatoryThesaurus();
        this.checkSubsetAdmin(this.thesaurus);
        String attributes = this.getMandatory(ATTRIBUTES_PARAMNAME);
        this.attributeChange = AttributeParser.parse(attributes);
    }
}

