/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.sphere;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import java.text.ParseException;
import net.mapeadores.util.attr.Attribute;
import net.mapeadores.util.attr.AttributeBuilder;
import net.mapeadores.util.attr.AttributeKey;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.text.CleanedString;

public class UserPrefChangeCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "UserPrefChange";
    public static final String ATTRIBUTE_PARAMNAME = "attribute";
    public static final String VALUE_PARAMNAME = "value";
    private AttributeKey attributeKey;
    private CleanedString value;

    public UserPrefChangeCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        Attribute newAttribute;
        Attribute currentAttribute = this.bdfUser.getPrefs().getAttributes().getAttribute(this.attributeKey);
        if (currentAttribute == null) {
            newAttribute = AttributeBuilder.toAttribute(this.attributeKey, this.value);
        } else {
            String newValue = this.value.toString();
            String oppositeValue = UserPrefChangeCommand.getOppositeValue(newValue);
            AttributeBuilder attributeBuilder = new AttributeBuilder(this.attributeKey);
            boolean here = false;
            for (String currentValue : currentAttribute) {
                if (currentValue.equals(oppositeValue)) continue;
                if (currentValue.equals(newValue)) {
                    here = true;
                }
                attributeBuilder.addValue(currentValue);
            }
            if (!here) {
                attributeBuilder.addValue(this.value);
            }
            newAttribute = attributeBuilder.toAttribute();
        }
        try (EditSession session = this.startEditSession("sphere", COMMANDNAME);){
            session.getBdfServerEditor().getBdfUserPrefsEditor(this.bdfUser.getPrefs()).putAttribute(newAttribute);
        }
        this.setDone("_ done.sphere.userprefchange", new Object[0]);
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        String attributeString = this.getMandatory(ATTRIBUTE_PARAMNAME);
        this.value = CleanedString.newInstance(this.getMandatory(VALUE_PARAMNAME));
        try {
            this.attributeKey = AttributeKey.parse(attributeString);
        }
        catch (ParseException pe) {
            throw BdfErrors.wrongParameterValue(ATTRIBUTE_PARAMNAME, attributeString);
        }
        if (this.value == null) {
            throw BdfErrors.emptyMandatoryParameter(VALUE_PARAMNAME);
        }
    }

    private static String getOppositeValue(String newValue) {
        if (newValue.startsWith("!")) {
            return newValue.substring(1);
        }
        return "!" + newValue;
    }
}

