/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.selection;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.managers.SelectionManager;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import net.fichotheque.selection.FicheQuery;
import net.fichotheque.selection.SelectionDef;
import net.fichotheque.tools.selection.SelectionDefBuilder;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.text.StringUtils;

public class SelectionDefCreationCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "SelectionDefCreation";
    public static final String COMMANDKEY = "_ EXP-01";
    public static final String NEWSELECTION_PARAMNAME = "newselection";
    public static final String FILL_PARAMNAME = "fill";
    public static final String CURRENT_PARAMVALUE = "current";
    private String newSelectionName;
    private boolean fillWithCurrent;

    public SelectionDefCreationCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() {
        SelectionManager selectionManager = this.bdfServer.getSelectionManager();
        SelectionDefBuilder selectionDefBuilder = SelectionDefBuilder.init(this.newSelectionName);
        if (this.fillWithCurrent) {
            FicheQuery ficheQuery = this.bdfUser.getFicheQuery();
            selectionDefBuilder.getFichothequeQueriesBuilder().addFicheQuery(ficheQuery);
        }
        SelectionDef selectionDef = selectionDefBuilder.toSelectionDef();
        selectionManager.putSelectionDef(selectionDef);
        this.putResultObject("obj.selectiondef", selectionDef);
        this.setDone("_ done.selection.selectiondefcreation", this.newSelectionName);
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.checkFichothequeAdmin();
        this.newSelectionName = this.getMandatory(NEWSELECTION_PARAMNAME).trim();
        if (this.newSelectionName.isEmpty()) {
            throw BdfErrors.error("_ error.empty.selectionname");
        }
        SelectionDef selectionDef = this.bdfServer.getSelectionManager().getSelectionDef(this.newSelectionName);
        if (selectionDef != null) {
            throw BdfErrors.error("_ error.existing.selection", this.newSelectionName);
        }
        if (!StringUtils.isTechnicalName(this.newSelectionName, true)) {
            throw BdfErrors.error("_ error.wrong.selectionname", this.newSelectionName);
        }
        String fillParam = this.requestHandler.getTrimedParameter(FILL_PARAMNAME);
        if (fillParam.equals(CURRENT_PARAMVALUE)) {
            this.fillWithCurrent = true;
        }
    }
}

