/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.mailing;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.users.BdfUser;
import fr.exemole.bdfserver.email.EmailBuffer;
import fr.exemole.bdfserver.email.FicheAttachmentParameters;
import fr.exemole.bdfserver.email.SendEngine;
import fr.exemole.bdfserver.email.SendReport;
import fr.exemole.bdfserver.email.SmtpManager;
import fr.exemole.bdfserver.email.TableExportEmail;
import fr.exemole.bdfserver.tools.exportation.table.TableExportParametersBuilder;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import fr.exemole.bdfserver.tools.instruction.RequestHandler;
import fr.exemole.bdfserver.tools.users.BdfUserUtils;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import net.fichotheque.addenda.Version;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.Fiches;
import net.fichotheque.exportation.transformation.TransformationKey;
import net.fichotheque.sphere.Redacteur;
import net.fichotheque.utils.CorpusMetadataUtils;
import net.mapeadores.util.exceptions.SwitchException;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.text.StringUtils;
import net.mapeadores.util.text.ValidExtension;

public class SendCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "Send";
    public static final String SELFBCC_PARAMNAME = "selfbcc";
    public static final String TYPE_PARAMNAME = "type";
    public static final String SUBJECT_PARAMNAME = "subject";
    public static final String TO_PARAMNAME = "to";
    public static final String CC_PARAMNAME = "cc";
    public static final String BCC_PARAMNAME = "bcc";
    public static final String MESSAGE_PARAMNAME = "message";
    public static final String DOCUMENTVERSION_PARAMNAME = "documentversion";
    public static final String FICHEVERSION_PARAMNAME = "ficheversion";
    public static final String HTML_FICHEVERSION_PARAMVALUE = "html";
    public static final String ODT_FICHEVERSION_PARAMVALUE = "odt";
    public static final String HTMLTEMPLATE_PARAMNAME = "htmltemplate";
    public static final String ODTTEMPLATE_PARAMNAME = "odttemplate";
    public static final String EXTENSION_PARAMNAME = "extension";
    private SmtpManager smtpManager;
    private EmailBuffer emailBuffer;

    public SendCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return false;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        if (this.emailBuffer.hasWrongAddresses()) {
            throw BdfErrors.error("_ error.wrong.addresslist");
        }
        SendEngine sendEngine = new SendEngine(this.smtpManager, this);
        SendReport sendReport = sendEngine.sendEmail(this.emailBuffer);
        this.putResultObject("obj.sendreport", sendReport);
        switch (sendReport.getState()) {
            case 1: {
                this.setDone(this.getDoneMessageKey(), new Object[0]);
                break;
            }
            case -1: {
                throw BdfErrors.error("_ error.exception.sendreport_emailbuild", sendReport.getErrorMessage());
            }
            case -2: {
                throw BdfErrors.error("_ error.exception.sendreport_error", sendReport.getErrorMessage());
            }
        }
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.smtpManager = SendCommand.testSmtpManager(this.bdfServer);
        this.emailBuffer = SendCommand.buildFromRequest(this.requestHandler, false);
        if (this.emailBuffer.getSubject() == null) {
            throw BdfErrors.error("_ error.empty.subject");
        }
        if (this.emailBuffer.getMessage() == null) {
            throw BdfErrors.error("_ error.empty.message");
        }
        if (this.emailBuffer.isWithoutField(TO_PARAMNAME)) {
            throw BdfErrors.error("_ error.empty.to");
        }
        this.putResultObject("obj.emailbuffer", this.emailBuffer);
    }

    private String getDoneMessageKey() {
        switch (this.emailBuffer.getSendType()) {
            case "fiche": {
                return "_ done.mailing.send_fiche";
            }
            case "compilation": {
                return "_ done.mailing.send_compilation";
            }
            case "selection": {
                return "_ done.mailing.send_selection";
            }
            case "tableexport": {
                return "_ done.mailing.send_tableexport";
            }
        }
        throw new SwitchException("Unknown sendType: " + this.emailBuffer.getSendType());
    }

    public static EmailBuffer buildFromRequest(RequestHandler requestHandler, boolean withDefaultValue) throws ErrorMessageException {
        EmailBuffer eb;
        String sendType;
        Redacteur redacteur = requestHandler.getBdfUser().getRedacteur();
        switch (sendType = requestHandler.getMandatoryParameter(TYPE_PARAMNAME)) {
            case "fiche": {
                eb = SendCommand.initFiche(requestHandler, withDefaultValue);
                break;
            }
            case "compilation": {
                eb = EmailBuffer.buildForCompilation(requestHandler.getBdfServer(), requestHandler.getBdfUser());
                eb.setFicheAttachmentParameters(SendCommand.initFicheAttachmentParameters(requestHandler, withDefaultValue, TransformationKey.COMPILATION_INSTANCE));
                break;
            }
            case "selection": {
                eb = SendCommand.initSelection(requestHandler, withDefaultValue);
                break;
            }
            case "tableexport": {
                TableExportInitializer tableExportInitializer = new TableExportInitializer(requestHandler, withDefaultValue);
                eb = tableExportInitializer.init();
                break;
            }
            default: {
                throw BdfErrors.unknownParameterValue(TYPE_PARAMNAME, sendType);
            }
        }
        SendCommand.parseAddresses(requestHandler, redacteur, eb, TO_PARAMNAME, TO_PARAMNAME);
        SendCommand.parseAddresses(requestHandler, redacteur, eb, CC_PARAMNAME, CC_PARAMNAME);
        SendCommand.parseAddresses(requestHandler, redacteur, eb, BCC_PARAMNAME, BCC_PARAMNAME);
        eb.setSubject(requestHandler.getTrimedParameter(SUBJECT_PARAMNAME));
        boolean withBcc = withDefaultValue ? true : requestHandler.isTrue(SELFBCC_PARAMNAME);
        eb.setWithRedacteurBcc(withBcc);
        eb.setMessage(requestHandler.getTrimedParameter(MESSAGE_PARAMNAME));
        return eb;
    }

    private static void parseAddresses(RequestHandler requestHandler, Redacteur redacteur, EmailBuffer eb, String fieldName, String paramName) throws ErrorMessageException {
        String[] values = requestHandler.getTokens(paramName);
        if (values.length > 0) {
            ArrayList<String> valueList = new ArrayList<String>();
            for (String toValue : values) {
                String[] tokens;
                for (String token : tokens = StringUtils.getTechnicalTokens(toValue, false)) {
                    valueList.add(token);
                }
            }
            int size = valueList.size();
            if (size > 0) {
                eb.parseToArray(requestHandler.getBdfServer().getFichothequeQuestioner(), fieldName, valueList, redacteur.getSubsetKey());
            }
        }
    }

    private static EmailBuffer initFiche(RequestHandler requestHandler, boolean withDefaultValue) throws ErrorMessageException {
        FicheMeta ficheMeta = requestHandler.getMandatoryFicheMeta();
        requestHandler.checkRead(ficheMeta);
        BdfServer bdfServer = requestHandler.getBdfServer();
        BdfUser bdfUser = requestHandler.getBdfUser();
        EmailBuffer eb = EmailBuffer.buildForFiche(bdfServer, bdfUser, ficheMeta);
        if (withDefaultValue && eb.getSubject() == null) {
            eb.setSubject(CorpusMetadataUtils.getFicheTitle(ficheMeta, bdfUser.getWorkingLang(), bdfUser.getFormatLocale()));
        }
        eb.setFicheAttachmentParameters(SendCommand.initFicheAttachmentParameters(requestHandler, withDefaultValue, new TransformationKey(ficheMeta.getSubsetKey())));
        return eb;
    }

    private static EmailBuffer initSelection(RequestHandler requestHandler, boolean withDefaultValue) throws ErrorMessageException {
        LinkedHashSet<FicheMeta> ficheMetaSet = new LinkedHashSet<FicheMeta>();
        for (Corpus corpus : requestHandler.getFichotheque().getCorpusList()) {
            String[] param_selection;
            for (String token : param_selection = requestHandler.getTokens("selection_" + corpus.getSubsetName())) {
                try {
                    int id = Integer.parseInt(token);
                    FicheMeta ficheMeta = corpus.getFicheMetaById(id);
                    if (ficheMeta == null) continue;
                    ficheMetaSet.add(ficheMeta);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        BdfServer bdfServer = requestHandler.getBdfServer();
        BdfUser bdfUser = requestHandler.getBdfUser();
        EmailBuffer eb = EmailBuffer.buildForSelection(bdfServer, bdfUser, ficheMetaSet);
        Fiches selectedFiches = bdfUser.getSelectedFiches();
        TransformationKey transformationKey = selectedFiches.getEntryList().size() == 1 ? new TransformationKey(selectedFiches.getEntryList().get(0).getCorpus().getSubsetKey()) : null;
        eb.setFicheAttachmentParameters(SendCommand.initFicheAttachmentParameters(requestHandler, withDefaultValue, transformationKey));
        return eb;
    }

    private static FicheAttachmentParameters initFicheAttachmentParameters(RequestHandler requestHandler, boolean withDefaultValue, TransformationKey transformationKey) throws ErrorMessageException {
        String[] versionArray;
        FicheAttachmentParameters ficheAttachmentParameters = new FicheAttachmentParameters();
        String[] values = requestHandler.getTokens(FICHEVERSION_PARAMNAME);
        if (values.length > 0) {
            for (String value : values) {
                if (value.equals(HTML_FICHEVERSION_PARAMVALUE)) {
                    ficheAttachmentParameters.setWithHtml(true).setHtmlTemplateName(requestHandler.getTrimedParameter(HTMLTEMPLATE_PARAMNAME, true));
                    continue;
                }
                if (!value.equals(ODT_FICHEVERSION_PARAMVALUE)) continue;
                ficheAttachmentParameters.setWithOdt(true).setOdtTemplateName(requestHandler.getParameter(ODTTEMPLATE_PARAMNAME, true));
            }
        } else if (withDefaultValue) {
            ficheAttachmentParameters.setWithHtml(true);
            if (transformationKey != null) {
                ficheAttachmentParameters.setHtmlTemplateName(BdfUserUtils.getSimpleTemplateKey(requestHandler, transformationKey).getName()).setOdtTemplateName(BdfUserUtils.getStreamTemplateKey(requestHandler, transformationKey, ValidExtension.ODT).getName());
            }
        }
        for (String versionKey : versionArray = requestHandler.getTokens(DOCUMENTVERSION_PARAMNAME)) {
            try {
                Version version = requestHandler.getBdfServer().getFichothequeQuestioner().parseVersionKey(versionKey);
                ficheAttachmentParameters.addVersion(version);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return ficheAttachmentParameters;
    }

    public static SmtpManager testSmtpManager(BdfServer bdfServer) throws ErrorMessageException {
        SmtpManager smtpManager = (SmtpManager)bdfServer.getContextObject("smtpManager");
        if (!smtpManager.isInit()) {
            StringBuilder buf = new StringBuilder();
            buf.append("Smtp parameters are not initialized ");
            for (String error : smtpManager.getErrorList()) {
                buf.append(" / ");
                buf.append(error);
            }
            buf.append(")");
            throw BdfErrors.internalError(buf.toString());
        }
        return smtpManager;
    }

    private static class TableExportInitializer {
        private final boolean withDefaultValue;
        private final RequestHandler requestHandler;
        private final TableExportParametersBuilder builder;
        private final String tableExportName;
        private final String storeName;

        private TableExportInitializer(RequestHandler requestHandler, boolean withDefaultValue) {
            requestHandler = RequestHandler.cloneHandler(requestHandler);
            this.withDefaultValue = withDefaultValue;
            this.tableExportName = requestHandler.getTrimedParameter("tableexport");
            this.builder = TableExportParametersBuilder.init().setTableExportName(this.tableExportName);
            this.storeName = this.tableExportName == null ? "send_tableexport" : "send_tableexport_" + this.tableExportName;
            if (withDefaultValue) {
                requestHandler.setDefaultMap(requestHandler.getStoredValues(this.storeName));
            }
            this.requestHandler = requestHandler;
        }

        private EmailBuffer init() throws ErrorMessageException {
            Corpus corpus = this.requestHandler.getMandatoryCorpus();
            if (!this.requestHandler.getPermissionSummary().hasAccess(corpus)) {
                throw BdfErrors.wrongParameterValue("corpus", corpus.getSubsetName());
            }
            if (!this.withDefaultValue) {
                this.requestHandler.enableStore();
            }
            this.initTableParameters();
            this.initHeaderType();
            String charset = this.initCharset();
            String extension = this.initExtension();
            if (!this.withDefaultValue) {
                this.requestHandler.store(this.storeName);
            }
            return EmailBuffer.buildForTableExport(this.requestHandler.getBdfServer(), this.requestHandler.getBdfUser(), new TableExportEmail(this.builder.toTableExportParameters(), corpus, extension, charset));
        }

        private String initCharset() throws ErrorMessageException {
            String charset = this.requestHandler.getTrimedParameter("charset", "UTF-8");
            return charset;
        }

        private String initExtension() throws ErrorMessageException {
            String extension;
            switch (extension = this.requestHandler.getTrimedParameter(SendCommand.EXTENSION_PARAMNAME, "csv")) {
                case "csv": 
                case "ods": {
                    break;
                }
                default: {
                    throw BdfErrors.unknownParameterValue(SendCommand.EXTENSION_PARAMNAME, extension);
                }
            }
            return extension;
        }

        private void initTableParameters() throws ErrorMessageException {
            if (this.tableExportName == null) {
                this.builder.setFicheTableParameters(this.requestHandler.getFicheTableParameters());
            }
        }

        private void initHeaderType() throws ErrorMessageException {
            this.builder.setHeaderType(this.requestHandler.getHeaderType());
        }
    }
}

