/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.importation;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.commands.importation.AbstractImportParseCommand;
import fr.exemole.bdfserver.tools.importation.ImportationFileUtils;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import java.io.File;
import java.io.IOException;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.tools.importation.ParseResultBuilder;
import net.fichotheque.tools.importation.parsers.ImportationParseContext;
import net.fichotheque.tools.importation.parsers.Row;
import net.fichotheque.tools.importation.parsers.thesaurus.ThesaurusRowParser;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class ThesaurusImportParseCommand
extends AbstractImportParseCommand {
    public static final String COMMANDNAME = "ThesaurusImportParse";
    public static final String COMMANDKEY = "_ IMP-02";
    public static final String TYPE_PARAMNAME = "type";
    public static final String DESTINATIONTHESAURUS_PARAMNAME = "destinationthesaurus";
    private String parseType;
    private Thesaurus thesaurus;
    private Thesaurus destinationThesaurus;

    public ThesaurusImportParseCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return false;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        ParseResultBuilder parseResultBuilder = new ParseResultBuilder("thesaurusimport");
        ImportationParseContext parseContext = ImportationParseContext.init(this.bdfServer.getFichothequeQuestioner(), this.bdfServer.getThesaurusLangChecker(), this.bdfUser.getWorkingLang());
        ThesaurusRowParser rowParser = ThesaurusRowParser.newInstance(this.fieldsArray, this.parseType, this.thesaurus, this.destinationThesaurus, parseResultBuilder, parseContext);
        if (rowParser != null) {
            for (int i = 0; i < this.lines.length; ++i) {
                String[] line = this.lines[i];
                if (line.length == 0) continue;
                rowParser.parseRow(i + 1, new Row(line));
            }
            try {
                File tmpFile = ImportationFileUtils.saveTmpXml(this.bdfServer, rowParser.getThesaurusImportBuilder().toThesaurusImport());
                parseResultBuilder.setPath(tmpFile.getName());
            }
            catch (IOException ioe) {
                throw BdfErrors.ioException(ioe);
            }
        }
        this.putResultObject("obj.parseresult", parseResultBuilder.toParseResult());
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.checkFichothequeAdmin();
        this.requestHandler.enableStore();
        String typeParam = this.getMandatory(TYPE_PARAMNAME);
        try {
            typeParam = ThesaurusRowParser.checkParseType(typeParam);
        }
        catch (IllegalArgumentException iae) {
            throw BdfErrors.wrongParameterValue(TYPE_PARAMNAME, typeParam);
        }
        this.parseType = typeParam;
        this.thesaurus = this.requestHandler.getMandatoryThesaurus();
        switch (typeParam) {
            case "move": 
            case "merge": {
                this.destinationThesaurus = (Thesaurus)this.requestHandler.getMandatorySubset((short)2, DESTINATIONTHESAURUS_PARAMNAME);
            }
        }
        this.checkLines();
        this.requestHandler.store("form_import_thesaurus");
    }
}

