/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.exportation;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.tools.exportation.transformation.ConvertToOdtEngine;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import java.io.IOException;
import net.fichotheque.EditOrigin;
import net.fichotheque.exportation.transformation.TemplateDescription;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class TemplateConvertToOdtCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "TemplateConvertToOdt";
    public static final String COMMANDKEY = "_ EXP-38";
    private ConvertToOdtEngine engine;

    public TemplateConvertToOdtCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        EditOrigin editOrigin = this.bdfUser.newEditOrigin("exportation", COMMANDNAME);
        try {
            TemplateDescription templateDescription = this.engine.run(editOrigin);
            this.putResultObject("obj.templatedescription", templateDescription);
            this.setDone("_ done.exportation.templateconverttoodt", templateDescription.getTemplateKey().getKeyString());
        }
        catch (IOException ioe) {
            throw BdfErrors.error("_ error.exception.templatecontent_io", ioe.getMessage());
        }
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.checkFichothequeAdmin();
        TemplateDescription originTemplateDescription = this.requestHandler.getMandatoryTemplateDescription();
        this.engine = ConvertToOdtEngine.build(this.bdfServer, originTemplateDescription);
    }
}

