/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.corpus;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import java.text.ParseException;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.corpus.metadata.CorpusMetadata;
import net.fichotheque.corpus.metadata.CorpusMetadataEditor;
import net.fichotheque.corpus.metadata.ExistingFieldKeyException;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.corpus.metadata.FieldOptionException;
import net.mapeadores.util.exceptions.ShouldNotOccurException;
import net.mapeadores.util.exceptions.SwitchException;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.text.Label;
import net.mapeadores.util.text.LabelChange;

public class FieldCreationCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "FieldCreation";
    public static final String PROP_COMMANDKEY = "_ CRP-04";
    public static final String INFO_COMMANDKEY = "_ CRP-05";
    public static final String SECTION_COMMANDKEY = "_ CRP-06";
    public static final String CATEGORY_PARAMNAME = "category";
    public static final String NEWFIELDNAME_PARAMNAME = "newfieldname";
    public static final String FICHEITEMTYPE_PARAMNAME = "ficheitemtype";
    public static final String NEWLABEL_PARAMPREFIX = "newlabel/";
    private Corpus corpus;
    private FieldKey newFieldKey;
    private String ficheItemType = "";
    private LabelChange fieldLabelChange;

    public FieldCreationCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() {
        try (EditSession session = this.startEditSession("corpus", COMMANDNAME);){
            CorpusField corpusField;
            CorpusMetadataEditor corpusMetadataEditor = session.getFichothequeEditor().getCorpusEditor(this.corpus).getCorpusMetadataEditor();
            try {
                corpusField = corpusMetadataEditor.createCorpusField(this.newFieldKey, this.ficheItemType);
                this.setDefaultOptions(corpusMetadataEditor, corpusField);
            }
            catch (ExistingFieldKeyException efke) {
                throw new ShouldNotOccurException("test done before");
            }
            if (!this.fieldLabelChange.isEmpty()) {
                for (Label label : this.fieldLabelChange.getChangedLabels()) {
                    corpusMetadataEditor.putFieldLabel(corpusField, label);
                }
            }
        }
        this.putResultObject("obj.corpus", this.corpus);
        this.setDone("_ done.corpus.fieldcreation", this.newFieldKey.getKeyString());
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.corpus = this.requestHandler.getMandatoryCorpus();
        this.checkSubsetAdmin(this.corpus);
        short category = this.checkCategory();
        String fieldNameParameter = this.getMandatory(NEWFIELDNAME_PARAMNAME);
        fieldNameParameter = fieldNameParameter.trim();
        if (fieldNameParameter.length() == 0) {
            throw BdfErrors.error("_ error.empty.fieldkey");
        }
        CorpusMetadata corpusMetadata = this.corpus.getCorpusMetadata();
        try {
            this.newFieldKey = FieldKey.parse(category, fieldNameParameter);
        }
        catch (ParseException pe) {
            throw BdfErrors.error("_ error.wrong.fieldkey", fieldNameParameter);
        }
        if (corpusMetadata.getCorpusField(this.newFieldKey) != null) {
            throw BdfErrors.error("_ error.existing.fieldkey", this.newFieldKey.getKeyString());
        }
        if (FieldCreationCommand.isWithTypeSelect(category)) {
            String ficheItemTypeParameter = this.getMandatory(FICHEITEMTYPE_PARAMNAME);
            if (ficheItemTypeParameter.length() == 0) {
                throw BdfErrors.error("_ error.empty.ficheitemtype", fieldNameParameter);
            }
            try {
                this.ficheItemType = CorpusField.checkFicheItemType(ficheItemTypeParameter);
            }
            catch (IllegalArgumentException iae) {
                throw BdfErrors.unknownParameterValue(FICHEITEMTYPE_PARAMNAME, ficheItemTypeParameter);
            }
        }
        this.fieldLabelChange = this.requestHandler.getLabelChange(NEWLABEL_PARAMPREFIX);
    }

    private short checkCategory() throws ErrorMessageException {
        short category;
        String categoryParameter = this.getMandatory(CATEGORY_PARAMNAME);
        try {
            category = FieldKey.categoryToShort(categoryParameter);
        }
        catch (IllegalArgumentException iae) {
            throw BdfErrors.unknownParameterValue(CATEGORY_PARAMNAME, categoryParameter);
        }
        switch (category) {
            case 0: {
                throw BdfErrors.unsupportedParameterValue(CATEGORY_PARAMNAME, categoryParameter);
            }
        }
        return category;
    }

    public static String getCommandKey(short category) {
        switch (category) {
            case 1: {
                return PROP_COMMANDKEY;
            }
            case 2: {
                return INFO_COMMANDKEY;
            }
            case 3: {
                return SECTION_COMMANDKEY;
            }
        }
        throw new SwitchException("category = " + category);
    }

    public static boolean isWithTypeSelect(short category) {
        switch (category) {
            case 1: 
            case 2: {
                return true;
            }
        }
        return false;
    }

    private void setDefaultOptions(CorpusMetadataEditor corpusMetadataEditor, CorpusField corpusField) {
        if (corpusField.isProp()) {
            switch (corpusField.getFicheItemType()) {
                case "person": 
                case "geopoint": {
                    try {
                        corpusMetadataEditor.setFieldOption(corpusField, "subfieldDisplay", "1");
                        break;
                    }
                    catch (FieldOptionException foe) {
                        throw new ShouldNotOccurException(foe);
                    }
                }
            }
        } else if (corpusField.isInfo()) {
            switch (corpusField.getFicheItemType()) {
                case "amount": 
                case "para": {
                    try {
                        corpusMetadataEditor.setFieldOption(corpusField, "infoDisplay", "block");
                        break;
                    }
                    catch (FieldOptionException foe) {
                        throw new ShouldNotOccurException(foe);
                    }
                }
            }
        }
    }
}

