/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.corpus;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import java.util.ArrayList;
import java.util.List;
import net.fichotheque.EditOrigin;
import net.fichotheque.ExistingIdException;
import net.fichotheque.FichothequeEditor;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.CorpusEditor;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.NoMasterIdException;
import net.fichotheque.corpus.fiche.FicheAPI;
import net.fichotheque.history.FicheHistory;
import net.fichotheque.history.HistoryUnit;
import net.fichotheque.history.JunctionHistory;
import net.fichotheque.junction.JunctionChange;
import net.fichotheque.junction.JunctionEditor;
import net.fichotheque.junction.JunctionKey;
import net.fichotheque.junction.JunctionRevision;
import net.fichotheque.junction.Tie;
import net.fichotheque.utils.JunctionUtils;
import net.mapeadores.util.exceptions.ImplementationException;
import net.mapeadores.util.exceptions.ShouldNotOccurException;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.primitives.FuzzyDate;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.text.StringUtils;

public class FicheRestoreCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "FicheRestore";
    private Corpus corpus;
    private int id;
    private FicheHistory ficheHistory;
    private HistoryUnit.Revision lastRevision;
    private String isoTime;

    public FicheRestoreCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        FicheMeta ficheMeta;
        FicheAPI fiche = this.corpus.getFicheRevision(this.id, this.lastRevision.getName());
        List<JunctionBySubset> list = this.checkJunctions();
        try (EditSession session = this.startEditSession("corpus", COMMANDNAME);){
            FichothequeEditor fichothequeEditor = session.getFichothequeEditor();
            CorpusEditor corpusEditor = fichothequeEditor.getCorpusEditor(this.corpus);
            JunctionEditor junctionEditor = fichothequeEditor.getJunctionEditor();
            try {
                ficheMeta = corpusEditor.createFiche(this.id);
            }
            catch (ExistingIdException eii) {
                throw new ImplementationException(eii);
            }
            catch (NoMasterIdException nmie) {
                throw new ShouldNotOccurException(nmie);
            }
            corpusEditor.setDate(ficheMeta, FuzzyDate.current(), true);
            corpusEditor.saveFiche(ficheMeta, fiche);
            for (JunctionBySubset croisemetBySubset : list) {
                croisemetBySubset.restoreJunctions(ficheMeta, junctionEditor);
            }
        }
        this.putResultObject("obj.corpus", this.corpus);
        this.putResultObject("obj.fichemeta", ficheMeta);
        this.setDone("_ done.corpus.ficheretrieve", new Object[0]);
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.corpus = this.requestHandler.getMandatoryCorpus();
        this.checkSubsetAdmin(this.corpus);
        this.id = this.requestHandler.getMandatoryId();
        if (this.corpus.getFicheMetaById(this.id) != null) {
            throw BdfErrors.error("_ error.existing.id", this.id);
        }
        this.ficheHistory = this.corpus.getFicheHistory(this.id);
        if (this.ficheHistory == null) {
            throw BdfErrors.error("_ error.unknown.history", this.id);
        }
        if (this.ficheHistory.getFicheUnit().isEmpty()) {
            throw BdfErrors.error("_ error.empty.history", this.id);
        }
        this.lastRevision = this.ficheHistory.getFicheUnit().getMostRecentRevision();
        this.isoTime = this.lastRevision.getEditOriginList().get(0).getISOTime();
    }

    private List<JunctionBySubset> checkJunctions() {
        ArrayList<JunctionBySubset> result = new ArrayList<JunctionBySubset>();
        for (Subset subset : this.fichotheque.getThesaurusList()) {
            this.addJunctionBySubset(result, subset);
        }
        for (Subset subset : this.fichotheque.getCorpusList()) {
            this.addJunctionBySubset(result, subset);
        }
        return result;
    }

    private void addJunctionBySubset(List<JunctionBySubset> list, Subset subset) {
        JunctionBySubset jbs = new JunctionBySubset(subset);
        List<JunctionHistory> junctionHistoryList = this.corpus.getJunctionHistoryList(this.id, subset.getSubsetKey());
        for (JunctionHistory junctionHistory : junctionHistoryList) {
            EditOrigin editOrigin;
            HistoryUnit junctionUnit = junctionHistory.getJunctionUnit();
            if (junctionUnit.isEmpty() || !(editOrigin = junctionUnit.getMostRecentEditOrigin()).getISOTime().equals(this.isoTime)) continue;
            jbs.add(junctionHistory.getJunctionKey(), junctionUnit.getMostRecentRevision().getName());
        }
        if (!jbs.isEmpty()) {
            list.add(jbs);
        }
    }

    private class JunctionBySubset {
        private final Subset subset;
        private final List<Couple> coupleList = new ArrayList<Couple>();

        private JunctionBySubset(Subset subset) {
            this.subset = subset;
        }

        private boolean isEmpty() {
            return this.coupleList.isEmpty();
        }

        private void add(JunctionKey junctionKey, String versionName) {
            this.coupleList.add(new Couple(junctionKey, versionName));
        }

        private void restoreJunctions(FicheMeta ficheMeta, JunctionEditor junctionEditor) {
            for (Couple couple : this.coupleList) {
                JunctionRevision JunctionRevision2;
                JunctionKey junctionKey = couple.junctionKey;
                String versionName = couple.versionName;
                SubsetItem otherSubsetItem = JunctionUtils.getOther(ficheMeta, junctionKey, this.subset);
                if (otherSubsetItem == null || (JunctionRevision2 = FicheRestoreCommand.this.fichotheque.getJunctionRevision(junctionKey, versionName)) == null) continue;
                junctionEditor.updateJunction(ficheMeta, otherSubsetItem, new RestoreJunctionChange(JunctionRevision2));
            }
        }
    }

    private static class RestoreJunctionChange
    implements JunctionChange {
        private final JunctionRevision junctionRevision;

        private RestoreJunctionChange(JunctionRevision junctionRevision) {
            this.junctionRevision = junctionRevision;
        }

        @Override
        public List<String> getRemovedModeList() {
            return StringUtils.EMPTY_STRINGLIST;
        }

        @Override
        public List<Tie> getChangedTieList() {
            return this.junctionRevision.geTieList();
        }
    }

    private static class Couple {
        private final JunctionKey junctionKey;
        private final String versionName;

        private Couple(JunctionKey junctionKey, String versionName) {
            this.junctionKey = junctionKey;
            this.versionName = versionName;
        }
    }
}

