/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.administration;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import fr.exemole.bdfserver.tools.storage.StorageUtils;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import net.fichotheque.EditOrigin;
import net.mapeadores.util.io.IOUtils;
import net.mapeadores.util.io.ResourceUtils;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.text.RelativePath;

public class StreamTextChangeCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "StreamTextChange";
    public static final String PATH_PARAMNAME = "path";
    public static final String CONTENT_PARAMNAME = "content";
    private RelativePath relativePath;
    private String text;

    public StreamTextChangeCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        EditOrigin editOrigin = this.bdfUser.newEditOrigin("administration", COMMANDNAME);
        try (InputStream is = IOUtils.toInputStream(this.text, "UTF-8");){
            StorageUtils.saveResource(this.bdfServer, this.relativePath, is, editOrigin);
        }
        catch (IOException ioe) {
            throw BdfErrors.error("_ error.exception.streamtext_io", ioe.getMessage());
        }
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.checkFichothequeAdmin();
        String path = this.getMandatory(PATH_PARAMNAME);
        try {
            this.relativePath = RelativePath.parse(path);
        }
        catch (ParseException pe) {
            throw BdfErrors.error("_ error.wrong.resourcepath", path);
        }
        if (!ResourceUtils.isValidResourceRelativePath(this.relativePath)) {
            throw BdfErrors.error("_ error.wrong.resourcepath", path);
        }
        this.text = this.getMandatory(CONTENT_PARAMNAME);
    }
}

