/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe.tools.analytique;

import fr.exemole.bdfext.scarabe.api.analytique.AgregatDef;
import fr.exemole.bdfext.scarabe.api.analytique.AnalytiqueDef;
import fr.exemole.bdfext.scarabe.api.analytique.AnalytiqueGathering;
import fr.exemole.bdfext.scarabe.api.analytique.GroupbyDef;
import fr.exemole.bdfext.scarabe.api.analytique.OperationDef;
import fr.exemole.bdfext.scarabe.api.core.Avenir;
import fr.exemole.bdfext.scarabe.api.core.Ligne;
import fr.exemole.bdfext.scarabe.api.core.LigneHolder;
import fr.exemole.bdfext.scarabe.api.core.LigneKey;
import fr.exemole.bdfext.scarabe.tools.analytique.AnalytiqueGatheringBuilder;
import fr.exemole.bdfext.scarabe.tools.analytique.AnalytiqueItemBuilder;
import fr.exemole.bdfext.scarabe.tools.analytique.AnalytiqueUtils;
import fr.exemole.bdfext.scarabe.tools.analytique.GroupbyKey;
import fr.exemole.bdfext.scarabe.tools.analytique.PopulateEngine;
import fr.exemole.bdfext.scarabe.tools.analytique.recap.AgregatGatheringBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import net.fichotheque.Fichotheque;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.alias.AliasHolder;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.croisement.Croisements;
import net.fichotheque.croisement.Liaison;
import net.fichotheque.include.IncludeKey;
import net.fichotheque.include.IncludeMode;
import net.fichotheque.pointeurs.SubsetItemPointeur;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.utils.CroisementUtils;
import net.fichotheque.utils.ThesaurusUtils;
import net.fichotheque.utils.pointeurs.PointeurFactory;
import net.mapeadores.util.money.Currencies;

public class GroupbyEngine
extends PopulateEngine {
    private final AnalytiqueDef analytiqueDef;
    private final ThesaurusInfo[] thesaurusInfoArray;
    private final IncludeKey lastGroupbyIncludeKey;
    private final JunctionInfo[] junctionInfoArray;
    private final int operationDefLength;

    private GroupbyEngine(AnalytiqueDef analytiqueDef, AliasHolder coreAliasHolder, LigneHolder ligneHolder, Currencies currencies, ThesaurusInfo[] thesaurusInfoArray, JunctionInfo[] junctionInfoArray) {
        super(coreAliasHolder, ligneHolder, currencies);
        this.analytiqueDef = analytiqueDef;
        this.thesaurusInfoArray = thesaurusInfoArray;
        this.lastGroupbyIncludeKey = thesaurusInfoArray[thesaurusInfoArray.length - 1].includeKey;
        this.junctionInfoArray = junctionInfoArray;
        this.operationDefLength = analytiqueDef.getOperationDefList().size();
    }

    public static GroupbyEngine newInstance(AnalytiqueDef analytiqueDef, AliasHolder coreAliasHolder, LigneHolder ligneHolder, Currencies currencies) {
        GroupbyDef groupbyDef = analytiqueDef.getGroupbyDef();
        if (groupbyDef == null) {
            return null;
        }
        List<IncludeKey> byList = groupbyDef.getByList();
        if (byList.isEmpty()) {
            return null;
        }
        Fichotheque fichotheque = coreAliasHolder.getCorpus("depense").getFichotheque();
        ArrayList<ThesaurusInfo> thesaurusInfoList = new ArrayList<ThesaurusInfo>();
        for (IncludeKey includeKey : byList) {
            Thesaurus thesaurus = (Thesaurus)fichotheque.getSubset(includeKey.getSubsetKey());
            if (thesaurus == null) continue;
            thesaurusInfoList.add(new ThesaurusInfo(thesaurus, includeKey));
        }
        if (thesaurusInfoList.isEmpty()) {
            return null;
        }
        ArrayList<JunctionInfo> junctionInfoList = new ArrayList<JunctionInfo>();
        for (IncludeKey junctionIncludeKey : groupbyDef.getJunctionList()) {
            Corpus corpus = (Corpus)fichotheque.getSubset(junctionIncludeKey.getSubsetKey());
            if (corpus == null) continue;
            junctionInfoList.add(new JunctionInfo(corpus, junctionIncludeKey));
        }
        ThesaurusInfo[] thesaurusInfoArray = thesaurusInfoList.toArray(new ThesaurusInfo[thesaurusInfoList.size()]);
        JunctionInfo[] junctionInfoArray = junctionInfoList.toArray(new JunctionInfo[junctionInfoList.size()]);
        return new GroupbyEngine(analytiqueDef, coreAliasHolder, ligneHolder, currencies, thesaurusInfoArray, junctionInfoArray);
    }

    public void populate(SubsetItemPointeur analytiqueItemPointeur, AnalytiqueItemBuilder analytiqueItemBuilder) {
        HashMap<GroupbyKey, FinalGroupbyInfo> groupbyInfoMap = new HashMap<GroupbyKey, FinalGroupbyInfo>();
        this.populateLignes(analytiqueItemPointeur, groupbyInfoMap);
        this.populateJunction(analytiqueItemPointeur, groupbyInfoMap);
        int length = this.thesaurusInfoArray.length;
        TreeMap<Integer, GroupbyBuffer> firstLevelMap = new TreeMap<Integer, GroupbyBuffer>();
        HashMap<Integer, GroupbyBuffer> byIdMap = new HashMap<Integer, GroupbyBuffer>();
        ThesaurusInfo firstLevelInfo = this.thesaurusInfoArray[0];
        for (FinalGroupbyInfo groupbyInfo : groupbyInfoMap.values()) {
            GroupbyKey groupbyKey = groupbyInfo.groupbyKey;
            int firstLevelId = groupbyKey.getId(0);
            GroupbyBuffer groupbyBuffer = (GroupbyBuffer)byIdMap.get(firstLevelId);
            if (groupbyBuffer == null) {
                Motcle motcle = firstLevelInfo.getMotcle(firstLevelId);
                int position = firstLevelInfo.getPosition(firstLevelId);
                groupbyBuffer = length == 1 ? new GroupbyBuffer(motcle, position, groupbyInfo.analytiqueGatheringBuilder) : new GroupbyBuffer(motcle, position, AnalytiqueGatheringBuilder.buildForGroupby(this.operationDefLength, firstLevelInfo.includeKey));
                firstLevelMap.put(position, groupbyBuffer);
                byIdMap.put(firstLevelId, groupbyBuffer);
            }
            if (length > 1) {
                groupbyBuffer.checkSubGroupbyBuffer(groupbyInfo, 1);
            }
            groupbyInfo.populateAgregat();
        }
        for (GroupbyBuffer groupbyBuffer : firstLevelMap.values()) {
            analytiqueItemBuilder.addGroupby(groupbyBuffer.toGroupby());
        }
    }

    private void populateJunction(SubsetItemPointeur analytiqueItemPointeur, Map<GroupbyKey, FinalGroupbyInfo> groupbyInfoMap) {
        int junctionLength = this.junctionInfoArray.length;
        for (int i = 0; i < junctionLength; ++i) {
            JunctionInfo junctionInfo = this.junctionInfoArray[i];
            Collection liaisons = analytiqueItemPointeur.getLiaisons((Subset)junctionInfo.corpus, (IncludeMode)junctionInfo.includeKey);
            for (Liaison liaison : liaisons) {
                SubsetItem subsetItem = liaison.getSubsetItem();
                FinalGroupbyInfo groupbyInfo = this.getFinalGroupbyInfo(subsetItem, groupbyInfoMap);
                groupbyInfo.addJunctionSubsetItem(i, subsetItem);
            }
        }
    }

    private void populateLignes(SubsetItemPointeur analytiqueItemPointeur, Map<GroupbyKey, FinalGroupbyInfo> groupbyInfoMap) {
        Ligne ligne;
        LigneKey ligneKey;
        FicheMeta ficheMeta;
        for (Liaison liaison : analytiqueItemPointeur.getStandardLiaisons((Subset)this.coreAliasHolder.getCorpus("depense"))) {
            ficheMeta = (FicheMeta)liaison.getSubsetItem();
            ligneKey = LigneKey.get("depense", ficheMeta.getId());
            ligne = this.ligneHolder.getLigne(ligneKey);
            if (ligne != null) {
                this.addDepenseLigne(ligne, groupbyInfoMap);
                continue;
            }
            Avenir avenir = this.ligneHolder.getAvenir(ligneKey);
            if (avenir == null) continue;
            this.addDepenseAvenir(avenir, groupbyInfoMap);
        }
        for (Liaison liaison : analytiqueItemPointeur.getStandardLiaisons((Subset)this.coreAliasHolder.getCorpus("apport"))) {
            ficheMeta = (FicheMeta)liaison.getSubsetItem();
            ligneKey = LigneKey.get("apport", ficheMeta.getId());
            ligne = this.ligneHolder.getLigne(ligneKey);
            if (ligne == null) continue;
            this.addApportLigne(ligne, groupbyInfoMap);
        }
        for (Liaison liaison : analytiqueItemPointeur.getStandardLiaisons((Subset)this.coreAliasHolder.getCorpus("avance"))) {
            LigneKey soldeAvanceLigneKey;
            Ligne soldeAvanceLigne;
            ficheMeta = (FicheMeta)liaison.getSubsetItem();
            LigneKey avanceLigneKey = LigneKey.get("avance", ficheMeta.getId(), false);
            Ligne avanceLigne = this.ligneHolder.getLigne(avanceLigneKey);
            if (avanceLigne != null) {
                this.addAvanceLigne(avanceLigne, groupbyInfoMap);
            }
            if ((soldeAvanceLigne = this.ligneHolder.getLigne(soldeAvanceLigneKey = LigneKey.get("avance", ficheMeta.getId(), true))) == null) continue;
            this.addSoldeAvanceLigne(soldeAvanceLigne, groupbyInfoMap);
        }
    }

    private void addDepenseLigne(Ligne ligne, Map<GroupbyKey, FinalGroupbyInfo> groupbyInfoMap) {
        FinalGroupbyInfo groupbyInfo = this.getFinalGroupbyInfo((SubsetItem)ligne.getFicheMeta(), groupbyInfoMap);
        groupbyInfo.analytiqueGatheringBuilder.addDepenseLigne(ligne);
    }

    private void addDepenseAvenir(Avenir avenir, Map<GroupbyKey, FinalGroupbyInfo> groupbyInfoMap) {
        FinalGroupbyInfo groupbyInfo = this.getFinalGroupbyInfo((SubsetItem)avenir.getFicheMeta(), groupbyInfoMap);
        groupbyInfo.analytiqueGatheringBuilder.addDepenseAvenir(avenir);
    }

    private void addApportLigne(Ligne ligne, Map<GroupbyKey, FinalGroupbyInfo> groupbyInfoMap) {
        FinalGroupbyInfo groupbyInfo = this.getFinalGroupbyInfo((SubsetItem)ligne.getFicheMeta(), groupbyInfoMap);
        groupbyInfo.analytiqueGatheringBuilder.addApportLigne(ligne);
    }

    private void addAvanceLigne(Ligne ligne, Map<GroupbyKey, FinalGroupbyInfo> groupbyInfoMap) {
        FinalGroupbyInfo groupbyInfo = this.getFinalGroupbyInfo((SubsetItem)ligne.getFicheMeta(), groupbyInfoMap);
        groupbyInfo.analytiqueGatheringBuilder.addAvanceLigne(ligne);
    }

    private void addSoldeAvanceLigne(Ligne ligne, Map<GroupbyKey, FinalGroupbyInfo> groupbyInfoMap) {
        FinalGroupbyInfo groupbyInfo = this.getFinalGroupbyInfo((SubsetItem)ligne.getFicheMeta(), groupbyInfoMap);
        groupbyInfo.analytiqueGatheringBuilder.addSoldeAvanceLigne(ligne);
    }

    private FinalGroupbyInfo getFinalGroupbyInfo(SubsetItem subsetItem, Map<GroupbyKey, FinalGroupbyInfo> groupbyInfoMap) {
        Fichotheque fichotheque = subsetItem.getFichotheque();
        int length = this.thesaurusInfoArray.length;
        int[] idArray = new int[length];
        for (int i = 0; i < length; ++i) {
            IncludeKey includeKey = this.thesaurusInfoArray[i].includeKey;
            Croisements croisements = fichotheque.getCroisements(subsetItem, (Subset)this.thesaurusInfoArray[i].thesaurus);
            Collection liaisons = CroisementUtils.filter((Croisements)croisements, (IncludeMode)includeKey);
            if (liaisons.isEmpty()) continue;
            Motcle motcle = (Motcle)((Liaison)liaisons.iterator().next()).getSubsetItem();
            idArray[i] = motcle.getId();
        }
        GroupbyKey groupbyKey = new GroupbyKey(idArray);
        FinalGroupbyInfo current = groupbyInfoMap.get(groupbyKey);
        if (current == null) {
            AnalytiqueGatheringBuilder analytiqueGatheringBuilder = AnalytiqueGatheringBuilder.buildForGroupby(this.operationDefLength, this.lastGroupbyIncludeKey);
            current = new FinalGroupbyInfo(groupbyKey, analytiqueGatheringBuilder, this.junctionInfoArray.length);
            groupbyInfoMap.put(groupbyKey, current);
        }
        return current;
    }

    private static class JunctionInfo {
        private final Corpus corpus;
        private final IncludeKey includeKey;
        private final SubsetItemPointeur pointeur;

        private JunctionInfo(Corpus corpus, IncludeKey includeKey) {
            this.corpus = corpus;
            this.includeKey = includeKey;
            this.pointeur = PointeurFactory.newSubsetItemPointeur((Subset)corpus);
        }
    }

    private static class ThesaurusInfo {
        private final Thesaurus thesaurus;
        private final IncludeKey includeKey;
        private final Map<Integer, Integer> positionByIdMap = new HashMap<Integer, Integer>();

        private ThesaurusInfo(Thesaurus thesaurus, IncludeKey includeKey) {
            this.thesaurus = thesaurus;
            this.includeKey = includeKey;
            int p = 1;
            Motcle motcle = ThesaurusUtils.getFirst((Thesaurus)thesaurus);
            while (motcle != null) {
                this.positionByIdMap.put(motcle.getId(), p);
                ++p;
                motcle = ThesaurusUtils.getNext((Motcle)motcle);
            }
        }

        public Motcle getMotcle(int id) {
            if (id == 0) {
                return null;
            }
            return this.thesaurus.getMotcleById(id);
        }

        public int getPosition(int id) {
            if (id == 0) {
                return 0;
            }
            return this.positionByIdMap.get(id);
        }
    }

    private final class FinalGroupbyInfo {
        private final GroupbyKey groupbyKey;
        private final AnalytiqueGatheringBuilder analytiqueGatheringBuilder;
        private final List<SubsetItem>[] junctionListArray;

        private FinalGroupbyInfo(GroupbyKey groupbyKey, AnalytiqueGatheringBuilder analytiqueGatheringBuilder, int corpusInfoCount) {
            this.groupbyKey = groupbyKey;
            this.analytiqueGatheringBuilder = analytiqueGatheringBuilder;
            this.junctionListArray = corpusInfoCount > 0 ? new List[corpusInfoCount] : null;
        }

        private void addJunctionSubsetItem(int subsetIndex, SubsetItem subsetItem) {
            List<SubsetItem> list = this.junctionListArray[subsetIndex];
            if (list == null) {
                this.junctionListArray[subsetIndex] = list = new ArrayList<SubsetItem>();
            }
            list.add(subsetItem);
        }

        private void populateAgregat() {
            List<OperationDef> operationDefList = GroupbyEngine.this.analytiqueDef.getOperationDefList();
            int operationDefLength = operationDefList.size();
            for (int i = 0; i < operationDefLength; ++i) {
                AgregatDef agregatDef;
                OperationDef operationDef = operationDefList.get(i);
                if (!(operationDef instanceof AgregatDef) || (agregatDef = (AgregatDef)operationDef).getType() != 3) continue;
                for (JunctionInfo junctionInfo : GroupbyEngine.this.junctionInfoArray) {
                    List<SubsetItem> list;
                    if (!junctionInfo.includeKey.equals((Object)agregatDef.getIncludeKey()) || (list = this.junctionListArray[i]) == null) continue;
                    AgregatGatheringBuilder builder = this.analytiqueGatheringBuilder.getAgregatGatheringBuilder(i, GroupbyEngine.this.currencies.size());
                    SubsetItemPointeur pointeur = junctionInfo.pointeur;
                    for (SubsetItem subsetItem : list) {
                        pointeur.setCurrentSubsetItem(subsetItem);
                        GroupbyEngine.this.populate(builder, pointeur, agregatDef, this.analytiqueGatheringBuilder.getMessageHandler(), GroupbyEngine.this.currencies);
                    }
                }
            }
        }
    }

    private class GroupbyBuffer {
        private final Motcle motcle;
        private final int position;
        private final AnalytiqueGatheringBuilder ligneGatheringBuffer;
        private final SortedMap<Integer, GroupbyBuffer> byPositionMap = new TreeMap<Integer, GroupbyBuffer>();
        private final Map<Integer, GroupbyBuffer> byIdMap = new HashMap<Integer, GroupbyBuffer>();

        private GroupbyBuffer(Motcle motcle, int position, AnalytiqueGatheringBuilder ligneGatheringBuffer) {
            this.motcle = motcle;
            this.position = position;
            this.ligneGatheringBuffer = ligneGatheringBuffer;
        }

        private void checkSubGroupbyBuffer(FinalGroupbyInfo groupbyInfo, int level) {
            boolean last = level == GroupbyEngine.this.thesaurusInfoArray.length - 1;
            ThesaurusInfo thesaurusInfo = GroupbyEngine.this.thesaurusInfoArray[level];
            int motcleid = groupbyInfo.groupbyKey.getId(level);
            GroupbyBuffer groupbyBuffer = this.byIdMap.get(motcleid);
            if (groupbyBuffer == null) {
                Motcle childMotcle = thesaurusInfo.getMotcle(motcleid);
                int childPosition = thesaurusInfo.getPosition(motcleid);
                groupbyBuffer = last ? new GroupbyBuffer(childMotcle, childPosition, groupbyInfo.analytiqueGatheringBuilder) : new GroupbyBuffer(childMotcle, childPosition, AnalytiqueGatheringBuilder.buildForGroupby(GroupbyEngine.this.operationDefLength, thesaurusInfo.includeKey));
                this.byPositionMap.put(childPosition, groupbyBuffer);
                this.byIdMap.put(motcleid, groupbyBuffer);
            }
            if (!last) {
                groupbyBuffer.checkSubGroupbyBuffer(groupbyInfo, level + 1);
            }
        }

        private AnalytiqueGathering.Groupby toGroupby() {
            List<AnalytiqueGathering.Groupby> groupbyList;
            if (this.byPositionMap.isEmpty()) {
                groupbyList = AnalytiqueUtils.EMPTY_GROUPBYLIST;
            } else {
                groupbyList = new ArrayList<AnalytiqueGathering.Groupby>();
                for (GroupbyBuffer buffer : this.byPositionMap.values()) {
                    groupbyList.add(buffer.toGroupby());
                }
            }
            return AnalytiqueUtils.toGroupby(this.motcle, this.ligneGatheringBuffer.toAnalytiqueGathering(), groupbyList);
        }
    }
}

