/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.multiidselection.htmlhook;

import fr.exemole.bdfext.multiidselection.FormValues;
import fr.exemole.bdfext.multiidselection.MultiIdSelection;
import fr.exemole.bdfext.multiidselection.MultiIdSelectionSpace;
import fr.exemole.bdfserver.api.managers.PermissionManager;
import fr.exemole.bdfserver.api.roles.Role;
import fr.exemole.bdfserver.api.users.BdfUser;
import fr.exemole.bdfserver.html.BdfHtmlHook;
import fr.exemole.bdfserver.html.BdfServerHtmlProducer;
import fr.exemole.bdfserver.html.ParameterMap;
import fr.exemole.bdfserver.html.consumers.Button;
import fr.exemole.bdfserver.html.consumers.PageUnit;
import fr.exemole.bdfserver.tools.users.BdfUserUtils;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Consumer;
import net.fichotheque.Subset;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.utils.FichothequeUtils;
import net.mapeadores.util.attr.Attribute;
import net.mapeadores.util.attr.AttributeKey;
import net.mapeadores.util.html.HtmlPrinter;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.Litteral;
import net.mapeadores.util.primitives.FuzzyDate;

public class SelectFormHtmlHook
implements BdfHtmlHook {
    public void init(BdfServerHtmlProducer bdfHtmlProducer) {
        bdfHtmlProducer.addExtensionThemeCss("fr-exemole-multiidselection", new String[]{"selectform.css"});
    }

    public void insert(BdfServerHtmlProducer bdfHtmlProducer, String insertName) {
        if (!insertName.equals("after")) {
            return;
        }
        PermissionManager permissionManager = bdfHtmlProducer.getBdfServer().getPermissionManager();
        Role role = permissionManager.getRole("multiidselection");
        if (role == null) {
            return;
        }
        if (!BdfUserUtils.hasRole((PermissionManager)permissionManager, (BdfUser)bdfHtmlProducer.getBdfUser(), (Role)role)) {
            return;
        }
        DateFormat dateFormat = DateFormat.getDateInstance(2, bdfHtmlProducer.getFormatLocale());
        FormValues formValues = FormValues.getCurrent(bdfHtmlProducer.getBdfUser());
        BdfServerHtmlProducer hp = bdfHtmlProducer;
        hp.__((Consumer)PageUnit.start((String)"action-Selection", (Object)new Litteral("S\u00e9lection des nouvelles du lundi"))).FORM_post("selection", "List").INPUT_hidden((Map)ParameterMap.init().command(MultiIdSelection.DOMAIN, "multiidselection").page("main", "fiches"));
        hp.TABLE("multiidselection-Table");
        hp.TR();
        hp.TH().__localize("_ label.global.corpus")._TH();
        hp.TH().__escape((CharSequence)"N\u00b0 \u00e0 reporter")._TH();
        hp.TH().__escape((CharSequence)"\u00c0 partir du N\u00b0")._TH();
        hp.TH().__escape((CharSequence)"Dernier N\u00b0 des s\u00e9lections pr\u00e9c\u00e9dentes")._TH();
        hp._TR();
        Attribute corpusAttribute = role.getAttributes().getAttribute(MultiIdSelectionSpace.CORPUS_KEY);
        HashSet<String> existingSet = new HashSet<String>();
        if (corpusAttribute != null) {
            int valueLength = corpusAttribute.size();
            for (int i = 0; i < valueLength; ++i) {
                String corpusName = (String)corpusAttribute.get(i);
                if (existingSet.contains(corpusName)) continue;
                hp.__(this.printRow((HtmlPrinter)hp, bdfHtmlProducer, corpusName, formValues, role, dateFormat));
                existingSet.add(corpusName);
            }
        }
        hp._TABLE();
        hp.__(Button.COMMAND, (Consumer)Button.submit().text("S\u00e9lectionner"))._FORM().__(PageUnit.END);
    }

    private boolean printRow(HtmlPrinter hp, BdfServerHtmlProducer bdfHtmlProducer, String corpusName, FormValues formValues, Role role, DateFormat dateFormat) {
        Corpus corpus;
        try {
            SubsetKey corpusKey = SubsetKey.parse((short)1, (String)corpusName);
            corpus = (Corpus)bdfHtmlProducer.getFichotheque().getSubset(corpusKey);
            if (corpus == null) {
                return false;
            }
        }
        catch (ParseException pe) {
            return false;
        }
        String rangeParam = corpusName + "|range";
        String startParam = corpusName + "|start";
        hp.TR();
        hp.TD().__escape((CharSequence)FichothequeUtils.getTitle((Subset)corpus, (Lang)bdfHtmlProducer.getWorkingLang()))._TD();
        hp.TD("multiidselection-InputCell").INPUT_text(hp.name(rangeParam).value(formValues.getValue(rangeParam)).size("20"))._TD();
        hp.TD("multiidselection-InputCell").INPUT_text(hp.name(startParam).value(formValues.getValue(startParam)).size("5"))._TD();
        hp.TD().__(this.printHistory(hp, role, corpus, dateFormat))._TD();
        hp._TR();
        return true;
    }

    private boolean printHistory(HtmlPrinter hp, Role role, Corpus corpus, DateFormat dateFormat) {
        AttributeKey attributeKey = MultiIdSelectionSpace.toKey(corpus.getSubsetKey());
        Attribute attribute = role.getAttributes().getAttribute(attributeKey);
        if (attribute == null) {
            return false;
        }
        boolean next = false;
        int valueLength = attribute.size();
        for (int i = 0; i < valueLength; ++i) {
            String value = (String)attribute.get(i);
            int idx = value.indexOf(44);
            if (idx == -1) continue;
            try {
                FuzzyDate date = FuzzyDate.parse((String)value.substring(0, idx));
                if (next) {
                    hp.__escape((CharSequence)" / ");
                } else {
                    next = true;
                }
                hp.EM().__escape((CharSequence)dateFormat.format(date.toDate())).__colon()._EM().__escape((CharSequence)value.substring(idx + 1));
                continue;
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return true;
    }
}

