/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.icyce.htmlpages;

import fr.exemole.bdfext.icyce.GroupementPays;
import fr.exemole.bdfext.icyce.Icyce;
import fr.exemole.bdfext.icyce.htmlpages.IcyceHtmlPage;
import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.users.BdfUser;
import fr.exemole.bdfserver.tools.roles.PermissionSummaryBuilder;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.fichotheque.Subset;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.fiche.CountryItem;
import net.fichotheque.permission.PermissionSummary;
import net.fichotheque.sphere.Redacteur;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.utils.FichothequeUtils;
import net.mapeadores.util.html.HA;
import net.mapeadores.util.html.HtmlAttributes;
import net.mapeadores.util.localisation.Lang;

public abstract class CadreHtmlPage
extends IcyceHtmlPage {
    private boolean canCreate = true;
    private final PermissionSummary permissionSummary;
    private final HtmlAttributes aLienFicheAttributes = new HtmlAttributes();

    public CadreHtmlPage(BdfServer bdfServer, BdfUser bdfUser) {
        super(bdfServer, bdfUser);
        this.aLienFicheAttributes.addClass("LIENFICHE");
        this.permissionSummary = PermissionSummaryBuilder.build((BdfServer)bdfServer, (BdfUser)bdfUser);
    }

    public void writeHtml(Appendable appendable) throws IOException {
        this.initPrinter(appendable);
        this.addIconPng(this.getRscPath("images/icone.png"), "16");
        this.addRscCss("icyce.css");
        this.addRscCss("icyce_" + this.workingLang.toString() + ".css");
        this.addSupplementaryCss();
        this.addJquery();
        this.addSupplementaryJs();
        this.start(this.workingLang, this.getTitle());
        this.DIV(HA.id((String)"BLOC_GLOBAL"));
        this.DIV(HA.id((String)"BLOC_ENTETE"));
        this.DIV(HA.id((String)"BLOC_MENU"));
        this.P("TitreGlobal").__localize("global_title")._P();
        this.P("SoustitreGlobal").__localize("global_subtitle")._P();
        this.P("SuiteLiens");
        this.printLink("carte_monde", "index.html");
        this.__dash();
        this.printLink("titre_liste_cn", "liste.html");
        if (Icyce.config.withParLangue()) {
            this.__dash();
            this.printLink("titre_par_langue", "parlangue.html");
        }
        if (Icyce.config.withMesconfs()) {
            int conferenceCount = this.icyceUser.getConferenceCount();
            if (conferenceCount == 1) {
                this.__dash();
                this.printLink("titre_conference_1", "conf-" + this.icyceUser.getConferenceId(0) + ".html");
            } else if (conferenceCount > 1) {
                this.__dash();
                this.printLink("titre_conference_plus", "mesconfs.html");
            }
        }
        if (Icyce.config.withMasphere() && this.icyceUser.getUserLevel() == 2) {
            this.__dash();
            this.printLink("masphere", "sphere.html");
        }
        this._P();
        this._DIV();
        this.DIV(HA.id((String)"BLOC_LANGUES")).__localize("redacteur_key").__space();
        Redacteur redacteur = this.bdfUser.getRedacteur();
        this.__escape(redacteur.getCompleteName()).__escape((CharSequence)" - ").A(HA.href((CharSequence)"?bdf-exit=1")).__localize("exit_session")._A()._DIV();
        this._DIV();
        this.DIV(HA.id((String)"BLOC_CORPS"));
        this.printCorps();
        this._DIV();
        this._DIV();
        this.end();
    }

    public void setCanCreate(boolean canCreate) {
        this.canCreate = canCreate;
    }

    public boolean canCreate() {
        return this.canCreate;
    }

    public abstract String getTitle();

    public abstract void addSupplementaryCss();

    public abstract void addSupplementaryJs();

    public abstract void printCorps();

    public abstract String getCurrentPage();

    public void printLink(String idalpha, String url) {
        if (url.equals(this.getCurrentPage())) {
            this.__localize(idalpha);
        } else {
            HtmlAttributes aAttributes = new HtmlAttributes();
            aAttributes.href((CharSequence)url);
            this.A(aAttributes).__localize(idalpha)._A();
        }
    }

    public void appendIcon(String name) {
        HtmlAttributes imgAttributes = new HtmlAttributes();
        imgAttributes.height("16");
        imgAttributes.width("16");
        imgAttributes.src((CharSequence)this.getRscPath("images/" + name + ".png"));
        imgAttributes.titleLocKey(name);
        this.IMG(imgAttributes);
    }

    public void appendLienFiche(FicheMeta ficheMeta, String alter, String param1) {
        String ficheidString = String.valueOf(ficheMeta.getId());
        String corpusName = ficheMeta.getSubsetName();
        this.aLienFicheAttributes.href((CharSequence)("../../fiches/" + corpusName + "-" + ficheidString + ".html"));
        this.A(this.aLienFicheAttributes);
        this.appendIcon("fiche_lire");
        this._A();
        if (this.permissionSummary.canWrite(ficheMeta)) {
            this.__space();
            StringBuilder buf = new StringBuilder();
            buf.append("../../edition?corpus=");
            buf.append(corpusName);
            buf.append("&id=");
            buf.append(ficheidString);
            buf.append("&page=fiche-modif");
            if (alter != null) {
                buf.append("&alter=");
                buf.append(alter);
            }
            if (param1 != null) {
                buf.append("&param_1=");
                buf.append(param1);
            }
            this.aLienFicheAttributes.href((CharSequence)buf.toString());
            this.A(this.aLienFicheAttributes);
            this.appendIcon("fiche_modifier");
            this._A();
        }
    }

    public void appendLienCreation(Corpus corpus, String alter, String param1) {
        if (this.canCreate && this.permissionSummary.canCreate((Subset)corpus)) {
            String corpusName = corpus.getSubsetName();
            StringBuilder buf = new StringBuilder();
            buf.append("../../Saisie?corpus=");
            buf.append(corpusName);
            buf.append("&page=fiche-creation");
            if (alter != null) {
                buf.append("&alter=");
                buf.append(alter);
            }
            if (param1 != null) {
                buf.append("&param_1=");
                buf.append(param1);
            }
            this.aLienFicheAttributes.href((CharSequence)buf.toString());
            this.A(this.aLienFicheAttributes);
            this.appendIcon("fiche_creer");
            this._A();
        }
    }

    public void printCorpus(Corpus corpus, List<FicheMeta> list, String alter, String param1, boolean entree) {
        boolean empty = list.isEmpty();
        SubsetKey corpusKey = corpus.getSubsetKey();
        this.DIV("ETAPEITEM");
        if (!empty) {
            this.DIV(HA.id((String)("ITEMBOX_" + corpusKey.getSubsetName())).classes("ITEMBOX")).__escape('+')._DIV();
        }
        String classes = "ITEMLIB";
        if (empty) {
            classes = "ITEMLIB VideItemLib";
        }
        this.P(classes);
        if (entree) {
            this.__localize("entree_" + corpusKey.getSubsetName());
        } else {
            this.__escape(FichothequeUtils.getTitle((Subset)corpus, (Lang)this.workingLang));
        }
        if (corpus.getMasterSubset() == null) {
            this.__space();
            this.appendLienCreation(corpus, alter, param1);
        }
        this._P();
        if (!empty) {
            this.UL(HA.id((String)("DETAIL_" + corpusKey.getSubsetName())).classes("DETAIL DetailInvisible"));
            for (FicheMeta ficheMeta : list) {
                this.LI().__escape((CharSequence)ficheMeta.getTitle()).__space();
                this.appendLienFiche(ficheMeta, alter, param1);
                this._LI();
            }
            this._UL();
        }
        this._DIV();
    }

    public void printGroupementPays(GroupementPays groupementPays) {
        String libelle;
        this.UL("Liste");
        Thesaurus masterThesaurus = (Thesaurus)groupementPays.getCorpus().getMasterSubset();
        TreeMap<String, GroupementPays.PaysItem> sortedMap = new TreeMap<String, GroupementPays.PaysItem>();
        int count = groupementPays.getPaysCount();
        for (int i = 0; i < count; ++i) {
            GroupementPays.PaysItem ggpi = groupementPays.getPaysItem(i);
            CountryItem pays = ggpi.getPays();
            libelle = this.getLocalization(pays.getCountry().toString());
            sortedMap.put(libelle, ggpi);
        }
        HtmlAttributes imgAttributes = new HtmlAttributes();
        for (Map.Entry entry : sortedMap.entrySet()) {
            libelle = (String)entry.getKey();
            GroupementPays.PaysItem gppi = (GroupementPays.PaysItem)entry.getValue();
            CountryItem pays = gppi.getPays();
            imgAttributes.src((CharSequence)this.getRscPath("flags/" + pays.getCountry().toString() + ".png"));
            int abCount = gppi.getFicheMetaCount();
            if (abCount == 0) continue;
            this.LI();
            if (abCount == 1) {
                FicheMeta ficheMeta = gppi.getFicheMeta(0);
                this.P("EntreePays").IMG(imgAttributes).__space().A(HA.href((CharSequence)("conf-" + ficheMeta.getId() + ".html"))).__escape((CharSequence)libelle)._A()._P();
            } else {
                this.P("EntreePays").IMG(imgAttributes).__space().__escape((CharSequence)libelle)._P();
                this.UL("ListeConfParPays");
                for (int i = 0; i < abCount; ++i) {
                    FicheMeta ficheMeta = gppi.getFicheMeta(i);
                    int id = ficheMeta.getId();
                    Motcle motcle = masterThesaurus.getMotcleById(id);
                    this.LI().A(HA.href((CharSequence)("conf-" + id + ".html"))).__escape((CharSequence)motcle.getLabelString(this.workingLang))._A()._LI();
                }
                this._UL();
            }
            this._LI();
        }
        this._UL();
    }
}

