/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.xml.api;

import java.io.IOException;
import net.desmodo.atlas.AtlasFilter;
import net.desmodo.atlas.TermSpaceManager;
import net.desmodo.atlas.descripteurs.Descripteur;
import net.desmodo.atlas.descripteurs.DescripteurList;
import net.desmodo.atlas.descripteurs.Descripteurs;
import net.desmodo.atlas.structure.Contexte;
import net.desmodo.atlas.structure.ContexteList;
import net.desmodo.atlas.structure.Structure;
import net.desmodo.atlas.structure.StructureUtils;
import net.mapeadores.util.attr.AttributeUtils;
import net.mapeadores.util.attr.Attributes;
import net.mapeadores.util.text.Labels;
import net.mapeadores.util.text.LangFilter;
import net.mapeadores.util.xml.XMLPart;
import net.mapeadores.util.xml.XMLUtils;
import net.mapeadores.util.xml.XMLWriter;

public class DescripteursXMLPart
extends XMLPart {
    private boolean oldCrtxml;
    private final TermSpaceManager termSpaceManager;
    private final AtlasFilter atlasFilter;

    public DescripteursXMLPart(XMLWriter xmlWriter, TermSpaceManager termSpaceManager, AtlasFilter atlasFilter) {
        super(xmlWriter);
        this.termSpaceManager = termSpaceManager;
        this.atlasFilter = atlasFilter;
    }

    public void setOldCrtxml(boolean oldCrtxml) {
        this.oldCrtxml = oldCrtxml;
    }

    public void addDescripteurs(Descripteurs descripteurs) throws IOException {
        this.openTag("descripteurs");
        Structure structure = descripteurs.getAtlas().getStructure();
        ContexteList liste = StructureUtils.getContexteList(structure.getGrilleDesFamilles(), false);
        int contexteCount = liste.getContexteCount();
        for (int i = 0; i < contexteCount; ++i) {
            Contexte famille = liste.getContexte(i);
            DescripteurList infamilleDescripteurList = descripteurs.getInFamilleDescripteurList(famille);
            int descripteurCount = infamilleDescripteurList.getDescripteurCount();
            if (descripteurCount <= 0) continue;
            this.startOpenTag("infamille");
            this.addAttribute("idctxt", famille.getIdctxt());
            this.endOpenTag();
            for (int j = 0; j < descripteurCount; ++j) {
                Descripteur descripteur = infamilleDescripteurList.getDescripteur(j);
                if (!this.atlasFilter.acceptDescripteur(descripteur)) continue;
                this.addDescripteur(descripteur);
            }
            this.closeTag("infamille");
        }
        DescripteurList sansfamilleDescripteurList = descripteurs.getInFamilleDescripteurList(StructureUtils.getSansfamilleContexte(structure));
        int descripteurCount = sansfamilleDescripteurList.getDescripteurCount();
        if (descripteurCount > 0) {
            this.openTag("sansfamille");
            for (int i = 0; i < descripteurCount; ++i) {
                Descripteur descripteur = sansfamilleDescripteurList.getDescripteur(i);
                if (!this.atlasFilter.acceptDescripteur(descripteur)) continue;
                this.addDescripteur(descripteur);
            }
            this.closeTag("sansfamille");
        }
        this.closeTag("descripteurs");
    }

    private void addDescripteur(Descripteur descripteur) throws IOException {
        this.startOpenTag("descripteur");
        this.addAttribute("iddesc", this.termSpaceManager.toString(descripteur.getIddesc()));
        this.endOpenTag();
        XMLUtils.addLibElements((XMLWriter)this, (Labels)descripteur.getLabels(), (LangFilter)this.atlasFilter.getLangFilter());
        if (!this.oldCrtxml) {
            AttributeUtils.addAttributes((XMLWriter)this, (Attributes)descripteur.getAttributes());
        }
        this.closeTag("descripteur");
    }
}

