/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.wrapper;

import java.awt.Color;
import java.text.Collator;
import java.text.RuleBasedCollator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ComboBoxModel;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import net.desmodo.atlas.Atlas;
import net.desmodo.atlas.AtlasUtils;
import net.desmodo.atlas.Term;
import net.desmodo.atlas.descripteurs.Descripteur;
import net.desmodo.atlas.descripteurs.DescripteurList;
import net.desmodo.atlas.descripteurs.Descripteurs;
import net.desmodo.atlas.structure.Contexte;
import net.desmodo.atlas.structure.ContexteList;
import net.desmodo.atlas.structure.Grille;
import net.desmodo.atlas.structure.GrilleList;
import net.desmodo.atlas.structure.Structure;
import net.desmodo.atlas.structure.StructureUtils;
import net.desmodo.atlas.wrapper.AbstractComboBoxModel;
import net.desmodo.atlas.wrapper.GroupeItem;
import net.desmodo.atlas.wrapper.GroupeItemImpl;
import net.desmodo.atlas.wrapper.GroupeItemManagerImpl;
import net.desmodo.atlas.wrapper.LibelleItem;
import net.desmodo.atlas.wrapper.LibelleItemComparator;
import net.desmodo.atlas.wrapper.LibelleItemImpl;
import net.desmodo.atlas.wrapper.LibelleItemManager;
import net.mapeadores.util.awt.ColorSkin;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.text.collation.CollationUnit;

class LibelleItemManagerImpl
implements LibelleItemManager {
    private final Map<Integer, LibelleItem> libelleItemMap = new HashMap<Integer, LibelleItem>();
    private final GroupeItemManagerImpl groupeItemManager;
    private AvailableInGrilleContexteLibelleItemModel availableInGrilleContexteLibelleItemModel;
    private final SortedDescripteurLibelleItemModel sortedDescripteurLibelleItemModel = new SortedDescripteurLibelleItemModel();
    private HorsgrilleLibelleItem horsgrilleLibelleItem;
    private RuleBasedCollator collator;
    private Lang workingLang;

    LibelleItemManagerImpl(Atlas atlas, Lang workingLang, GroupeItemManagerImpl groupeItemManager) {
        this.groupeItemManager = groupeItemManager;
        this.reinit(atlas, workingLang);
    }

    @Override
    public LibelleItem getLibelleItem(int code) {
        return this.libelleItemMap.get(code);
    }

    @Override
    public ComboBoxModel getLibelleItemModel(GroupeItem groupeItem) {
        if (groupeItem.equals(this.horsgrilleLibelleItem)) {
            return this.horsgrilleLibelleItem;
        }
        GroupeItemImpl internalGroupeItem = (GroupeItemImpl)groupeItem;
        return internalGroupeItem.getGroupeModel();
    }

    @Override
    public ComboBoxModel getSortedDescripteurLibelleItemModel() {
        return this.sortedDescripteurLibelleItemModel;
    }

    @Override
    public ComboBoxModel getAvailableInGrilleContexteLibelleItemModel() {
        return this.availableInGrilleContexteLibelleItemModel;
    }

    @Override
    public CollationUnit getCollatedString(String s) {
        return new CollationUnit(s, this.collator);
    }

    public Lang getWorkingLang() {
        return this.workingLang;
    }

    public RuleBasedCollator getCollator() {
        return this.collator;
    }

    private void reinit(Atlas atlas, Lang workingLang) {
        this.libelleItemMap.clear();
        this.workingLang = workingLang;
        this.collator = (RuleBasedCollator)Collator.getInstance(workingLang.toLocale());
        Structure structure = atlas.getStructure();
        Descripteurs descripteurs = atlas.getDescripteurs();
        this.horsgrilleLibelleItem = new HorsgrilleLibelleItem(structure);
        this.libelleItemMap.put(this.horsgrilleLibelleItem.getTermCode(), this.horsgrilleLibelleItem);
        this.initFamille(StructureUtils.getSansfamilleContexte(structure), descripteurs);
        ContexteList listeFamilles = StructureUtils.getFamilleList(structure, false);
        int familleCount = listeFamilles.getContexteCount();
        for (int i = 0; i < familleCount; ++i) {
            this.initFamille(listeFamilles.getContexte(i), descripteurs);
        }
        GrilleList grilleList = structure.getGrilleList();
        int grilleCount = grilleList.getGrilleCount();
        for (int i = 0; i < grilleCount; ++i) {
            this.initGrille(grilleList.getGrille(i));
        }
        this.sortedDescripteurLibelleItemModel.endInit();
        this.availableInGrilleContexteLibelleItemModel = new AvailableInGrilleContexteLibelleItemModel();
    }

    private void initFamille(Contexte famille, Descripteurs descripteurs) {
        GroupeItemImpl internalGroupeItem = this.groupeItemManager.getInternalGroupeItem(famille);
        DescripteurList descripteurList = descripteurs.getInFamilleDescripteurList(famille);
        int descripteurCount = descripteurList.getDescripteurCount();
        for (int i = 0; i < descripteurCount; ++i) {
            LibelleItemImpl libItem = this.createLibelleItem(descripteurList.getDescripteur(i), internalGroupeItem);
            this.sortedDescripteurLibelleItemModel.initAdd(libItem);
        }
    }

    private void initGrille(Grille grille) {
        GroupeItemImpl grilleGroupeItem = this.groupeItemManager.getInternalGroupeItem(grille);
        ContexteList children = grille.getFirstLevelContexteList();
        int contexteCount = children.getContexteCount();
        for (int i = 0; i < contexteCount; ++i) {
            Contexte contexte = children.getContexte(i);
            this.initContexte(contexte, grilleGroupeItem);
        }
    }

    private void initContexte(Contexte contexte, GroupeItemImpl internalGroupeItem) {
        LibelleItemImpl libItem = this.createLibelleItem(contexte, internalGroupeItem);
        ContexteList children = contexte.getChildren();
        int contexteCount = children.getContexteCount();
        if (contexteCount > 0) {
            GroupeItemImpl igi = this.groupeItemManager.getInternalGroupeItem(contexte);
            for (int i = 0; i < contexteCount; ++i) {
                this.initContexte(children.getContexte(i), igi);
            }
        }
    }

    void createLibelleItem(Descripteur descripteur) {
        if (this.libelleItemMap.containsKey(descripteur.getCode())) {
            throw new IllegalStateException("libelleItemExists : Un libell\u00e9 item existe d\u00e9j\u00e0 avec ce code");
        }
        GroupeItemImpl internalGroupeItem = this.groupeItemManager.getInternalGroupeItemParent(descripteur);
        LibelleItemImpl libItem = this.createLibelleItem(descripteur, internalGroupeItem);
        this.sortedDescripteurLibelleItemModel.addLibelleItem(libItem);
    }

    void removeLibelleItem(int termeCode) {
        LibelleItemImpl libitem = (LibelleItemImpl)this.libelleItemMap.get(termeCode);
        if (libitem != null) {
            GroupeItemImpl oldInternalGroupeItem = libitem.getGroupeItemImpl();
            this.libelleItemMap.remove(termeCode);
            oldInternalGroupeItem.removeLibelleItem(libitem);
            this.sortedDescripteurLibelleItemModel.removeLibelleItem(libitem);
        }
    }

    void createLibelleItem(Contexte contexte) {
        if (contexte.getTermType() != 3) {
            return;
        }
        if (this.libelleItemMap.containsKey(contexte.getCode())) {
            throw new IllegalStateException("libelleItemExists : Un libell\u00e9 item existe d\u00e9j\u00e0 avec ce code");
        }
        GroupeItemImpl internalGroupeItem = this.groupeItemManager.getInternalGroupeItemParent(contexte);
        LibelleItemImpl libItem = this.createLibelleItem(contexte, internalGroupeItem);
    }

    private LibelleItemImpl createLibelleItem(Term term, GroupeItemImpl internalGroupeItem) {
        LibelleItemImpl libItem = new LibelleItemImpl(this, term);
        this.libelleItemMap.put(libItem.getTermCode(), libItem);
        internalGroupeItem.addLibelleItem(libItem);
        return libItem;
    }

    void familleChanged(int descripteurCode, int newFamilleCode) {
        LibelleItemImpl libitem = (LibelleItemImpl)this.libelleItemMap.get(descripteurCode);
        GroupeItemImpl oldInternalGroupeItem = libitem.getGroupeItemImpl();
        GroupeItemImpl newInternalGroupeItem = this.groupeItemManager.getInternalGroupeItem(newFamilleCode);
        if (newInternalGroupeItem == null) {
            throw new IllegalStateException("groupeItemMissing : Il n'y a pas de GroupeItem pour le code de famille demand\u00e9");
        }
        oldInternalGroupeItem.removeLibelleItem(libitem);
        newInternalGroupeItem.addLibelleItem(libitem);
        this.sortedDescripteurLibelleItemModel.fireContentsChanged(libitem);
    }

    void libelleChanged(Term term) {
        LibelleItemImpl libitem = (LibelleItemImpl)this.libelleItemMap.get(term.getCode());
        if (libitem == null) {
            throw new IllegalStateException("libelleItemMissing : Il n'y a pas de LibelleItem pour le terme demand\u00e9");
        }
        String s = AtlasUtils.toLibelleString(term, this.workingLang);
        libitem.setLibelle(s);
        GroupeItemImpl internalGroupeItem = libitem.getGroupeItemImpl();
        internalGroupeItem.libelleItemChanged(libitem);
        if (libitem.getSortedDescripteurLibelleItemIndex() != -1) {
            this.sortedDescripteurLibelleItemModel.libelleChanged(libitem);
        }
    }

    void activeChanged(Contexte contexte) {
        LibelleItemImpl libitem = (LibelleItemImpl)this.libelleItemMap.get(contexte.getCode());
        if (libitem == null) {
            return;
        }
        GroupeItemImpl internalGroupeItem = libitem.getGroupeItemImpl();
        internalGroupeItem.activeChanged(contexte.isActive(), libitem);
    }

    void parentChanged(Contexte contexte) {
        if (StructureUtils.isFamille(contexte)) {
            return;
        }
        LibelleItemImpl libitem = (LibelleItemImpl)this.libelleItemMap.get(contexte.getCode());
        GroupeItemImpl oldInternalGroupeItem = libitem.getGroupeItemImpl();
        Contexte contexteParent = contexte.getParent();
        GroupeItemImpl newInternalGroupeItem = contexteParent == null ? this.groupeItemManager.getInternalGroupeItem(contexte.getGrille()) : this.groupeItemManager.getInternalGroupeItem(contexteParent);
        if (newInternalGroupeItem == null) {
            throw new IllegalStateException("groupeItemMissing : Il n'y a pas de GroupeItem pour la grille demand\u00e9e");
        }
        int currentMask = libitem.getMask();
        oldInternalGroupeItem.removeLibelleItem(libitem);
        newInternalGroupeItem.addLibelleItem(libitem);
    }

    void indexChanged(Term term, int newIndex) {
        LibelleItemImpl libitem = (LibelleItemImpl)this.libelleItemMap.get(term.getCode());
        if (libitem == null) {
            return;
        }
        GroupeItemImpl internalGroupeItem = libitem.getGroupeItemImpl();
        internalGroupeItem.translateLibelleItem(libitem, newIndex);
    }

    private class HorsgrilleLibelleItem
    implements LibelleItem,
    GroupeItem,
    ComboBoxModel {
        private final ColorSkin colorSkin = new ColorSkin("_default", Color.BLACK, Color.WHITE, Color.WHITE, Color.DARK_GRAY);
        private final int code;
        private final String libelle;
        private final CollationUnit collatedString;
        private Object obj;

        private HorsgrilleLibelleItem(Structure structure) {
            Contexte contexte = StructureUtils.getHorsgrilleContexte(structure);
            this.code = contexte.getCode();
            this.libelle = AtlasUtils.toLibelleString(contexte, LibelleItemManagerImpl.this.workingLang);
            this.collatedString = new CollationUnit(this.libelle, LibelleItemManagerImpl.this.collator);
        }

        @Override
        public CollationUnit getCollatedString() {
            return this.collatedString;
        }

        @Override
        public GroupeItem getGroupeItem() {
            return this;
        }

        @Override
        public int getGroupeIndex() {
            return -1;
        }

        @Override
        public int getGroupeSize() {
            return 0;
        }

        @Override
        public int getTermCode() {
            return this.code;
        }

        @Override
        public short getTermType() {
            return 5;
        }

        @Override
        public String toString() {
            return this.libelle;
        }

        @Override
        public ColorSkin getColorSkin() {
            return this.colorSkin;
        }

        @Override
        public GroupeItem getGroupeParent() {
            return null;
        }

        @Override
        public void addListDataListener(ListDataListener listDataListener) {
        }

        @Override
        public Object getElementAt(int index) {
            if (index != 0) {
                throw new IndexOutOfBoundsException();
            }
            return this;
        }

        @Override
        public int getSize() {
            return 1;
        }

        @Override
        public void removeListDataListener(ListDataListener listDataListener) {
        }

        @Override
        public Object getSelectedItem() {
            return this.obj;
        }

        @Override
        public void setSelectedItem(Object obj) {
            this.obj = obj;
        }

        @Override
        public boolean isActive() {
            return true;
        }
    }

    private class SortedDescripteurLibelleItemModel
    extends AbstractComboBoxModel {
        LibelleItemComparator comparator = LibelleItemComparator.getInstance();
        List<LibelleItemImpl> libelleItemList = new ArrayList<LibelleItemImpl>();

        private SortedDescripteurLibelleItemModel() {
        }

        void initAdd(LibelleItemImpl libItem) {
            this.libelleItemList.add(libItem);
        }

        void endInit() {
            Collections.sort(this.libelleItemList, this.comparator);
            int size = this.libelleItemList.size();
            for (int i = 0; i < size; ++i) {
                this.libelleItemList.get(i).setSortedDescripteurLibelleItemIndex(i);
            }
        }

        void addLibelleItem(LibelleItemImpl libItem) {
            int idx = Collections.binarySearch(this.libelleItemList, libItem, this.comparator);
            if (idx >= 0) {
                return;
            }
            int insertionPoint = -idx - 1;
            libItem.setSortedDescripteurLibelleItemIndex(insertionPoint);
            for (int i = insertionPoint; i < this.libelleItemList.size(); ++i) {
                this.libelleItemList.get(i).setSortedDescripteurLibelleItemIndex(i + 1);
            }
            this.libelleItemList.add(insertionPoint, libItem);
            this.fireIntervalAdded(this, insertionPoint, insertionPoint);
        }

        void removeLibelleItem(LibelleItemImpl libItem) {
            int index = libItem.getSortedDescripteurLibelleItemIndex();
            if (index < 0) {
                return;
            }
            libItem.setSortedDescripteurLibelleItemIndex(-1);
            for (int i = index + 1; i < this.libelleItemList.size(); ++i) {
                this.libelleItemList.get(i).setSortedDescripteurLibelleItemIndex(i - 1);
            }
            this.libelleItemList.remove(index);
            this.fireIntervalRemoved(this, index, index);
        }

        @Override
        public Object getElementAt(int index) {
            return this.libelleItemList.get(index);
        }

        @Override
        public int getSize() {
            return this.libelleItemList.size();
        }

        void fireContentsChanged(LibelleItemImpl libItem) {
            int index = libItem.getSortedDescripteurLibelleItemIndex();
            this.fireContentsChanged(this, index, index);
        }

        void libelleChanged(LibelleItemImpl libItem) {
            int oldindex = libItem.getSortedDescripteurLibelleItemIndex();
            this.libelleItemList.remove(oldindex);
            int newindex = Collections.binarySearch(this.libelleItemList, libItem, this.comparator);
            if (newindex >= 0) {
                throw new IllegalStateException("doublonInSortedDescripteurLibelleItemModel : une instance LibelleItem se trouve encore dans la liste alors qu'elle vient d'\u00eatre supprim\u00e9e");
            }
            newindex = -newindex - 1;
            this.libelleItemList.add(newindex, libItem);
            if (newindex == oldindex) {
                this.fireContentsChanged(this, newindex, newindex);
            } else if (newindex < oldindex) {
                for (int i = newindex; i <= oldindex; ++i) {
                    this.libelleItemList.get(i).setSortedDescripteurLibelleItemIndex(i);
                }
                this.fireContentsChanged(this, newindex, oldindex);
            } else if (newindex > oldindex) {
                for (int i = oldindex; i <= newindex; ++i) {
                    this.libelleItemList.get(i).setSortedDescripteurLibelleItemIndex(i);
                }
                this.fireContentsChanged(this, oldindex, newindex);
            }
        }
    }

    private class AvailableInGrilleContexteLibelleItemModel
    extends AbstractComboBoxModel
    implements ListDataListener {
        ListModel groupeItemModel;

        AvailableInGrilleContexteLibelleItemModel() {
            this.groupeItemModel = LibelleItemManagerImpl.this.groupeItemManager.getGroupeItemListModel((short)5);
        }

        @Override
        public Object getElementAt(int index) {
            if (index < 0 || index >= this.groupeItemModel.getSize() + 1) {
                throw new IndexOutOfBoundsException();
            }
            if (index == 0) {
                return LibelleItemManagerImpl.this.horsgrilleLibelleItem;
            }
            return LibelleItemManagerImpl.this.getLibelleItem(((GroupeItem)this.groupeItemModel.getElementAt(index - 1)).getTermCode());
        }

        @Override
        public int getSize() {
            return this.groupeItemModel.getSize() + 1;
        }

        @Override
        public void contentsChanged(ListDataEvent listDataEvent) {
            this.fireContentsChanged(this, listDataEvent.getIndex0() + 1, listDataEvent.getIndex1() + 1);
        }

        @Override
        public void intervalAdded(ListDataEvent listDataEvent) {
            this.fireIntervalAdded(this, listDataEvent.getIndex0() + 1, listDataEvent.getIndex1() + 1);
        }

        @Override
        public void intervalRemoved(ListDataEvent listDataEvent) {
            this.fireIntervalRemoved(this, listDataEvent.getIndex0() + 1, listDataEvent.getIndex1() + 1);
        }
    }
}

