/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.desmoservice.atlas;

import java.util.Collections;
import java.util.List;
import net.fichotheque.croisement.Croisement;
import net.fichotheque.croisement.CroisementChange;
import net.fichotheque.croisement.Croisements;
import net.fichotheque.croisement.Lien;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.utils.CroisementUtils;

public final class BdfAtlasUtils {
    public static final CroisementChange FILSREMOVE_CROISEMENTCHANGE = new FilsRemoveCroisementChange();

    private BdfAtlasUtils() {
    }

    public static int getTermCode(Motcle motcle, short termeType) {
        return motcle.getId() * 10 + termeType;
    }

    public static int getTermCode(int idsusbet, short termeType) {
        return idsusbet * 10 + termeType;
    }

    public static short getTypeFromTermCode(int code) {
        if (code <= 1) {
            return -1;
        }
        int reste = code % 10;
        if (reste == 0 || reste == 9) {
            return -1;
        }
        return (short)reste;
    }

    public static int getIdFromTermCode(int code) {
        return code / 10;
    }

    public static boolean isFamilleCroisement(Croisement croisement) {
        for (Lien lien : croisement.getLienList()) {
            if (!lien.getMode().equals("")) continue;
            return true;
        }
        return false;
    }

    public static boolean containsFamilleCroisement(Croisements croisements) {
        for (Croisements.Entry entry : croisements.getEntryList()) {
            if (!BdfAtlasUtils.isFamilleCroisement(entry.getCroisement())) continue;
            return true;
        }
        return false;
    }

    private static class FilsRemoveCroisementChange
    implements CroisementChange {
        private final List<String> removedModeList = Collections.singletonList("fils");

        private FilsRemoveCroisementChange() {
        }

        public List<String> getRemovedModeList() {
            return this.removedModeList;
        }

        public List<Lien> getChangedLienList() {
            return CroisementUtils.EMPTY_LIENLIST;
        }
    }
}

