/* global BDF, Dashboard */

Dashboard.Parameters = {};

Dashboard.Parameters.init = function () {
    Dashboard.Parameters.update();
};

Dashboard.Parameters.update = function () {
    Dashboard.Ajax.loadParameters(_callback);
    
    function _callback(data) {
        Dashboard.PARAMETERS = data;
        Dashboard.Parameters.initCorpusMap(data);
        Dashboard.$Content("parameters-tableexport").html(Dashboard.render("parameters/tableexport", _tableexportContext()));
        Dashboard.$Content("parameters-indexrelations").html(Dashboard.render("parameters/indexrelations", _indexrelationsContext()));
        Dashboard.$Content("parameters-corpuslist").html(Dashboard.render("parameters/corpuslist", _corpuslistContext()));
        Dashboard.$Content("parameters-newresource").html(Dashboard.render("parameters/newresource", _newresourceContext()));
    }
    
    function _tableexportContext() {
        var tableExportArray = Dashboard.PARAMETERS.tableExportArray;
        var tableexportContext = {
            name: Dashboard.Parameters.getAttributeValue("desmography:tableexport")
        };
        for(var i = 0, len = tableExportArray.length; i < len; i++) {
            var tableExport = tableExportArray[i];
            if (tableExport.name === tableexportContext.name) {
                tableexportContext.title = tableExport.title;
                break;
            }
        }
        return tableexportContext;
    }
    
    function _indexrelationsContext() {
        return {
            array: Dashboard.PARAMETERS.indexRelationArray
        };
    }
    
    function _corpuslistContext() {
        var corpusNames = Dashboard.Parameters.getAttributeValues("desmodojs:corpuslist");
        var list = new Array();
        for (var  i = 0, len = corpusNames.length; i < len; i++) {
            var name = corpusNames[i];
            list.push({
                name: "corpus_" + name,
                title: Dashboard.Parameters.getCorpusTitle(name)
            });
        }
        return {
            list: list
        };
    }
    
    function _newresourceContext() {
        var corpusName = Dashboard.Parameters.getAttributeValue("desmodojs:newresource");
        var title = "";
        if (!corpusName) {
            corpusName = Dashboard.Parameters.getAttributeValue("desmodojs:newdocument_corpus");
        }
        if (corpusName) {
            title = Dashboard.Parameters.getCorpusTitle(corpusName);
            corpusName = "corpus_" + corpusName;
        }
        return {
            name: corpusName,
            title: title
        };
    }

};

Dashboard.Parameters.getAttributeValue = function (key) {
    var metadata = Dashboard.PARAMETERS.thesaurusMetadata;
    if (metadata.attrMap.hasOwnProperty(key)) {
        return metadata.attrMap[key][0];
    } else {
        return "";
    }
};

Dashboard.Parameters.getAttributeValues = function (key) {
    var metadata = Dashboard.PARAMETERS.thesaurusMetadata;
    if (metadata.attrMap.hasOwnProperty(key)) {
        return metadata.attrMap[key];
    } else {
        return new Array();
    }
};

Dashboard.Parameters.getCorpusTitle = function (name) {
    var subsetKey = "corpus_" + name;
    if (Dashboard.CORPUSMAP.hasOwnProperty(subsetKey)) {
        return Dashboard.CORPUSMAP[subsetKey].title;
    } else {
        return "";
    }
};

Dashboard.Parameters.initCorpusMap = function (data) {
    var map = {};
    var tree = data.corpuslistCandidateTree;
    _scan(tree);
    Dashboard.CORPUSMAP = map;
    

    function _scan(nodeArray) {
        for(var i = 0, len = nodeArray.length; i < len; i++) {
            var obj = nodeArray[i];
            var nodeType = obj.node;
            if (nodeType === "subset") {
                map[obj.key] = obj;
            } else if (nodeType === "group") {
                _scan(obj.array);
            }
        }
    }
    
};

Dashboard.Parameters.editIndexRelations = function () {
    var context = {
        atlas: Dashboard.ATLAS,
        array: Dashboard.PARAMETERS.indexRelationArray
    };
    Overlay.start({
        header: BDF.escapeLoc("_ link.desmography.editindexrelations"),
        content: Dashboard.render("parameters/indexrelations-overlaycontent", context),
        footer: Dashboard.render("parameters/indexrelations-overlayfooter", {}),
        formAttrs: {
            action: Dashboard.getCommandAction(),
            method: "POST"
        },
        ajaxForm: {
            dataType: "json",
            success: function (data, textStatus, jqXHR, $form) {
                var done = BDF.Ajax.checkError(data);
                if (done) {
                    Overlay.end($form, function() {
                        Dashboard.Parameters.update();
                    });
                }
            }
        }
    });
};

Dashboard.Parameters.editTableExport = function () {
    Overlay.start({
        header: BDF.escapeLoc("_ link.desmography.edittableexport"),
        content: Dashboard.render("parameters/tableexport-overlaycontent", _context()),
        footer: Dashboard.render("parameters/tableexport-overlayfooter", {}),
        formAttrs: {
            action: Dashboard.getCommandAction(),
            method: "POST"
        },
        ajaxForm: {
            dataType: "json",
            success: function (data, textStatus, jqXHR, $form) {
                var done = BDF.Ajax.checkError(data);
                if (done) {
                    Overlay.end($form, function() {
                        Dashboard.Parameters.update();
                    });
                }
            }
        }
    });
    
    
    function _context() {
        var context = {
            atlas: Dashboard.ATLAS,
            langs: Dashboard.LANGS,
            array: []
        };
        var currentName = "";
        if (Dashboard.PARAMETERS.thesaurusMetadata.attrMap.hasOwnProperty("desmography:tableexport")) {
            currentName = Dashboard.PARAMETERS.thesaurusMetadata.attrMap["desmography:tableexport"][0];
        }
        for(var i = 0, len = Dashboard.PARAMETERS.tableExportArray.length; i < len; i++) {
            var tableExport = Dashboard.PARAMETERS.tableExportArray[i];
            var name = tableExport.name;

            context.array.push({
                name: name,
                selected: (name === currentName),
                title: tableExport.title
            });
        }
        return context;
    }
    
};

Dashboard.Parameters.editNewResource = function () {
    var currentCorpusName = Dashboard.Parameters.getAttributeValue("desmodojs:newresource");
    if (!currentCorpusName) {
        currentCorpusName = Dashboard.Parameters.getAttributeValue("desmodojs:newdocument_corpus");
    }
    var context = {
        atlas: Dashboard.ATLAS,
        array: []
    };
    _scan(Dashboard.PARAMETERS.newresourceCandidateTree, 0);
    Overlay.start({
        header: BDF.escapeLoc("_ link.desmography.editnewresource"),
        content: Dashboard.render("parameters/newresource-overlaycontent", context),
        footer: Dashboard.render("parameters/newresource-overlayfooter", {}),
        formAttrs: {
            action: Dashboard.getCommandAction(),
            method: "POST"
        },
        ajaxForm: {
            dataType: "json",
            success: function (data, textStatus, jqXHR, $form) {
                var done = BDF.Ajax.checkError(data);
                if (done) {
                    Overlay.end($form, function() {
                        Dashboard.Parameters.update();
                    });
                }
            }
        }
    });
    
    function _scan(nodeArray, level) {
        var indent = _indent(level);
        for(var i = 0, len = nodeArray.length; i < len; i++) {
            var obj = nodeArray[i];
            var nodeType = obj.node;
            if (nodeType === "subset") {
               var value = obj.key.substring("corpus_".length);
               var selected = (value === currentCorpusName);
               context.array.push({
                   type: "option",
                   indent: indent,
                   key: obj.key,
                   value: value,
                   title:  obj.title,
                   selected: selected
                });
            } else if (nodeType === "group") {
                context.array.push({
                   type: "optgroup",
                   indent: indent,
                   title: obj.title
                });
                _scan(obj.array, level + 1);
            }
        }
    }
    
    function _indent(level) {
        var result = "";
        for(var i = 0; i < level; i++) {
            result += "\u00A0 \u00A0 ";
        }
        return result;
    }
    
};

Dashboard.Parameters.editCorpusList = function () {
    var tree = Dashboard.PARAMETERS.corpuslistCandidateTree;
    var currentSelection = Dashboard.Parameters.getAttributeValues("desmodojs:corpuslist");
    _scan(tree);
    var context = {
        atlas: Dashboard.ATLAS,
        tree: tree
    };
    Overlay.start({
        header: BDF.escapeLoc("_ link.desmography.editnewresource"),
        content: Dashboard.render("parameters/corpuslist-overlaycontent", context),
        footer: Dashboard.render("parameters/corpuslist-overlayfooter", {}),
        formAttrs: {
            action: Dashboard.getCommandAction(),
            method: "POST"
        },
        afterStart: function ($overlayDialog) {
        },
        ajaxForm: {
            dataType: "json",
            success: function (data, textStatus, jqXHR, $form) {
                var done = BDF.Ajax.checkError(data);
                if (done) {
                    Overlay.end($form, function() {
                        Dashboard.Parameters.update();
                    });
                }
            }
        }
    });
    
    
    function _scan(nodeArray) {
        for(var i = 0, len = nodeArray.length; i < len; i++) {
            var obj = nodeArray[i];
            var nodeType = obj.node;
            if (nodeType === "subset") {
                var value = obj.key.substring("corpus_".length);
                obj.value = value;
                obj.checked = (currentSelection.indexOf(value) !== -1);
            } else if (nodeType === "group") {
                _scan(obj.array);
            }
        }
    }
    
};