/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.xml.api;

import java.text.ParseException;
import java.util.function.Consumer;
import net.desmodo.atlas.AtlasEditor;
import net.desmodo.atlas.xml.api.AtlasDOMErrorHandler;
import net.mapeadores.util.attr.Attribute;
import net.mapeadores.util.attr.AttributeBuilder;
import net.mapeadores.util.attr.AttributeKey;
import net.mapeadores.util.attr.CheckedLocalKey;
import net.mapeadores.util.attr.CheckedNameSpace;
import net.mapeadores.util.text.CleanedString;
import net.mapeadores.util.xml.DOMUtils;
import net.mapeadores.util.xml.XMLUtils;
import org.w3c.dom.Element;

public class AttributeDOMReader {
    private final AtlasEditor atlasEditor;
    private final AtlasDOMErrorHandler errorHandler;

    public AttributeDOMReader(AtlasEditor atlasEditor, AtlasDOMErrorHandler errorHandler) {
        this.atlasEditor = atlasEditor;
        this.errorHandler = errorHandler;
    }

    public void readAttrElement(Element element, Object attributesHolder, String xPath) {
        CheckedLocalKey localKey;
        CheckedNameSpace nameSpace;
        String nameSpaceString = element.getAttribute("ns");
        if (nameSpaceString.length() == 0) {
            this.errorHandler.missingAttributeError("ns", xPath + "/attr");
            return;
        }
        String localKeyString = element.getAttribute("key");
        if (localKeyString.length() == 0) {
            this.errorHandler.missingAttributeError("key", xPath + "/attr");
            return;
        }
        try {
            nameSpace = CheckedNameSpace.parse((CharSequence)nameSpaceString);
        }
        catch (ParseException pe) {
            this.errorHandler.wrongAttributeError("ns", nameSpaceString, "Malformed", xPath + "/attr");
            return;
        }
        try {
            localKey = CheckedLocalKey.parse((CharSequence)localKeyString);
        }
        catch (ParseException pe) {
            this.errorHandler.wrongAttributeError("key", localKeyString, "Malformed", xPath + "/attr");
            return;
        }
        AttributeKey attributeKey = AttributeKey.build((CheckedNameSpace)nameSpace, (CheckedLocalKey)localKey);
        AttributeConsumer attributeConsumer = new AttributeConsumer(attributeKey, xPath);
        DOMUtils.readChildren((Element)element, (Consumer)attributeConsumer);
        Attribute attribute = attributeConsumer.toAttribute();
        if (attribute != null) {
            this.atlasEditor.putAttribute(attributesHolder, attribute);
        }
    }

    private class AttributeConsumer
    implements Consumer<Element> {
        private final AttributeBuilder attributeBuilder;
        private final String xPath;

        public AttributeConsumer(AttributeKey attributeKey, String xPath) {
            this.attributeBuilder = new AttributeBuilder(attributeKey);
            this.xPath = xPath;
        }

        public Attribute toAttribute() {
            return this.attributeBuilder.toAttribute();
        }

        @Override
        public void accept(Element element) {
            String tagName = element.getTagName();
            if (tagName.equals("val")) {
                CleanedString cs = XMLUtils.toCleanedString((Element)element);
                if (cs != null) {
                    this.attributeBuilder.addValue(cs);
                } else {
                    AttributeDOMReader.this.errorHandler.emptyElementError(this.xPath + "/val");
                }
            } else {
                AttributeDOMReader.this.errorHandler.unknownTagWarning(tagName, this.xPath);
            }
        }
    }
}

