/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.impl;

import net.desmodo.atlas.descripteurs.Descripteur;
import net.desmodo.atlas.descripteurs.DescripteurList;
import net.desmodo.atlas.liens.LienStructurel;
import net.desmodo.atlas.structure.Contexte;
import net.mapeadores.util.misc.ArrayUtils;

class LienStructurelImpl
implements LienStructurel {
    private final Contexte term1;
    private final Contexte term2;
    private Descripteur[] descripteurs;
    private final boolean isLienSurLuiMeme;
    private final InternalDescripteurList descripteurList = new InternalDescripteurList();

    LienStructurelImpl(Contexte term1, Contexte term2) {
        this.term1 = term1;
        this.term2 = term2;
        this.isLienSurLuiMeme = term1.equals(term2);
        this.descripteurs = new Descripteur[0];
    }

    @Override
    public Contexte getContexte1() {
        return this.term1;
    }

    @Override
    public Contexte getContexte2() {
        return this.term2;
    }

    @Override
    public boolean isLienSurLuiMeme() {
        return this.isLienSurLuiMeme;
    }

    @Override
    public DescripteurList getDescripteurList() {
        return this.descripteurList;
    }

    int addDescripteur(Descripteur descripteur) {
        Descripteur[] nv = new Descripteur[this.descripteurs.length + 1];
        System.arraycopy(this.descripteurs, 0, nv, 0, this.descripteurs.length);
        nv[this.descripteurs.length] = descripteur;
        this.descripteurs = nv;
        return nv.length - 1;
    }

    int addDescripteur(Descripteur descripteur, int n) {
        int actu = this.descripteurs.length;
        if (n < 0 || n >= actu) {
            return this.addDescripteur(descripteur);
        }
        Descripteur[] nv = new Descripteur[actu + 1];
        nv[n] = descripteur;
        System.arraycopy(this.descripteurs, 0, nv, 0, n);
        System.arraycopy(this.descripteurs, n, nv, n + 1, actu - n);
        this.descripteurs = nv;
        return n;
    }

    Descripteur setIndex(int n1, int n2) {
        if (n2 < 0 || n2 >= this.descripteurs.length) {
            n2 = this.descripteurs.length - 1;
        }
        return (Descripteur)ArrayUtils.move((Object[])this.descripteurs, (int)n1, (int)n2);
    }

    int removeDescripteur(Descripteur descripteur) {
        int actu = this.descripteurs.length;
        Descripteur[] copie = new Descripteur[actu - 1];
        if (this.descripteurs[actu - 1].equals(descripteur)) {
            System.arraycopy(this.descripteurs, 0, copie, 0, actu - 1);
            this.descripteurs = copie;
            return actu - 1;
        }
        int ordre = -1;
        int p = 0;
        for (int i = 0; i < actu - 1; ++i) {
            if (this.descripteurs[i].equals(descripteur)) {
                ordre = i;
                continue;
            }
            copie[p] = this.descripteurs[i];
            ++p;
        }
        if (ordre == -1) {
            return -1;
        }
        copie[actu - 2] = this.descripteurs[actu - 1];
        this.descripteurs = copie;
        return ordre;
    }

    private class InternalDescripteurList
    implements DescripteurList {
        private InternalDescripteurList() {
        }

        @Override
        public Descripteur getDescripteur(int index) {
            return LienStructurelImpl.this.descripteurs[index];
        }

        @Override
        public int getDescripteurCount() {
            return LienStructurelImpl.this.descripteurs.length;
        }
    }
}

