/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.display.layers.common;

import java.awt.Graphics2D;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.desmodo.atlas.AtlasAttributes;
import net.desmodo.atlas.Term;
import net.desmodo.atlas.descripteurs.Descripteur;
import net.desmodo.atlas.display.blocks.BlockLocator;
import net.desmodo.atlas.display.blocks.LibelleBlock;
import net.desmodo.atlas.display.blocks.LinkBlock;
import net.desmodo.atlas.display.layers.Layer;
import net.desmodo.atlas.display.layers.common.LinkLayerDisplay;
import net.mapeadores.util.attr.Attribute;

public class LinkLayer
implements Layer {
    private LinkBlock[] linkBlockArray = new LinkBlock[0];
    private BlockLocator blockLocator;
    private String name;
    private int index;

    @Override
    public void setBlockLocator(BlockLocator blockLocator) {
        this.blockLocator = blockLocator;
    }

    @Override
    public void update() {
        ArrayList<LinkBlock> blockList = new ArrayList<LinkBlock>();
        this.addBlocks(blockList, this.blockLocator.getActiveLibelleBlockList());
        this.addBlocks(blockList, this.blockLocator.getLiaisonBlockList());
        int size = blockList.size();
        this.linkBlockArray = new LinkBlock[size];
        for (int i = 0; i < size; ++i) {
            this.linkBlockArray[i] = (LinkBlock)blockList.get(i);
        }
    }

    public LinkBlock getLinkBlockAtP(Point P) {
        int size = this.linkBlockArray.length;
        for (int i = 0; i < size; ++i) {
            if (!this.linkBlockArray[i].contains(P)) continue;
            return this.linkBlockArray[i];
        }
        return null;
    }

    public List getLinkBlockList() {
        return Arrays.asList(this.linkBlockArray);
    }

    @Override
    public void paintLayer(Graphics2D g) {
        LinkLayerDisplay.paint(this, g);
    }

    private void addBlocks(List<LinkBlock> blockList, List libelleBlockList) {
        for (LibelleBlock libelleBlock : libelleBlockList) {
            this.addBlock(blockList, libelleBlock);
        }
    }

    private void addBlock(List<LinkBlock> blockList, LibelleBlock libelleBlock) {
        Descripteur descripteur;
        Attribute attribute;
        Term term = libelleBlock.getTerm();
        if (term instanceof Descripteur && (attribute = (descripteur = (Descripteur)term).getAttributes().getAttribute(AtlasAttributes.URL_KEY)) != null) {
            LinkBlock linkBlock = new LinkBlock(attribute.getFirstValue(), libelleBlock);
            blockList.add(linkBlock);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public void setIndex(int index) {
        this.index = index;
    }
}

