/* BdfServer - Copyright (c) 2019-2025 Vincent Calame - Exemole
 * Logiciel libre donné sous triple licence :
 * 1) selon les termes de la CeCILL V2
 * 2) selon les termes de l’EUPL V.1.1
 * 3) selon les termes de la GNU GPLv3
 * Voir le fichier licences.txt
 */


package net.fichotheque.tools.exportation.transformation;

import net.fichotheque.exportation.transformation.TemplateContentDescription;
import net.fichotheque.exportation.transformation.TemplateKey;
import net.mapeadores.util.logging.LineLogs;
import net.mapeadores.util.logging.LineLogsBuilder;
import net.mapeadores.util.logging.LineMessage;
import net.mapeadores.util.logging.LineMessageHandler;


/**
 *
 * @author Vincent Calame
 */
public class TemplateContentDescriptionBuilder implements LineMessageHandler {

    private final LineLogsBuilder lineLogsBuilder = new LineLogsBuilder();
    private final TemplateKey templateKey;
    private final String path;
    private final String type;
    private boolean mandatory;
    private String state = TemplateContentDescription.OK_STATE;

    public TemplateContentDescriptionBuilder(TemplateKey templateKey, String path, String type) {
        this.templateKey = templateKey;
        this.path = path;
        this.type = type;
    }

    @Override
    public void addMessage(LineMessage message) {
        state = TemplateContentDescription.XML_ERROR_STATE;
        lineLogsBuilder.addMessage(message);
    }

    public TemplateContentDescriptionBuilder setMandatory(boolean mandatory) {
        this.mandatory = mandatory;
        return this;
    }

    public TemplateContentDescription toTemplateContentDescription() {
        return new InternalTemplateContentDescription(templateKey, path, type, mandatory, state, lineLogsBuilder.toLineLogs());
    }

    public static TemplateContentDescriptionBuilder init(TemplateKey templateKey, String path, String type) {
        return new TemplateContentDescriptionBuilder(templateKey, path, type);
    }


    private static class InternalTemplateContentDescription implements TemplateContentDescription {

        private final TemplateKey templateKey;
        private final String path;
        private final String type;
        private final boolean mandatory;
        private final String state;
        private final LineLogs lineLogs;


        private InternalTemplateContentDescription(TemplateKey templateKey, String path, String type, boolean mandatory, String state, LineLogs lineLogs) {
            this.templateKey = templateKey;
            this.path = path;
            this.type = type;
            this.mandatory = mandatory;
            this.state = state;
            this.lineLogs = lineLogs;
        }

        @Override
        public TemplateKey getTemplateKey() {
            return templateKey;
        }

        @Override
        public String getPath() {
            return path;
        }

        @Override
        public String getType() {
            return type;
        }

        @Override
        public boolean isMandatory() {
            return mandatory;
        }

        @Override
        public String getState() {
            return state;
        }

        @Override
        public LineLogs getLineLogs() {
            return lineLogs;
        }

    }

}
