/* FichothequeLib_Tools - Copyright (c) 2019-2025 Vincent Calame - Exemole
 * Logiciel libre donné sous triple licence :
 * 1) selon les termes de la CeCILL V2
 * 2) selon les termes de l’EUPL V.1.1
 * 3) selon les termes de la GNU GPLv3
 * Voir le fichier licences.txt
 */


package net.fichotheque.tools.exportation.balayage;

import net.fichotheque.exportation.balayage.BalayageContentDescription;
import net.mapeadores.util.logging.LineLogs;
import net.mapeadores.util.logging.LineLogsBuilder;
import net.mapeadores.util.logging.LineMessageHandler;


/**
 *
 * @author Vincent Calame
 */
public class BalayageContentDescriptionBuilder {

    private final LineLogsBuilder lineLogsBuilder = new LineLogsBuilder();
    private final String balayageName;
    private final String path;

    public BalayageContentDescriptionBuilder(String balayageName, String path) {
        this.balayageName = balayageName;
        this.path = path;
    }

    public LineMessageHandler getLineMessageHandler() {
        return lineLogsBuilder;
    }

    public BalayageContentDescription toBalayageContentDescription() {
        LineLogs lineLogs = lineLogsBuilder.toLineLogs();
        short state = (lineLogs.isEmpty()) ? BalayageContentDescription.OK_STATE : BalayageContentDescription.XML_ERROR_STATE;
        return new InternalBalayageContentDescription(balayageName, path, state, lineLogs);
    }

    public static BalayageContentDescriptionBuilder init(String balayageName, String path) {
        return new BalayageContentDescriptionBuilder(balayageName, path);
    }


    private static class InternalBalayageContentDescription implements BalayageContentDescription {

        private final String balayageName;
        private final String path;
        private final short state;
        private final LineLogs lineLogs;

        private InternalBalayageContentDescription(String balayageName, String path, short state, LineLogs lineLogs) {
            this.balayageName = balayageName;
            this.path = path;
            this.state = state;
            this.lineLogs = lineLogs;
        }

        @Override
        public String getBalayageName() {
            return balayageName;
        }

        @Override
        public String getPath() {
            return path;
        }

        @Override
        public short getState() {
            return state;
        }

        @Override
        public LineLogs getLineLogs() {
            return lineLogs;
        }

    }

}
